/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.expr.ExpressionParser;
import com.threerings.io.Streamable;
import com.threerings.probs.FloatVariable;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.io.Reader;
import java.io.StringReader;

@EditorTypes(value={Parsed.class, Constant.class, Reference.class, Previous.class, Increment.class, Decrement.class, Negate.class, Add.class, Subtract.class, Multiply.class, Divide.class, Remainder.class, Not.class, And.class, Or.class, Xor.class, Less.class, Greater.class, Equals.class, LessEquals.class, GreaterEquals.class, Variable.class, NumTargets.class})
@Strippable
public abstract class ExpressionConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract String getLogicClassName();

    public void invalidate() {
    }

    protected static ExpressionConfig parseExpression(String expression) throws Exception {
        return (ExpressionConfig)new ExpressionParser<ExpressionConfig>((Reader)new StringReader(expression)){

            @Override
            protected ExpressionConfig handleNumber(double value) {
                return new Constant(String.valueOf(value));
            }

            @Override
            protected ExpressionConfig handleString(String value) {
                return new Constant(value);
            }

            @Override
            protected ExpressionConfig handleOperator(String operator, int arity) throws Exception {
                BinaryOperation result;
                if (arity == 1) {
                    UnaryOperation result2;
                    if (operator.equals("++")) {
                        result2 = new Increment();
                    } else if (operator.equals("--")) {
                        result2 = new Decrement();
                    } else {
                        if (operator.equals("+")) {
                            return (ExpressionConfig)this._output.pop();
                        }
                        if (operator.equals("-")) {
                            result2 = new Negate();
                        } else if (operator.equals("!")) {
                            result2 = new Not();
                        } else {
                            return (ExpressionConfig)super.handleOperator(operator, arity);
                        }
                    }
                    result2.operand = (ExpressionConfig)this._output.pop();
                    return result2;
                }
                if (operator.equals("+")) {
                    result = new Add();
                } else if (operator.equals("-")) {
                    result = new Subtract();
                } else if (operator.equals("*")) {
                    result = new Multiply();
                } else if (operator.equals("/")) {
                    result = new Divide();
                } else if (operator.equals("%")) {
                    result = new Remainder();
                } else if (operator.equals("&") || operator.equals("&&")) {
                    result = new And();
                } else if (operator.equals("|") || operator.equals("||")) {
                    result = new Or();
                } else if (operator.equals("^")) {
                    result = new Xor();
                } else if (operator.equals("<")) {
                    result = new Less();
                } else if (operator.equals(">")) {
                    result = new Greater();
                } else if (operator.equals("=") || operator.equals("==")) {
                    result = new Equals();
                } else if (operator.equals("<=")) {
                    result = new LessEquals();
                } else if (operator.equals(">=")) {
                    result = new GreaterEquals();
                } else {
                    return (ExpressionConfig)super.handleOperator(operator, arity);
                }
                result.secondOperand = (ExpressionConfig)this._output.pop();
                result.firstOperand = (ExpressionConfig)this._output.pop();
                return result;
            }

            @Override
            protected ExpressionConfig handleIdentifier(String name) {
                if (name.equalsIgnoreCase("null") || name.equalsIgnoreCase("true") || name.equalsIgnoreCase("false")) {
                    return new Constant(name);
                }
                if (name.equalsIgnoreCase("previous")) {
                    return new Previous();
                }
                Reference ref = new Reference();
                ref.name = name;
                return ref;
            }
        }.parse();
    }

    public static class Add
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Add";
        }
    }

    public static class And
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$And";
        }
    }

    public static abstract class BinaryOperation
    extends ExpressionConfig {
        @Editable
        public ExpressionConfig firstOperand = new Constant();
        @Editable
        public ExpressionConfig secondOperand = new Constant();

        @Override
        public void invalidate() {
            this.firstOperand.invalidate();
            this.secondOperand.invalidate();
        }
    }

    public static class Constant
    extends ExpressionConfig {
        @Editable
        public String value = "";

        public Constant(String value) {
            this.value = value;
        }

        public Constant() {
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Constant";
        }
    }

    public static class Decrement
    extends UnaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Decrement";
        }
    }

    public static class Divide
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Divide";
        }
    }

    public static class Equals
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Equals";
        }
    }

    public static class Greater
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Greater";
        }
    }

    public static class GreaterEquals
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$GreaterEquals";
        }
    }

    public static class Increment
    extends UnaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Increment";
        }
    }

    public static class Less
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Less";
        }
    }

    public static class LessEquals
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$LessEquals";
        }
    }

    public static class Multiply
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Multiply";
        }
    }

    public static class Negate
    extends UnaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Negate";
        }
    }

    public static class Not
    extends UnaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Not";
        }
    }

    public static class NumTargets
    extends ExpressionConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Tagged();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$NumTargets";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Or
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Or";
        }
    }

    public static class Parsed
    extends ExpressionConfig {
        @Editable(width=20)
        public String expression = "";
        @DeepOmit
        protected transient ExpressionConfig _expr;

        public ExpressionConfig getExpression() {
            if (this._expr == null) {
                try {
                    this._expr = Parsed.parseExpression(this.expression);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._expr == null) {
                    this._expr = new Constant();
                }
            }
            return this._expr;
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Parsed";
        }

        @Override
        public void invalidate() {
            this._expr = null;
        }
    }

    public static class Previous
    extends ExpressionConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Previous";
        }
    }

    public static class Reference
    extends ExpressionConfig {
        @Editable
        public String name = "";
        @Editable
        public TargetConfig target = new TargetConfig.Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Reference";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Remainder
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Remainder";
        }
    }

    public static class Subtract
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Subtract";
        }
    }

    public static abstract class UnaryOperation
    extends ExpressionConfig {
        @Editable
        public ExpressionConfig operand = new Constant();

        @Override
        public void invalidate() {
            this.operand.invalidate();
        }
    }

    public static class Variable
    extends ExpressionConfig {
        @Editable
        public FloatVariable variable = new FloatVariable.Constant(0.0f);

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Variable";
        }
    }

    public static class Xor
    extends BinaryOperation {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ExpressionLogic$Xor";
        }
    }
}

