/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.HashIntSet;
import com.samskivert.util.IntTuple;
import com.samskivert.util.StringUtil;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.event.ControllerEvent;
import com.threerings.opengl.gui.event.ControllerListener;
import com.threerings.opengl.gui.event.KeyEvent;
import com.threerings.opengl.gui.event.KeyListener;
import com.threerings.opengl.gui.event.MouseAdapter;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.MouseWheelListener;
import com.threerings.util.MessageBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;

public class PseudoKeys {
    public static final int KEY_BUTTON1 = 256;
    public static final int KEY_BUTTON2 = 257;
    public static final int KEY_BUTTON3 = 258;
    public static final int KEY_WHEEL_UP = 259;
    public static final int KEY_WHEEL_DOWN = 260;
    public static final int KEY_CONTROLLER_BUTTON = 261;
    public static final int KEY_CONTROLLER_AXIS_POSITIVE = 262;
    public static final int KEY_CONTROLLER_AXIS_NEGATIVE = 263;
    public static final int KEY_CONTROLLER_POV_X_POSITIVE = 264;
    public static final int KEY_CONTROLLER_POV_X_NEGATIVE = 265;
    public static final int KEY_CONTROLLER_POV_Y_POSITIVE = 266;
    public static final int KEY_CONTROLLER_POV_Y_NEGATIVE = 267;
    public static final int KEY_BUTTON4 = 268;
    public static final int KEY_BUTTON5 = 269;
    public static final int KEY_BUTTON6 = 270;
    public static final int KEY_BUTTON7 = 271;
    public static final int KEY_BUTTON8 = 272;
    public static final int KEY_BUTTON9 = 273;
    public static final int KEY_BUTTON10 = 274;
    public static final int KEY_BUTTON11 = 275;
    public static final int KEY_BUTTON12 = 276;
    public static final int KEY_BUTTON13 = 277;
    public static final int KEY_BUTTON14 = 278;
    public static final int KEY_BUTTON15 = 279;
    public static final int KEY_BUTTON16 = 280;
    public static final int KEY_MODIFIER1 = 0x10000000;
    public static final int KEY_MODIFIER2 = 0x20000000;
    public static final int KEY_MODIFIER3 = 0x40000000;
    public static final int KEY_MODIFIER4 = Integer.MIN_VALUE;
    public static final int KEY_MODIFIER_MASK = -268435456;
    public static final int[] KEY_MODIFIERS = new int[]{0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};
    protected static ListMultimap<Integer, Integer> _modifierToKeys = ArrayListMultimap.create();

    public static int getMouseKey(int button) {
        switch (button) {
            case 0: {
                return 256;
            }
            case 1: {
                return 257;
            }
            case 2: {
                return 258;
            }
            case 3: {
                return 268;
            }
            case 4: {
                return 269;
            }
            case 5: {
                return 270;
            }
            case 6: {
                return 271;
            }
            case 7: {
                return 272;
            }
            case 8: {
                return 273;
            }
            case 9: {
                return 274;
            }
            case 10: {
                return 275;
            }
            case 11: {
                return 276;
            }
            case 12: {
                return 277;
            }
            case 13: {
                return 278;
            }
            case 14: {
                return 279;
            }
            case 15: {
                return 279;
            }
        }
        return 0;
    }

    public static int getControllerKey(int type, int controllerIndex, int controlIndex) {
        return 0xFFFFFFF & (controllerIndex << 24 | controlIndex << 16 | type);
    }

    public static boolean isValid(int key) {
        if (!Controllers.isCreated()) {
            try {
                Controllers.create();
            }
            catch (LWJGLException e) {
                Log.log.warning((Object)"Failed to create controllers.", new Object[]{e});
            }
        }
        switch (PseudoKeys.getType(key)) {
            case 261: {
                int controllerIndex = PseudoKeys.getControllerIndex(key);
                return controllerIndex < Controllers.getControllerCount() && PseudoKeys.getControlIndex(key) < Controllers.getController((int)controllerIndex).getButtonCount();
            }
            case 262: 
            case 263: {
                int controllerIndex = PseudoKeys.getControllerIndex(key);
                return controllerIndex < Controllers.getControllerCount() && PseudoKeys.getControlIndex(key) < Controllers.getController((int)controllerIndex).getAxisCount();
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                return PseudoKeys.getControllerIndex(key) < Controllers.getControllerCount();
            }
        }
        return true;
    }

    public static String getDesc(MessageBundle msgs, int key) {
        String result;
        int baseKey = PseudoKeys.getBaseKey(key);
        ArrayList modifiers = Lists.newArrayList();
        int ii = 0;
        while (ii < KEY_MODIFIERS.length) {
            block15: {
                if (PseudoKeys.hasModifierKey(key, KEY_MODIFIERS[ii])) {
                    List keys = _modifierToKeys.get((Object)KEY_MODIFIERS[ii]);
                    if (keys.isEmpty()) {
                        modifiers.add("k.modifier_" + (ii + 1));
                    } else {
                        boolean isController = PseudoKeys.isControllerKey(baseKey);
                        boolean isMouse = PseudoKeys.isMouseKey(baseKey);
                        boolean isKey = PseudoKeys.isKeyboardKey(baseKey);
                        Iterator iterator = keys.iterator();
                        while (iterator.hasNext()) {
                            int k = (Integer)iterator.next();
                            if (isController != PseudoKeys.isControllerKey(k) && isMouse != PseudoKeys.isMouseKey(k) && isKey != PseudoKeys.isKeyboardKey(k)) continue;
                            modifiers.add(MessageBundle.taint((Object)PseudoKeys.getDesc(msgs, k)));
                            break block15;
                        }
                        modifiers.add(MessageBundle.taint((Object)PseudoKeys.getDesc(msgs, (Integer)keys.iterator().next())));
                    }
                }
            }
            ++ii;
        }
        switch (PseudoKeys.getType(baseKey)) {
            case 261: {
                int idx = PseudoKeys.getControllerIndex(baseKey);
                result = MessageBundle.tcompose((String)"m.controller_button", (Object)String.valueOf(idx), (Object)Controllers.getController((int)idx).getButtonName(PseudoKeys.getControlIndex(baseKey)));
                break;
            }
            case 262: {
                int idx = PseudoKeys.getControllerIndex(baseKey);
                result = MessageBundle.tcompose((String)"m.controller_axis_positive", (Object)String.valueOf(idx), (Object)Controllers.getController((int)idx).getAxisName(PseudoKeys.getControlIndex(baseKey)));
                break;
            }
            case 263: {
                int idx = PseudoKeys.getControllerIndex(baseKey);
                result = MessageBundle.tcompose((String)"m.controller_axis_negative", (Object)String.valueOf(idx), (Object)Controllers.getController((int)idx).getAxisName(PseudoKeys.getControlIndex(baseKey)));
                break;
            }
            case 264: {
                result = MessageBundle.tcompose((String)"m.controller_pov_x_positive", (Object)String.valueOf(PseudoKeys.getControllerIndex(baseKey)));
                break;
            }
            case 265: {
                result = MessageBundle.tcompose((String)"m.controller_pov_x_negative", (Object)String.valueOf(PseudoKeys.getControllerIndex(baseKey)));
                break;
            }
            case 266: {
                result = MessageBundle.tcompose((String)"m.controller_pov_y_positive", (Object)String.valueOf(PseudoKeys.getControllerIndex(baseKey)));
                break;
            }
            case 267: {
                result = MessageBundle.tcompose((String)"m.controller_pov_y_negative", (Object)String.valueOf(PseudoKeys.getControllerIndex(baseKey)));
                break;
            }
            default: {
                String name = PseudoKeys.getName(baseKey);
                String mkey = "k." + StringUtil.toUSLowerCase((String)name);
                String string = result = msgs.exists(mkey) ? mkey : MessageBundle.taint((Object)name);
            }
        }
        if (!modifiers.isEmpty()) {
            modifiers.add(result);
            result = MessageBundle.compose((String)("m.control-list." + modifiers.size()), (Object[])modifiers.toArray());
        }
        return msgs.xlate(result);
    }

    public static String getName(int key) {
        switch (PseudoKeys.getType(key)) {
            case 256: {
                return "BUTTON1";
            }
            case 257: {
                return "BUTTON2";
            }
            case 258: {
                return "BUTTON3";
            }
            case 268: {
                return "BUTTON4";
            }
            case 269: {
                return "BUTTON5";
            }
            case 259: {
                return "WHEEL_UP";
            }
            case 260: {
                return "WHEEL_DOWN";
            }
            case 261: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_BUTTON" + PseudoKeys.getControlIndex(key);
            }
            case 262: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_AXIS" + PseudoKeys.getControlIndex(key) + "_POSITIVE";
            }
            case 263: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_AXIS" + PseudoKeys.getControlIndex(key) + "_NEGATIVE";
            }
            case 264: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_X_POSITIVE";
            }
            case 265: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_X_NEGATIVE";
            }
            case 266: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_Y_POSITIVE";
            }
            case 267: {
                return "CONTROLLER" + PseudoKeys.getControllerIndex(key) + "_POV_Y_NEGATIVE";
            }
        }
        return Keyboard.getKeyName((int)key);
    }

    public static int getType(int key) {
        return key & 0xFFFF;
    }

    public static int getControllerIndex(int key) {
        return PseudoKeys.getBaseKey(key) >>> 24;
    }

    public static int getControlIndex(int key) {
        return key >> 16 & 0xFF;
    }

    public static boolean isAnalogKey(int key) {
        switch (PseudoKeys.getType(key)) {
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMouseKey(int key) {
        switch (PseudoKeys.getType(key)) {
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 268: 
            case 269: {
                return true;
            }
        }
        return false;
    }

    public static boolean isKeyboardKey(int key) {
        return key < 256 && key != 0;
    }

    public static boolean isControllerKey(int key) {
        return PseudoKeys.isAnalogKey(key) || PseudoKeys.getType(key) == 261;
    }

    public static int getBaseKey(int key) {
        return key & 0xFFFFFFF;
    }

    public static boolean hasModifierKey(int key, int modifier) {
        return (key & modifier) != 0;
    }

    public static boolean hasAnyModifierKeys(int key) {
        return (key & 0xF0000000) != 0;
    }

    public static void addModifierKey(int key, int modKey) {
        if (!_modifierToKeys.containsEntry((Object)modKey, (Object)key)) {
            _modifierToKeys.put((Object)modKey, (Object)key);
        }
    }

    public static void clearModifierKeys() {
        _modifierToKeys.clear();
    }

    public static class Adapter
    implements Observer {
        @Override
        public void keyPressed(long when, int key, float amount) {
        }

        @Override
        public void keyReleased(long when, int key) {
        }
    }

    public static interface Observer {
        public void keyPressed(long var1, int var3, float var4);

        public void keyReleased(long var1, int var3);
    }

    public static class Unifier
    extends MouseAdapter
    implements KeyListener,
    MouseWheelListener,
    ControllerListener {
        protected Observer _observer;
        protected Map<IntTuple, Integer> _axes = Maps.newHashMap();
        protected Map<Integer, Integer> _povx = Maps.newHashMap();
        protected Map<Integer, Integer> _povy = Maps.newHashMap();
        protected HashIntSet _pressedKeys = new HashIntSet();
        protected int _pressedModifiers;
        protected Map<Integer, Integer> _modifierMap = Maps.newHashMap();
        protected HashIntSet _modifierUsers = new HashIntSet();
        protected boolean _consume;

        public Unifier(Observer observer) {
            this._observer = observer;
        }

        public Unifier(boolean consume) {
            this._consume = consume;
        }

        public Unifier() {
            this(false);
        }

        public void keyPressed(long when, int key, float amount) {
            if (this._observer == null) {
                return;
            }
            int modKey = this.getModifierKey(key);
            if (modKey == 0 && !this._modifierUsers.contains(key)) {
                this._observer.keyPressed(when, key, amount);
                return;
            }
            if (modKey == 0) {
                key = this.applyModifierKeys(key);
                this._pressedKeys.add(key);
                this._observer.keyPressed(when, key, amount);
            } else {
                this.holdModifierKey(modKey, true);
                Iterator iterator = this.currentPressedKeys().iterator();
                while (iterator.hasNext()) {
                    int m = (Integer)iterator.next();
                    this._observer.keyReleased(when, m);
                    this._pressedKeys.remove(m);
                    m = this.applyModifierKeys(m);
                    this._pressedKeys.add(m);
                    this._observer.keyPressed(when, m, amount);
                }
            }
        }

        public void keyReleased(long when, int key) {
            if (this._observer == null) {
                return;
            }
            int modKey = this.getModifierKey(key);
            if (modKey == 0 && !this._modifierUsers.contains(key)) {
                this._observer.keyReleased(when, key);
                return;
            }
            if (modKey == 0) {
                key = this.applyModifierKeys(key);
                this._observer.keyReleased(when, key);
                this._pressedKeys.remove(key);
            } else {
                this.holdModifierKey(modKey, false);
                Iterator iterator = this.currentPressedKeys().iterator();
                while (iterator.hasNext()) {
                    int m = (Integer)iterator.next();
                    if (!PseudoKeys.hasModifierKey(m, modKey)) continue;
                    this._observer.keyReleased(when, m);
                    this._pressedKeys.remove(m);
                    m = this.applyModifierKeys(PseudoKeys.getBaseKey(m));
                    this._pressedKeys.add(m);
                    this._observer.keyPressed(when, m, 1.0f);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (!event.isConsumed() && !event.isRepeat()) {
                this.keyPressed(event.getWhen(), event.getKeyCode(), 1.0f);
                if (this._consume) {
                    event.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (!event.isConsumed()) {
                this.keyReleased(event.getWhen(), event.getKeyCode());
                if (this._consume) {
                    event.consume();
                }
            }
        }

        @Override
        public void mouseWheeled(MouseEvent event) {
            if (event.isConsumed()) {
                return;
            }
            long when = event.getWhen();
            int delta = event.getDelta();
            if (delta > 0) {
                this.keyPressed(when, 259, delta);
                this.keyReleased(when, 259);
            } else {
                this.keyPressed(when, 260, -delta);
                this.keyReleased(when, 260);
            }
            if (this._consume) {
                event.consume();
            }
        }

        @Override
        public void controllerPressed(ControllerEvent event) {
            if (!event.isConsumed()) {
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(261, event.getController().getIndex(), event.getControlIndex()), 1.0f);
                if (this._consume) {
                    event.consume();
                }
            }
        }

        @Override
        public void controllerReleased(ControllerEvent event) {
            if (!event.isConsumed()) {
                this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(261, event.getController().getIndex(), event.getControlIndex()));
                if (this._consume) {
                    event.consume();
                }
            }
        }

        @Override
        public void controllerMoved(ControllerEvent event) {
            float dead;
            if (event.isConsumed()) {
                return;
            }
            Controller controller = event.getController();
            int controllerIndex = controller.getIndex();
            int axisIndex = event.getControlIndex();
            float value = controller.getAxisValue(axisIndex);
            if (value > (dead = controller.getDeadZone(axisIndex))) {
                Integer okey = this._axes.put(new IntTuple(controllerIndex, axisIndex), 262);
                if (okey != null && okey == 263) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, axisIndex));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(262, controllerIndex, axisIndex), value);
            } else if (value < -dead) {
                Integer okey = this._axes.put(new IntTuple(controllerIndex, axisIndex), 263);
                if (okey != null && okey == 262) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, axisIndex));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(263, controllerIndex, axisIndex), -value);
            } else {
                Integer okey = this._axes.remove(new IntTuple(controllerIndex, axisIndex));
                if (okey != null) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, axisIndex));
                }
            }
            if (this._consume) {
                event.consume();
            }
        }

        @Override
        public void controllerPovXMoved(ControllerEvent event) {
            if (event.isConsumed()) {
                return;
            }
            Controller controller = event.getController();
            int controllerIndex = controller.getIndex();
            float value = controller.getPovX();
            if (value > 0.0f) {
                Integer okey = this._povx.put(controllerIndex, 264);
                if (okey != null && okey == 265) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(264, controllerIndex, 0), value);
            } else if (value < 0.0f) {
                Integer okey = this._povx.put(controllerIndex, 265);
                if (okey != null && okey == 264) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(265, controllerIndex, 0), -value);
            } else {
                Integer okey = this._povx.remove(controllerIndex);
                if (okey != null) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
            }
            if (this._consume) {
                event.consume();
            }
        }

        @Override
        public void controllerPovYMoved(ControllerEvent event) {
            if (event.isConsumed()) {
                return;
            }
            Controller controller = event.getController();
            int controllerIndex = controller.getIndex();
            float value = controller.getPovY();
            if (value > 0.0f) {
                Integer okey = this._povy.put(controllerIndex, 266);
                if (okey != null && okey == 267) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(266, controllerIndex, 0), value);
            } else if (value < 0.0f) {
                Integer okey = this._povy.put(controllerIndex, 267);
                if (okey != null && okey == 266) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
                this.keyPressed(event.getWhen(), PseudoKeys.getControllerKey(267, controllerIndex, 0), -value);
            } else {
                Integer okey = this._povy.remove(controllerIndex);
                if (okey != null) {
                    this.keyReleased(event.getWhen(), PseudoKeys.getControllerKey(okey, controllerIndex, 0));
                }
            }
            if (this._consume) {
                event.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!event.isConsumed()) {
                this.keyPressed(event.getWhen(), PseudoKeys.getMouseKey(event.getButton()), 1.0f);
                if (this._consume) {
                    event.consume();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!event.isConsumed()) {
                this.keyReleased(event.getWhen(), PseudoKeys.getMouseKey(event.getButton()));
                if (this._consume) {
                    event.consume();
                }
            }
        }

        public void addModifierUser(int key) {
            if (!this._modifierUsers.contains(key)) {
                this._modifierUsers.add(key);
            }
        }

        public void addModifierKey(int key, int modKey) {
            this._modifierMap.put(key, modKey);
        }

        public void clearModifierUsers() {
            this.clearHeldKeys();
            this._modifierUsers.clear();
        }

        public void clearModifierKeys() {
            this.clearHeldKeys();
            this._modifierMap.clear();
        }

        protected void clearHeldKeys() {
            this._pressedModifiers = 0;
            this._pressedKeys.clear();
        }

        protected HashIntSet currentPressedKeys() {
            return new HashIntSet((Collection)this._pressedKeys);
        }

        protected int getModifierKey(int key) {
            Integer retVal = this._modifierMap.get(key);
            return retVal == null ? 0 : retVal;
        }

        protected int applyModifierKeys(int key) {
            return this._pressedModifiers | key;
        }

        protected void holdModifierKey(int modKey, boolean held) {
            this._pressedModifiers = held ? (this._pressedModifiers |= modKey) : (this._pressedModifiers &= ~modKey);
        }
    }
}

