/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr.util;

import com.google.common.collect.Maps;
import com.threerings.ClydeLog;
import com.threerings.expr.Bound;
import com.threerings.expr.Function;
import com.threerings.expr.MutableBoolean;
import com.threerings.expr.MutableFloat;
import com.threerings.expr.MutableInteger;
import com.threerings.expr.MutableLong;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.Variable;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform2D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.Color4f;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ScopeUtil {
    protected static HashMap<Class<?>, Field[]> _bound = Maps.newHashMap();
    protected static HashMap<Class<?>, HashMap<String, Member>> _scoped = Maps.newHashMap();

    public static void updateBound(Object object, Scope scope) {
        Field[] fieldArray = ScopeUtil.getBound(object.getClass());
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getAnnotation(Bound.class).value();
            if (name.length() == 0) {
                name = ScopeUtil.stripUnderscore(field.getName());
            }
            Class<?> type = field.getType();
            try {
                field.set(object, ScopeUtil.resolve(scope, name, field.get(object), type));
            }
            catch (IllegalAccessException e) {
                ClydeLog.log.warning((Object)"Error accessing bound field.", new Object[]{"field", field, e});
            }
            ++n2;
        }
    }

    public static Object call(Scope scope, String name, Object ... args) {
        return ScopeUtil.resolve(scope, name, Function.NULL).call(args);
    }

    public static Quaternion resolve(Scope scope, String name, Quaternion defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Quaternion.class);
    }

    public static Transform2D resolve(Scope scope, String name, Transform2D defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Transform2D.class);
    }

    public static Transform3D resolve(Scope scope, String name, Transform3D defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Transform3D.class);
    }

    public static Vector2f resolve(Scope scope, String name, Vector2f defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Vector2f.class);
    }

    public static Vector3f resolve(Scope scope, String name, Vector3f defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Vector3f.class);
    }

    public static Color4f resolve(Scope scope, String name, Color4f defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Color4f.class);
    }

    public static String resolve(Scope scope, String name, String defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, String.class);
    }

    public static Function resolve(Scope scope, String name, Function defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Function.class);
    }

    public static Variable resolve(Scope scope, String name, Variable defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Variable.class);
    }

    public static MutableBoolean resolve(Scope scope, String name, MutableBoolean defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, MutableBoolean.class);
    }

    public static MutableFloat resolve(Scope scope, String name, MutableFloat defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, MutableFloat.class);
    }

    public static MutableInteger resolve(Scope scope, String name, MutableInteger defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, MutableInteger.class);
    }

    public static MutableLong resolve(Scope scope, String name, MutableLong defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, MutableLong.class);
    }

    public static Boolean resolve(Scope scope, String name, Boolean defvalue) {
        return ScopeUtil.resolve(scope, name, defvalue, Boolean.class);
    }

    public static MutableLong resolveTimestamp(Scope scope, String name) {
        MutableLong res = ScopeUtil.resolve(scope, name, null, MutableLong.class);
        return res != null ? res : new MutableLong(System.currentTimeMillis());
    }

    public static <T> T resolve(Scope scope, String name, T defvalue, Class<T> clazz) {
        int idx = name.indexOf(58);
        if (idx != -1) {
            String qualifier = name.substring(0, idx);
            name = name.substring(idx + 1);
            while (scope != null && !qualifier.equals(scope.getScopeName())) {
                scope = scope.getParentScope();
            }
        }
        while (scope != null) {
            T value = scope.get(name, clazz);
            if (value != null) {
                return value;
            }
            scope = scope.getParentScope();
        }
        return defvalue;
    }

    public static <T> T get(final Object object, String name, Class<T> clazz) {
        if ("this".equals(name) && clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        Member member = ScopeUtil.getScoped(object.getClass()).get(name);
        if (member instanceof Field) {
            if (clazz.isAssignableFrom(Variable.class)) {
                final Field field = (Field)member;
                return clazz.cast(new Variable(){

                    @Override
                    public boolean getBoolean() {
                        try {
                            return field.getBoolean(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return false;
                        }
                    }

                    @Override
                    public byte getByte() {
                        try {
                            return field.getByte(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return 0;
                        }
                    }

                    @Override
                    public char getChar() {
                        try {
                            return field.getChar(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return '\u0000';
                        }
                    }

                    @Override
                    public double getDouble() {
                        try {
                            return field.getDouble(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return 0.0;
                        }
                    }

                    @Override
                    public float getFloat() {
                        try {
                            return field.getFloat(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return 0.0f;
                        }
                    }

                    @Override
                    public int getInt() {
                        try {
                            return field.getInt(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return 0;
                        }
                    }

                    @Override
                    public long getLong() {
                        try {
                            return field.getLong(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return 0L;
                        }
                    }

                    @Override
                    public short getShort() {
                        try {
                            return field.getShort(object);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                            return 0;
                        }
                    }

                    @Override
                    public Object get() {
                        try {
                            return field.get(object);
                        }
                        catch (IllegalAccessException e) {
                            this.logWarning(e);
                            return null;
                        }
                    }

                    @Override
                    public void setBoolean(boolean value) {
                        try {
                            field.setBoolean(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void setByte(byte value) {
                        try {
                            field.setByte(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void setChar(char value) {
                        try {
                            field.setChar(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void setDouble(double value) {
                        try {
                            field.setDouble(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void setFloat(float value) {
                        try {
                            field.setFloat(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void setInt(int value) {
                        try {
                            field.setInt(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void setLong(long value) {
                        try {
                            field.setLong(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void setShort(short value) {
                        try {
                            field.setShort(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    @Override
                    public void set(Object value) {
                        try {
                            field.set(object, value);
                        }
                        catch (Exception e) {
                            this.logWarning(e);
                        }
                    }

                    protected void logWarning(Exception e) {
                        ClydeLog.log.warning((Object)"Error accessing field.", new Object[]{"class", object.getClass(), "field", field, e});
                    }
                });
            }
            try {
                Object value = ((Field)member).get(object);
                if (clazz.isInstance(value)) {
                    return clazz.cast(value);
                }
            }
            catch (IllegalAccessException e) {
                ClydeLog.log.warning((Object)"Error accessing field.", new Object[]{"class", object.getClass(), "field", member, e});
            }
        } else if (member instanceof Method && clazz.isAssignableFrom(Function.class)) {
            final Method method = (Method)member;
            return clazz.cast(new Function(){

                @Override
                public Object call(Object ... args) {
                    try {
                        return method.invoke(object, args);
                    }
                    catch (Exception e) {
                        ClydeLog.log.warning((Object)"Error invoking method.", new Object[]{"class", object.getClass(), "method", method, "args", args, e});
                        return null;
                    }
                }
            });
        }
        return null;
    }

    protected static Field[] getBound(Class<?> clazz) {
        Field[] fields = _bound.get(clazz);
        if (fields == null) {
            fields = ScopeUtil.createBound(clazz);
            _bound.put(clazz, fields);
        }
        return fields;
    }

    protected static Field[] createBound(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> sclazz = clazz.getSuperclass();
        if (sclazz != null) {
            Collections.addAll(fields, ScopeUtil.getBound(sclazz));
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(Bound.class)) {
                field.setAccessible(true);
                fields.add(field);
            }
            ++n2;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    protected static HashMap<String, Member> getScoped(Class<?> clazz) {
        HashMap<String, Member> members = _scoped.get(clazz);
        if (members == null) {
            members = ScopeUtil.createScoped(clazz);
            _scoped.put(clazz, members);
        }
        return members;
    }

    protected static HashMap<String, Member> createScoped(Class<?> clazz) {
        HashMap<String, Member> members = new HashMap<String, Member>();
        Class<?> sclazz = clazz.getSuperclass();
        if (sclazz != null) {
            members.putAll(ScopeUtil.getScoped(sclazz));
        }
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            if (field.isAnnotationPresent(Scoped.class)) {
                field.setAccessible(true);
                members.put(ScopeUtil.stripUnderscore(field.getName()), field);
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getDeclaredMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            if (method.isAnnotationPresent(Scoped.class)) {
                ((Method)method).setAccessible(true);
                members.put(((Method)method).getName(), (Member)((Object)method));
            }
            ++n2;
        }
        return members;
    }

    protected static String stripUnderscore(String name) {
        return name.charAt(0) == '_' ? name.substring(1) : name;
    }
}

