/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.space;

import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.None;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.space.Space;
import com.threerings.tudey.space.SpaceElement;

public abstract class SimpleSpaceElement
implements SpaceElement {
    protected Transform2D _transform = new Transform2D(2);
    protected Rect _bounds = new Rect();
    protected Object _userObject;
    protected Space _space;
    protected int _lastVisit;

    public void setUserObject(Object object) {
        this._userObject = object;
    }

    public void setTransform(Transform2D transform) {
        this._transform.set(transform);
        this._transform.promote(2);
        this.updateBounds();
    }

    public Transform2D getTransform() {
        return this._transform;
    }

    public Space getSpace() {
        return this._space;
    }

    public abstract void updateBounds();

    @Override
    public Object getUserObject() {
        return this._userObject;
    }

    @Override
    public void wasAdded(Space space) {
        this._space = space;
    }

    @Override
    public void willBeRemoved() {
        this._space = null;
    }

    @Override
    public boolean getIntersection(Ray2D ray, Vector2f result) {
        return false;
    }

    @Override
    public void getNearestPoint(Vector2f point, Vector2f result) {
        result.set(point);
    }

    @Override
    public boolean intersects(Point point) {
        return false;
    }

    @Override
    public boolean intersects(Segment segment) {
        return false;
    }

    @Override
    public boolean intersects(Circle circle) {
        return false;
    }

    @Override
    public boolean intersects(Capsule capsule) {
        return false;
    }

    @Override
    public boolean intersects(Polygon polygon) {
        return false;
    }

    @Override
    public boolean intersects(Compound compound) {
        return false;
    }

    @Override
    public boolean intersects(None compound) {
        return false;
    }

    @Override
    public Rect getBounds() {
        return this._bounds;
    }

    @Override
    public boolean updateLastVisit(int visit) {
        if (this._lastVisit == visit) {
            return false;
        }
        this._lastVisit = visit;
        return true;
    }

    protected void boundsWillChange() {
        if (this._space != null) {
            this._space.boundsWillChange(this);
        }
    }

    protected void boundsDidChange() {
        if (this._space != null) {
            this._space.boundsDidChange(this);
        }
    }
}

