/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.util;

import com.google.common.collect.Lists;
import com.samskivert.util.Tuple;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.Introspector;
import com.threerings.editor.Property;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.export.ObjectMarshaller;
import com.threerings.resource.ResourceManager;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyUtil {
    protected static final Object STRIP_OUT = new Object();

    public static String getMode(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            String mode = lineage[ii].getMode();
            if (!"%INHERIT%".equals(mode)) {
                return mode;
            }
            --ii;
        }
        return "";
    }

    public static String getUnits(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            String units = lineage[ii].getUnits();
            if (!"%INHERIT%".equals(units)) {
                return units;
            }
            --ii;
        }
        return "";
    }

    public static double getMinimum(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double min = lineage[ii].getMinimum();
            if (min != Double.NEGATIVE_INFINITY) {
                return min;
            }
            --ii;
        }
        return -1.7976931348623157E308;
    }

    public static double getMaximum(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double max = lineage[ii].getMaximum();
            if (max != Double.NEGATIVE_INFINITY) {
                return max;
            }
            --ii;
        }
        return Double.MAX_VALUE;
    }

    public static double getStep(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double step = lineage[ii].getStep();
            if (step != Double.NEGATIVE_INFINITY) {
                return step;
            }
            --ii;
        }
        return 1.0;
    }

    public static double getScale(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            double scale = lineage[ii].getScale();
            if (scale != Double.NEGATIVE_INFINITY) {
                return scale;
            }
            --ii;
        }
        return 1.0;
    }

    public static int getMinSize(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            int min = lineage[ii].getMinSize();
            if (min != Integer.MIN_VALUE) {
                return min;
            }
            --ii;
        }
        return 0;
    }

    public static int getMaxSize(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            int max = lineage[ii].getMaxSize();
            if (max != Integer.MIN_VALUE) {
                return max;
            }
            --ii;
        }
        return Integer.MAX_VALUE;
    }

    public static void getReferences(ConfigManager cfgmgr, Object object, Set<Tuple<Class<?>, String>> configs, Set<String> resources) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                PropertyUtil.getReferences(cfgmgr, element, configs, resources);
                ++n2;
            }
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            int ii = 0;
            int nn = list.size();
            while (ii < nn) {
                PropertyUtil.getReferences(cfgmgr, list.get(ii), configs, resources);
                ++ii;
            }
            return;
        }
        Property[] propertyArray = Introspector.getProperties(object);
        int n = propertyArray.length;
        int n3 = 0;
        while (n3 < n) {
            Property property = propertyArray[n3];
            PropertyUtil.getReferences(cfgmgr, object, property, configs, resources);
            ++n3;
        }
    }

    public static boolean validateReferences(String where, ConfigManager cfgmgr, Set<Tuple<Class<?>, String>> configs, Set<String> resources, PrintStream out) {
        boolean result = true;
        for (Tuple<Class<?>, String> tuple : configs) {
            Class cclass = (Class)tuple.left;
            if (cfgmgr.getConfig(cclass, (String)tuple.right) != null) continue;
            out.println(String.valueOf(where) + " references missing config of type " + ConfigGroup.getName(cclass) + ": " + (String)tuple.right);
            result = false;
        }
        ResourceManager rsrcmgr = cfgmgr.getResourceManager();
        for (String resource : resources) {
            if (rsrcmgr.getResourceFile(resource).exists()) continue;
            out.println(String.valueOf(where) + " references missing resource: " + resource);
            result = false;
        }
        return result;
    }

    public static void getResources(ConfigManager cfgmgr, Object object, Set<String> paths) {
        PropertyUtil.getResources(cfgmgr, object, paths, new ConfigReferenceSet());
    }

    public static Object strip(ConfigManager cfgmgr, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] oarray;
            ArrayList list = Lists.newArrayList();
            Object[] objectArray = oarray = (Object[])object;
            int n = oarray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (!PropertyUtil.isStrippable(element)) {
                    list.add(PropertyUtil.strip(cfgmgr, element));
                }
                ++n2;
            }
            int nsize = list.size();
            return list.toArray(oarray.length == nsize ? oarray : (Object[])Array.newInstance(oarray.getClass().getComponentType(), nsize));
        }
        if (object instanceof List) {
            List list = (List)object;
            int ii = list.size() - 1;
            while (ii >= 0) {
                Object element = list.get(ii);
                if (PropertyUtil.isStrippable(element)) {
                    list.remove(ii);
                } else {
                    list.set(ii, PropertyUtil.strip(cfgmgr, element));
                }
                --ii;
            }
            return list;
        }
        if (!(object instanceof Exportable)) {
            return object;
        }
        Class<?> clazz = object.getClass();
        Object prototype = ObjectMarshaller.getObjectMarshaller(clazz).getPrototype();
        Property[] propertyArray = Introspector.getProperties(clazz);
        int n = propertyArray.length;
        int n3 = 0;
        while (n3 < n) {
            Property property;
            Object result = PropertyUtil.strip(cfgmgr, object, property = propertyArray[n3]);
            property.set(object, result == STRIP_OUT ? property.get(prototype) : result);
            ++n3;
        }
        return object;
    }

    protected static Object strip(ConfigManager cfgmgr, Object object, Property property) {
        Object value = property.get(object);
        if (PropertyUtil.isStrippable(property) || PropertyUtil.isStrippable(value)) {
            return STRIP_OUT;
        }
        if (value == null) {
            return null;
        }
        if (property.getType().equals(ConfigReference.class)) {
            Class<?> cclass = property.getArgumentType(ConfigReference.class);
            ConfigReference ref = (ConfigReference)value;
            ArgumentMap args = ref.getArguments();
            if (args.isEmpty()) {
                return ref;
            }
            Object config = cfgmgr.getConfig(cclass, ref.getName());
            if (!(config instanceof ParameterizedConfig)) {
                args.clear();
                return ref;
            }
            ParameterizedConfig pconfig = (ParameterizedConfig)config;
            Iterator<Map.Entry<String, Object>> it = args.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                Parameter param = pconfig.getParameter(entry.getKey());
                if (param == null) {
                    it.remove();
                    continue;
                }
                Property prop = param.getArgumentProperty(pconfig);
                if (prop == null) {
                    it.remove();
                    continue;
                }
                Object result = PropertyUtil.strip(cfgmgr, args, prop);
                if (result == STRIP_OUT) {
                    it.remove();
                    continue;
                }
                entry.setValue(result);
            }
            return ref;
        }
        return PropertyUtil.strip(cfgmgr, value);
    }

    protected static boolean isStrippable(Property property) {
        Class<?> type = property.getType();
        return property.isAnnotationPresent(Strippable.class) || PropertyUtil.isStrippable(type) || PropertyUtil.isStrippable(property.getComponentType()) || ConfigReference.class.isAssignableFrom(type) && PropertyUtil.isStrippable(property.getArgumentType(ConfigReference.class));
    }

    protected static boolean isStrippable(Object object) {
        return object != null && PropertyUtil.isStrippable(object.getClass());
    }

    protected static boolean isStrippable(Class<?> clazz) {
        return clazz != null && (clazz.isAnnotationPresent(Strippable.class) || PropertyUtil.isStrippable(clazz.getComponentType()) || PropertyUtil.isStrippable(clazz.getSuperclass()));
    }

    protected static void getReferences(ConfigManager cfgmgr, Object object, Property property, Set<Tuple<Class<?>, String>> configs, Set<String> resources) {
        Object value = property.get(object);
        if (value == null) {
            return;
        }
        Editable annotation = property.getAnnotation();
        String editor = annotation.editor();
        if (editor.equals("resource")) {
            resources.add((String)value);
        } else if (editor.equals("config")) {
            ConfigGroup group = cfgmgr.getGroup(annotation.mode());
            if (group != null) {
                configs.add(new Tuple(group.getConfigClass(), (Object)((String)value)));
            }
        } else if (property.getType().equals(ConfigReference.class)) {
            Class<?> cclass = property.getArgumentType(ConfigReference.class);
            ConfigReference ref = (ConfigReference)value;
            configs.add(new Tuple(cclass, (Object)ref.getName()));
            ArgumentMap args = ref.getArguments();
            if (args.isEmpty()) {
                return;
            }
            Object config = cfgmgr.getConfig(cclass, ref.getName());
            if (!(config instanceof ParameterizedConfig)) {
                return;
            }
            ParameterizedConfig pconfig = (ParameterizedConfig)config;
            Iterator<Map.Entry<String, Object>> it = args.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                Parameter param = pconfig.getParameter(entry.getKey());
                if (param == null) {
                    it.remove();
                    continue;
                }
                Property prop = param.getArgumentProperty(pconfig);
                if (prop == null) continue;
                PropertyUtil.getReferences(cfgmgr, args, prop, configs, resources);
            }
        } else {
            PropertyUtil.getReferences(cfgmgr, value, configs, resources);
        }
    }

    protected static void getResources(ConfigManager cfgmgr, Object object, Set<String> paths, ConfigReferenceSet refs) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                PropertyUtil.getResources(cfgmgr, element, paths, refs);
                ++n2;
            }
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            int ii = 0;
            int nn = list.size();
            while (ii < nn) {
                PropertyUtil.getResources(cfgmgr, list.get(ii), paths, refs);
                ++ii;
            }
            return;
        }
        Property[] propertyArray = Introspector.getProperties(object);
        int n = propertyArray.length;
        int n3 = 0;
        while (n3 < n) {
            block11: {
                String editor;
                Object value;
                block12: {
                    ConfigReference ref;
                    Class<Object> cclass;
                    block14: {
                        Property property;
                        block13: {
                            property = propertyArray[n3];
                            value = property.get(object);
                            if (value == null) break block11;
                            Editable annotation = property.getAnnotation();
                            editor = annotation.editor();
                            boolean cfg = editor.equals("config");
                            if (!cfg && !property.getType().equals(ConfigReference.class)) break block12;
                            if (!cfg) break block13;
                            ConfigGroup group = cfgmgr.getGroup(annotation.mode());
                            if (group == null) break block11;
                            Class mclass = group.getConfigClass();
                            cclass = mclass;
                            ref = new ConfigReference((String)value);
                            break block14;
                        }
                        Class<?> mclass = property.getArgumentType(ConfigReference.class);
                        ConfigReference mref = (ConfigReference)value;
                        cclass = mclass;
                        ref = mref;
                    }
                    if (refs.add(cclass, ref)) {
                        Object config;
                        if (cfgmgr.isResourceClass(cclass)) {
                            paths.add(ref.getName());
                        }
                        if ((config = cfgmgr.getConfig(cclass, ref)) != null) {
                            PropertyUtil.getResources(cfgmgr, config, paths, refs);
                        }
                    }
                    break block11;
                }
                if (editor.equals("resource")) {
                    paths.add((String)value);
                } else {
                    PropertyUtil.getResources(cfgmgr, value, paths, refs);
                }
            }
            ++n3;
        }
    }
}

