/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.tools;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigManager;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.export.BinaryExporter;
import com.threerings.export.BinaryImporter;
import com.threerings.resource.ResourceManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class StripTask
extends Task {
    protected ConfigManager _cfgmgr;
    protected File _dest;
    protected boolean _compress = true;
    protected List<FileSet> _filesets = Lists.newArrayList();

    public void setDest(File dest) {
        this._dest = dest;
    }

    public void setCompress(boolean compress) {
        this._compress = compress;
    }

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void execute() throws BuildException {
        ResourceManager rsrcmgr = new ResourceManager("rsrc/");
        rsrcmgr.initResourceDir("rsrc/");
        this._cfgmgr = new ConfigManager(rsrcmgr, null, "config/");
        this._cfgmgr.init();
        for (FileSet fs : this._filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            String[] stringArray = ds.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                try {
                    this.strip(fromDir, file);
                }
                catch (Exception e) {
                    System.err.println("Error stripping " + new File(fromDir, file) + ": " + e);
                }
                ++n2;
            }
        }
    }

    protected void strip(File sourceDir, String sourceName) throws IOException {
        int didx = sourceName.lastIndexOf(46);
        String root = didx == -1 ? sourceName : sourceName.substring(0, didx);
        File target = new File(this._dest == null ? sourceDir : this._dest, String.valueOf(root) + ".dat");
        File source = new File(sourceDir, sourceName);
        long lastmod = target.lastModified();
        if (source.lastModified() < lastmod) {
            return;
        }
        System.out.println("Stripping " + source + " to " + target + "...");
        File parent = target.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        BinaryImporter in = new BinaryImporter(new FileInputStream(source));
        BinaryExporter out = new BinaryExporter(new FileOutputStream(target), this._compress);
        try {
            try {
                while (true) {
                    out.writeObject(PropertyUtil.strip(this._cfgmgr, in.readObject()));
                }
            }
            catch (EOFException eOFException) {
                in.close();
                out.close();
            }
        }
        catch (Throwable throwable) {
            in.close();
            out.close();
            throw throwable;
        }
    }
}

