/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.CollapsiblePanel;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Introspector;
import com.threerings.editor.Log;
import com.threerings.editor.Property;
import com.threerings.editor.util.EditorContext;
import com.threerings.media.image.ImageUtil;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BasePropertyEditor
extends CollapsiblePanel
implements ActionListener {
    protected EditorContext _ctx;
    protected MessageManager _msgmgr;
    protected MessageBundle _msgs;
    protected JButton _highlight;
    protected boolean _highlighted;
    protected JButton _tree;
    protected static Icon _expandIcon;
    protected static Icon _collapseIcon;
    protected static Icon _highlightIcon;
    protected static Icon _treeIcon;
    protected static Icon _panelIcon;
    protected static final int BASE_BACKGROUND = 238;
    protected static final int DEFAULT_BACKGROUND = 0xEEEEEE;
    protected static final int SHADE_DECREMENT = 8;
    protected static final Dimension PANEL_BUTTON_SIZE;

    static {
        PANEL_BUTTON_SIZE = new Dimension(16, 16);
    }

    public BasePropertyEditor() {
        super((LayoutManager)new FlowLayout());
        this.setBackground(null);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public String getLabel(Class<?> type) {
        if (type == null) {
            return this._msgs.get("m.null_value");
        }
        String name = type.getName();
        name = name.substring(Math.max(name.lastIndexOf(36), name.lastIndexOf(46)) + 1);
        name = StringUtil.toUSLowerCase((String)StringUtil.unStudlyName((String)name));
        return this.getLabel(name, Introspector.getMessageBundle(type));
    }

    public String[] getLabels(String[] names) {
        return this.getLabels(names, this._msgs);
    }

    public String[] getLabels(String[] names, String bundle) {
        return this.getLabels(names, this._msgmgr.getBundle(bundle));
    }

    public String[] getLabels(String[] names, MessageBundle msgs) {
        String[] labels = new String[names.length];
        int ii = 0;
        while (ii < names.length) {
            labels[ii] = this.getLabel(names[ii], msgs);
            ++ii;
        }
        return labels;
    }

    public String getMousePath() {
        Point pt = this.getMousePosition();
        return pt == null ? "" : this.getMousePath(pt);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._highlight) {
            this._highlighted = !this._highlighted;
            this.updateBorder(((TitledBorder)this.getBorder()).getTitle());
            this.invalidate();
        } else if (source == this._tree) {
            Icon icon = this._tree.getIcon();
            boolean enabled = icon == _treeIcon;
            this.setTreeModeEnabled(enabled);
            this._tree.setIcon(enabled ? _panelIcon : _treeIcon);
        } else {
            super.actionPerformed(event);
        }
    }

    protected void setTreeModeEnabled(boolean enabled) {
    }

    protected String getMousePath(Point pt) {
        return "";
    }

    public String getLabel(Property property) {
        String name = property.getName();
        return property.shouldTranslateName() ? this.getLabel(name, property.getMessageBundle()) : name;
    }

    protected String getLabel(String name) {
        return this.getLabel(name, this._msgs);
    }

    protected String getLabel(String name, String bundle) {
        return this.getLabel(name, this._msgmgr.getBundle(bundle));
    }

    protected String getLabel(String name, MessageBundle msgs) {
        name = name.length() == 0 ? "default" : name;
        String key = "m." + name;
        return msgs.exists(key) ? msgs.get(key) : name;
    }

    protected String getLabel(Enum value, MessageBundle msgs) {
        if (value == null) {
            return this._msgs.get("m.null_value");
        }
        String key = "m." + StringUtil.toUSLowerCase((String)value.name());
        return msgs.exists(key) ? msgs.get(key) : value.toString();
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = null;
        int ii = listeners.length - 2;
        while (ii >= 0) {
            if (listeners[ii] == ChangeListener.class) {
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[ii + 1]).stateChanged(event);
            }
            ii -= 2;
        }
    }

    protected void makeCollapsible(EditorContext ctx, final String title, boolean tree) {
        VGroupLayout gl = new VGroupLayout(VGroupLayout.NONE);
        gl.setOffAxisPolicy(VGroupLayout.STRETCH);
        gl.setGap(0);
        gl.setJustification(VGroupLayout.TOP);
        gl.setOffAxisJustification(VGroupLayout.LEFT);
        this.setLayout((LayoutManager)gl);
        if (_expandIcon == null) {
            _expandIcon = this.loadIcon("expand", ctx);
            _collapseIcon = this.loadIcon("collapse", ctx);
            _highlightIcon = this.loadIcon("highlight", ctx);
            _treeIcon = this.loadIcon("tree", ctx);
            _panelIcon = this.loadIcon("panels", ctx);
        }
        JPanel tcont = GroupLayout.makeHBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.RIGHT, (GroupLayout.Policy)GroupLayout.NONE);
        tcont.setOpaque(false);
        if (tree) {
            this._tree = this.createButton(_treeIcon);
            tcont.add(this._tree);
            this._tree.addActionListener(this);
        }
        JButton expand = this.createButton(_expandIcon);
        tcont.add(expand);
        this._highlight = this.createButton(_highlightIcon);
        tcont.add(this._highlight);
        this._highlight.addActionListener(this);
        this.setTrigger(expand, _expandIcon, _collapseIcon);
        expand.setHorizontalAlignment(0);
        this.add((Component)new Spacer(1, -24));
        this.setTriggerContainer(tcont, new JPanel(), false);
        this.setGap(5);
        this.setCollapsed(false);
        this.getContent().setBackground(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    BasePropertyEditor.this._highlighted = !BasePropertyEditor.this._highlighted;
                    BasePropertyEditor.this.updateBorder(title);
                }
            }
        });
        this._content.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        this.updateBorder(title);
    }

    protected Icon loadIcon(String name, EditorContext ctx) {
        BufferedImage image;
        try {
            image = ctx.getResourceManager().getImageResource("media/editor/" + name + ".png");
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error loading image.", new Object[]{"name", name, e});
            image = ImageUtil.createErrorImage((int)12, (int)12);
        }
        return new ImageIcon(image);
    }

    protected JButton createButton(Icon icon) {
        JButton button = new JButton(icon);
        button.setPreferredSize(PANEL_BUTTON_SIZE);
        return button;
    }

    protected int getColor(String name) {
        return this.getColor(name, this._msgs, 0xEEEEEE);
    }

    protected int getColor(String name, String bundle, int defaultColor) {
        return this.getColor(name, this._msgmgr.getBundle(bundle), defaultColor);
    }

    protected int getColor(String name, MessageBundle msgs, int defaultColor) {
        if (name.length() == 0) {
            return defaultColor;
        }
        return msgs.exists(name = "c." + name) ? Integer.parseInt(msgs.get(name), 16) : defaultColor;
    }

    protected int getPropertyColor(Property[] lineage) {
        int ii = lineage.length - 1;
        while (ii >= 0) {
            int color = this.getColor(lineage[ii].getColorName(), lineage[ii].getMessageBundle(), -1);
            if (color != -1) {
                return color;
            }
            --ii;
        }
        return 0xEEEEEE;
    }

    protected Color getDarkerBackground(float shades) {
        int value = 238 - (int)(shades * 8.0f);
        return new Color(value, value, value);
    }

    protected Color getBackgroundColor(Property[] lineage) {
        int color = this.getPropertyColor(lineage);
        if (lineage == null) {
            return new Color(color);
        }
        return this.darkenColor(color, lineage.length / 2);
    }

    protected Color darkenColor(int color, float shades) {
        int darken = (int)(shades * 8.0f);
        int r = Math.max(0, ((color & 0xFF0000) >> 16) - darken);
        int g = Math.max(0, ((color & 0xFF00) >> 8) - darken);
        int b = Math.max(0, (color & 0xFF) - darken);
        return new Color(r, g, b);
    }

    protected void copyPropertyPath(String path) {
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.length() > 0) {
            StringSelection contents = new StringSelection(path);
            this.getToolkit().getSystemClipboard().setContents(contents, contents);
        }
    }

    protected void updateBorder(String title) {
        TitledBorder border = this._highlighted ? BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 2), title) : BorderFactory.createTitledBorder(title);
        this.setBorder(border);
    }
}

