/*
 * Decompiled with CFR 0.152.
 */
package com.hexnova.agent.classloader;

import com.hexnova.agent.classloader.SignalUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.JarFile;

public class ClassLoaderAgent {
    private static Instrumentation inst = null;

    public static void premain(String fullpath, Instrumentation inst) {
        boolean singleton = Boolean.getBoolean("need.singleton");
        if (singleton) {
            ClassLoaderAgent.iniLockFile();
        }
        ClassLoaderAgent.inst = inst;
        if (fullpath != null && fullpath.trim().length() > 0) {
            StringTokenizer token = new StringTokenizer(fullpath, ";,");
            while (token.hasMoreTokens()) {
                String path = token.nextToken();
                File libFolder = new File(path);
                if (!libFolder.exists()) {
                    block18: {
                        InputStream is = ClassLoaderAgent.class.getResourceAsStream(path);
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        try {
                            try {
                                while ((line = br.readLine()) != null) {
                                    File file = new File(line = line.trim());
                                    if (file.exists()) {
                                        ClassLoaderAgent.addFolderClassPath(file.getAbsoluteFile());
                                        continue;
                                    }
                                    URL url = new URL(line);
                                    ClassLoaderAgent.addClassPath(url);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                if (br == null) break block18;
                                try {
                                    br.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        finally {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    return;
                }
                ClassLoaderAgent.addFolderClassPath(libFolder);
            }
        }
    }

    private static void iniLockFile() {
        String appName = ManagementFactory.getRuntimeMXBean().getName();
        final String pid = appName.substring(0, appName.indexOf("@"));
        String pidPath = System.getProperty("project.pid.path", System.getProperty("project.home", "."));
        final File pidFile = new File(pidPath, String.valueOf(System.getProperty("project.name", "")) + ".pid");
        final File lockFile = new File(pidPath, ".lock");
        final SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            final FileOutputStream lockFos = new FileOutputStream(lockFile);
            final FileLock lock = lockFos.getChannel().tryLock();
            if (lock == null) {
                if (pidFile.exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(pidFile));
                    String oldPid = reader.readLine();
                    reader.close();
                    System.out.println(String.valueOf(pidFile.getName()) + "  is locked. please shutdown the old process=" + oldPid);
                } else {
                    System.out.println(String.valueOf(pidFile.getName()) + "  is locked. please shutdown the old process");
                }
                lockFos.close();
                System.exit(0);
                return;
            }
            final FileOutputStream fos = new FileOutputStream(pidFile);
            final OutputStreamWriter writer = new OutputStreamWriter(fos);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (lock != null) {
                        try {
                            lock.release();
                            lockFos.close();
                            writer.close();
                            fos.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    lockFile.delete();
                    pidFile.delete();
                    System.out.println(" " + formate.format(new Date()) + " [INFO] Project Name=" + System.getProperty("project.name", "") + ", PID=" + pid + " , System shutdown ....");
                }
            });
            writer.write(pid);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println(" " + formate.format(new Date()) + " [INFO] Project Name=" + System.getProperty("project.name", "") + ", PID=" + pid + " , starting...");
        SignalUtil.Handler IGNORE = new SignalUtil.Handler(){

            @Override
            public void signalReceived(SignalUtil.Number number) {
                System.out.println(" " + formate.format(new Date()) + " [INFO] ignore signal:" + number.name());
            }
        };
        HashMap<String, SignalUtil.Number> signalMap = new HashMap<String, SignalUtil.Number>();
        SignalUtil.Number[] numberArray = SignalUtil.Number.values();
        int n = numberArray.length;
        int writer = 0;
        while (writer < n) {
            SignalUtil.Number number = numberArray[writer];
            signalMap.put(number.name(), number);
            signalMap.put(String.valueOf(number._signo), number);
            ++writer;
        }
        String ignores = System.getProperty("ignore.signals");
        if (ignores != null && ignores.trim().length() > 0) {
            StringTokenizer tokens = new StringTokenizer(ignores, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                SignalUtil.Number number = (SignalUtil.Number)((Object)signalMap.get(token));
                if (number == null) continue;
                try {
                    SignalUtil.register(number, IGNORE);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }

    public static void agentmain(String a, Instrumentation inst) {
        ClassLoaderAgent.inst = inst;
    }

    public static boolean addClassPath(URL f) {
        ClassLoader cl;
        block4: {
            cl = ClassLoader.getSystemClassLoader();
            try {
                if (cl instanceof URLClassLoader) break block4;
                JarFile file = ClassLoaderAgent.retrieve(f);
                if (file != null) {
                    inst.appendToSystemClassLoaderSearch(file);
                }
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        m.setAccessible(true);
        m.invoke((Object)cl, f.toURI().toURL());
        return true;
    }

    public static boolean addFileClassPath(File f) {
        ClassLoader cl;
        block3: {
            cl = ClassLoader.getSystemClassLoader();
            try {
                if (cl instanceof URLClassLoader) break block3;
                JarFile jar = new JarFile(f);
                inst.appendToSystemClassLoaderSearch(jar);
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        m.setAccessible(true);
        m.invoke((Object)cl, f.toURI().toURL());
        return true;
    }

    public static void addFolderClassPath(File libFolder) {
        if (libFolder.isDirectory() && libFolder.canRead()) {
            File[] files;
            File[] fileArray = files = libFolder.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory() && !".".equals(file.getName()) && !"..".equals(file.getName())) {
                    ClassLoaderAgent.addFolderClassPath(file);
                }
                if (file.getAbsolutePath().endsWith(".jar")) {
                    ClassLoaderAgent.addFileClassPath(file);
                }
                ++n2;
            }
        } else if (libFolder.isFile() && libFolder.canRead()) {
            ClassLoaderAgent.addFileClassPath(libFolder);
        }
    }

    private static JarFile retrieve(URL url) throws IOException {
        JarFile result = null;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        if (Boolean.getBoolean("AGENT_URL_SECURE")) {
            String realm = System.getProperty("AGENT_URL_AUTHEN");
            String basicAuth = "Basic " + new String(Base64.getEncoder().encode(realm.getBytes()));
            connection.setRequestProperty("Authorization", basicAuth);
        }
        try {
            try {
                connection.connect();
                if (connection.getResponseCode() == 200) {
                    final InputStream in = connection.getInputStream();
                    result = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                        @Override
                        public JarFile run() throws IOException {
                            Path tmpFile = Files.createTempFile("cache", null, new FileAttribute[0]);
                            try {
                                Files.copy(in, tmpFile, StandardCopyOption.REPLACE_EXISTING);
                                File file = tmpFile.toFile();
                                JarFile jarFile = new JarFile(file);
                                file.deleteOnExit();
                                return jarFile;
                            }
                            catch (Throwable thr) {
                                try {
                                    Files.delete(tmpFile);
                                }
                                catch (IOException ioe) {
                                    thr.addSuppressed(ioe);
                                }
                                throw thr;
                            }
                        }
                    });
                } else {
                    System.err.println(String.valueOf(url.getPath()) + " load error");
                }
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
        finally {
            connection.disconnect();
        }
        return result;
    }
}

