/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.http;

import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.util.Log4jConfigurer;

public class VenusJettyServer {
    private static final int PORT = 8080;
    private Server server;
    private int port = 8080;
    private String contextPath = "/";
    private String webapp = "./webapp";

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String context) {
        this.contextPath = context;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public void setWebapp(String webapp) {
        this.webapp = webapp;
    }

    public void start() throws Exception {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
        WebAppContext context = new WebAppContext();
        context.setContextPath(this.contextPath);
        context.setResourceBase(this.webapp);
        context.setConfigurationDiscovered(true);
        this.server.setHandler((Handler)context);
        this.server.start();
    }

    public static void main(String[] args) throws Exception {
        Properties properties = new Properties();
        System.setProperty("project.home", ConfigUtil.filter((String)"${project.home:.}", (Properties)System.getProperties()));
        String projectHome = System.getProperty("project.home");
        properties.load(new FileInputStream(new File(ConfigUtil.filter((String)"${project.home:.}", (Properties)System.getProperties()), "application.properties")));
        ConfigUtil.addProperties((Properties)properties);
        String logbackConf = System.getProperty("logback.configurationFile", "${project.home}/conf/logback.xml");
        logbackConf = ConfigUtil.filter((String)logbackConf, (Properties)System.getProperties());
        File logbackFile = new File(logbackConf);
        if (logbackFile.exists()) {
            System.out.println("Log system load configuration form " + logbackConf);
            System.setProperty("logback.configurationFile", logbackConf);
        } else {
            String log4jConf = System.getProperty("log4j.configuration", "${project.home}/conf/log4j.xml");
            File log4jFile = new File(log4jConf = ConfigUtil.filter((String)log4jConf, (Properties)System.getProperties()));
            if (!log4jFile.exists()) {
                log4jConf = System.getProperty("log4j.configuration", "${project.home}/conf/log4j.properties");
                log4jConf = ConfigUtil.filter((String)log4jConf, (Properties)System.getProperties());
                log4jFile = new File(log4jConf);
            }
            if (log4jFile.exists()) {
                try {
                    System.setProperty("log4j.configuration", log4jConf);
                    System.out.println("Log system load configuration form " + log4jConf);
                    Log4jConfigurer.initLogging((String)log4jConf, (long)30000L);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        VenusJettyServer server = new VenusJettyServer();
        server.setContextPath(ConfigUtil.filter((String)"${webapp.context:/}").toString());
        server.setWebapp(ConfigUtil.filter((String)("${webapp.dir:" + projectHome + "/webapp}")).toString());
        server.setPort(Integer.parseInt(ConfigUtil.filter((String)"${webapp.port:8080}").toString()));
        server.start();
    }
}

