/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.http;

import com.meidusa.fastjson.JSONException;
import com.meidusa.venus.backend.DefaultEndpointInvocation;
import com.meidusa.venus.backend.RequestInfo;
import com.meidusa.venus.backend.Response;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.profiling.UtilTimerStack;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.convert.ConvertService;
import com.meidusa.venus.convert.DefaultConvertService;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.ExceptionLevel;
import com.meidusa.venus.exception.ServiceInvokeException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.VenusExceptionLevel;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.service.monitor.MonitorRuntime;
import com.meidusa.venus.util.Range;
import com.meidusa.venus.util.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class VenusHttpServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(VenusHttpServlet.class);
    private static String ENDPOINT_INVOKED_TIME = "invoked Total Time: ";
    private ServiceManager serviceManager;
    private VenusExceptionFactory venusExceptionFactory;
    private Pattern servicePattern = null;
    private Serializer serializer = SerializerFactory.getSerializer((short)0);
    private ConvertService convertService = new DefaultConvertService();
    private String urlPattern;
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String servletName = config.getServletName();
        this.urlPattern = config.getInitParameter("uri-pattern");
        if (StringUtils.isEmpty((String)this.urlPattern)) {
            throw new ServletException("servlet=" + servletName + "  init-param=uri-prefix cannot be null");
        }
        this.urlPattern = this.urlPattern.trim();
        this.servicePattern = Pattern.compile(this.urlPattern);
        ApplicationContext context = (ApplicationContext)config.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        this.serviceManager = (ServiceManager)context.getBean(ServiceManager.class);
        try {
            this.venusExceptionFactory = (VenusExceptionFactory)context.getBean(VenusExceptionFactory.class);
        }
        catch (BeansException e) {
            // empty catch block
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Matcher matcher;
        String uri = req.getRequestURI().trim();
        if (!req.getContextPath().equals("/")) {
            uri = uri.substring(req.getContextPath().length());
        }
        if (!this.urlPattern.endsWith("/") && uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (!(matcher = this.servicePattern.matcher(uri)).matches() || matcher.groupCount() < 2) {
            Response result = new Response();
            result.setErrorCode(18004405);
            result.setErrorMessage("requst not matcher");
            this.writeResponse(req, resp, result);
            return;
        }
        resp.setContentType("application/json");
        Map<String, Object> parameterMap = null;
        String service = matcher.group(1);
        String method = matcher.group(2);
        String clientID = req.getHeader("_venus_client_id_");
        String apiName = service + "." + method;
        Endpoint endpoint = null;
        String v = req.getParameter("v");
        int version = 0;
        try {
            version = Integer.parseInt(v == null ? "0" : v);
        }
        catch (NumberFormatException e) {
            version = 0;
        }
        try {
            endpoint = this.serviceManager.getEndpoint(apiName);
            if (req.getContentLength() > 0) {
                byte[] message = new byte[req.getContentLength()];
                req.getInputStream().read(message);
                parameterMap = this.serializer.decode(message, endpoint.getParameterTypeDict());
            } else {
                parameterMap = new HashMap();
            }
            Set keys = req.getParameterMap().keySet();
            for (String key : keys) {
                Type type = (Type)endpoint.getParameterTypeDict().get(key);
                if (type != null) {
                    parameterMap.put(key, this.convertService.convert(req.getParameter(key), type));
                    continue;
                }
                parameterMap.put(key, req.getParameter(key));
            }
        }
        catch (Exception e) {
            int errorCode = 18005000;
            if (e instanceof JSONException) {
                errorCode = 18006009;
            }
            if (e instanceof CodedException) {
                CodedException codeEx = (CodedException)e;
                errorCode = codeEx.getErrorCode();
            }
            if (e instanceof VenusExceptionLevel) {
                if (((VenusExceptionLevel)e).getLevel() != null) {
                    this.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), logger, e.getMessage() + " client:{clientID=" + clientID + ",ip=" + req.getRemoteAddr() + ", apiName=" + service + "." + method + "}", e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage() + " [ip=" + req.getRemoteAddr() + ", apiName=" + apiName + "]", (Throwable)e);
            }
            Response result = new Response();
            result.setErrorCode(errorCode);
            result.setErrorMessage(e.getMessage());
            this.writeResponse(req, resp, result);
            return;
        }
        Response result = null;
        long startTime = System.currentTimeMillis();
        try {
            result = VenusHttpServlet.checkActive(endpoint);
            if (result != null || (result = VenusHttpServlet.checkVersion(endpoint, version)) != null) {
                return;
            }
            result = this.handleRequest(this.getRequestInfo(req), endpoint, parameterMap);
            if (logger.isDebugEnabled()) {
                logger.debug("receive service request packet from " + req.getRemoteAddr());
                logger.debug("sending response to " + req.getRemoteAddr() + ": " + result + " ");
            }
        }
        catch (Exception e) {
            int errorCode = 18005000;
            if (e instanceof CodedException) {
                CodedException codeEx = (CodedException)e;
                errorCode = codeEx.getErrorCode();
            }
            result = new Response();
            result.setErrorCode(errorCode);
            result.setErrorMessage(e.getMessage());
            logger.error("error when invoke", (Throwable)e);
            return;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.writeResponse(req, resp, result);
            MonitorRuntime.getInstance().calculateAverage(service, method, endTime - startTime);
        }
    }

    private void logDependsOnLevel(ExceptionLevel level, Logger specifiedLogger, String msg, Throwable e) {
        switch (level) {
            case DEBUG: {
                specifiedLogger.debug(msg, e);
                break;
            }
            case INFO: {
                specifiedLogger.info(msg, e);
                break;
            }
            case TRACE: {
                specifiedLogger.trace(msg, e);
                break;
            }
            case WARN: {
                specifiedLogger.warn(msg, e);
                break;
            }
            case ERROR: {
                specifiedLogger.error(msg, e);
                break;
            }
        }
    }

    private static Response checkActive(Endpoint endpoint) {
        Service service = endpoint.getService();
        if (!service.isActive() || !endpoint.isActive()) {
            Response result = new Response();
            result.setErrorCode(18005006);
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service=").append(endpoint.getService().getName());
            if (!service.isActive()) {
                buffer.append(" is not active");
            }
            if (!endpoint.isActive()) {
                buffer.append(", endpoint=").append(endpoint.getName()).append(" is not active");
            }
            result.setErrorMessage(buffer.toString());
            return result;
        }
        return null;
    }

    private static Response checkVersion(Endpoint endpoint, int version) {
        Service service = endpoint.getService();
        Range range = service.getVersionRange();
        if (version <= 0 || range == null || range.contains(version)) {
            return null;
        }
        Response result = new Response();
        result.setErrorCode(18005007);
        result.setErrorMessage("Service=" + endpoint.getService().getName() + ",version=" + version + " not allow");
        return result;
    }

    private void writeResponse(HttpServletRequest req, HttpServletResponse resp, Response result) throws IOException {
        resp.setContentType("application/json");
        resp.getOutputStream().write(this.serializer.encode((Object)result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response handleRequest(RequestInfo info, Endpoint endpoint, Map<String, Object> paramters) {
        RequestContext context = new RequestContext();
        context.setParameters(paramters);
        context.setEndPointer(endpoint);
        context.setRequestInfo(info);
        Response response = new Response();
        DefaultEndpointInvocation invocation = new DefaultEndpointInvocation(context, endpoint);
        try {
            UtilTimerStack.push((String)ENDPOINT_INVOKED_TIME);
            response.setResult(invocation.invoke());
        }
        catch (Throwable e) {
            if (e instanceof ServiceInvokeException) {
                e = ((ServiceInvokeException)e).getTargetException();
            }
            if (e instanceof CodedException) {
                response.setErrorCode(((CodedException)e).getErrorCode());
                response.setErrorMessage(((CodedException)e).getMessage());
            } else {
                int errorCode = 0;
                if (this.venusExceptionFactory != null) {
                    errorCode = this.venusExceptionFactory.getErrorCode(e.getClass());
                    if (errorCode != 0) {
                        response.setErrorCode(errorCode);
                    } else {
                        response.setErrorCode(18005000);
                    }
                } else {
                    response.setErrorCode(18005000);
                }
                response.setErrorMessage(e.getMessage());
            }
            Service service = endpoint.getService();
            if (e instanceof VenusExceptionLevel) {
                if (((VenusExceptionLevel)e).getLevel() != null) {
                    this.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), logger, e.getMessage() + ",ip=" + context.getRequestInfo().getRemoteIp() + " ,api=" + service.getName() + "." + endpoint.getMethod().getName() + " , params=" + Utils.toString((Map)context.getParameters()), e);
                }
            } else if (e instanceof RuntimeException && !(e instanceof CodedException)) {
                logger.error(e.getMessage() + ",ip=" + context.getRequestInfo().getRemoteIp() + " ,api=" + service.getName() + "." + endpoint.getMethod().getName() + " , params=" + Utils.toString((Map)context.getParameters()), e);
            } else if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage() + ",ip=" + context.getRequestInfo().getRemoteIp() + " ,api=" + service.getName() + "." + endpoint.getMethod().getName() + " , params=" + Utils.toString((Map)context.getParameters()), e);
            }
        }
        finally {
            UtilTimerStack.pop((String)ENDPOINT_INVOKED_TIME);
        }
        return response;
    }

    private RequestInfo getRequestInfo(HttpServletRequest req) {
        RequestInfo info = new RequestInfo();
        info.setRemoteIp(req.getRemoteHost());
        info.setProtocol(RequestInfo.Protocol.HTTP);
        info.setAccept("application/json");
        return info;
    }
}

