/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.frontend.http;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.toolkit.common.poolable.MultipleLoadBalanceObjectPool;
import com.meidusa.toolkit.common.poolable.ObjectPool;
import com.meidusa.toolkit.common.poolable.PoolableObjectPool;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.util.StringUtil;
import com.meidusa.venus.client.ServiceFactory;
import com.meidusa.venus.client.xml.bean.FactoryConfig;
import com.meidusa.venus.client.xml.bean.PoolConfig;
import com.meidusa.venus.client.xml.bean.Remote;
import com.meidusa.venus.client.xml.bean.ServiceConfig;
import com.meidusa.venus.client.xml.bean.VenusClient;
import com.meidusa.venus.digester.DigesterRuleParser;
import com.meidusa.venus.io.network.VenusBIOConnectionFactory;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.util.FileWatchdog;
import com.meidusa.venus.util.VenusBeanUtilsBean;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.util.ResourceUtils;

public class VenusPoolFactory
implements BeanFactoryAware,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(VenusPoolFactory.class);
    private BeanFactory beanFactory;
    private String[] configFiles;
    private BeanContext beanContext;
    private List<ObjectPool> realPools = new ArrayList<ObjectPool>();
    private boolean needPing = false;
    private Timer reloadTimer = new Timer();
    private boolean enableReload = true;
    private ObjectPool pool = null;

    public ObjectPool getPool() {
        return this.pool;
    }

    public boolean isEnableReload() {
        return this.enableReload;
    }

    public void setEnableReload(boolean enableReload) {
        this.enableReload = enableReload;
    }

    public boolean isNeedPing() {
        return this.needPing;
    }

    public void setNeedPing(boolean needPing) {
        this.needPing = needPing;
    }

    public String[] getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(String[] configFiles) {
        this.configFiles = configFiles;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        block4: {
            logger.trace("current Venus Client id=" + PacketConstant.VENUS_CLIENT_ID);
            this.beanContext = new BeanContext(){

                public Object getBean(String beanName) {
                    if (VenusPoolFactory.this.beanFactory != null) {
                        return VenusPoolFactory.this.beanFactory.getBean(beanName);
                    }
                    return null;
                }

                public Object createBean(Class clazz) throws Exception {
                    if (VenusPoolFactory.this.beanFactory instanceof AutowireCapableBeanFactory) {
                        AutowireCapableBeanFactory factory = (AutowireCapableBeanFactory)VenusPoolFactory.this.beanFactory;
                        return factory.autowire(clazz, 1, false);
                    }
                    return null;
                }
            };
            BeanContextBean.getInstance().setBeanContext(this.beanContext);
            VenusBeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean()){

                public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
                    block8: {
                        if (value instanceof String) {
                            PropertyDescriptor descriptor = null;
                            try {
                                descriptor = this.getPropertyUtils().getPropertyDescriptor(bean, name);
                                if (descriptor == null) {
                                    return;
                                }
                                if (descriptor.getPropertyType().isEnum()) {
                                    Class<?> clazz = descriptor.getPropertyType();
                                    value = Enum.valueOf(clazz, (String)value);
                                    break block8;
                                }
                                Object temp = null;
                                try {
                                    temp = ConfigUtil.filter((String)((String)value), (BeanContext)VenusPoolFactory.this.beanContext);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (temp == null) {
                                    temp = ConfigUtil.filter((String)((String)value));
                                }
                                value = temp;
                            }
                            catch (NoSuchMethodException e) {
                                return;
                            }
                        }
                    }
                    super.setProperty(bean, name, value);
                }
            });
            this.reloadConfiguration();
            if (this.enableReload) {
                File[] files = new File[this.configFiles.length];
                int i = 0;
                while (i < this.configFiles.length) {
                    try {
                        files[i] = ResourceUtils.getFile((String)this.configFiles[i].trim());
                    }
                    catch (FileNotFoundException e) {
                        logger.warn(e.getMessage());
                        this.enableReload = false;
                        logger.warn("venus serviceFactory configuration reload disabled!");
                        break block4;
                    }
                    ++i;
                }
                VenusFileWatchdog dog = new VenusFileWatchdog(files);
                dog.setDelay(10000L);
                dog.start();
            }
        }
    }

    private synchronized void reloadConfiguration() throws Exception {
        ArrayList<ObjectPool> realPools = new ArrayList<ObjectPool>();
        try {
            this.loadConfiguration(realPools);
        }
        catch (Exception e) {
            this.reloadTimer.schedule((TimerTask)new ClosePoolTask(realPools), 30000L);
            throw e;
        }
        List<ObjectPool> oldPools = this.realPools;
        this.realPools = realPools;
        this.reloadTimer.schedule((TimerTask)new ClosePoolTask(oldPools), 30000L);
    }

    private void loadConfiguration(List<ObjectPool> realPools) throws Exception {
        VenusClient all = new VenusClient();
        String[] stringArray = this.configFiles;
        int n = this.configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String configFile = stringArray[n2];
            configFile = (String)ConfigUtil.filter((String)configFile);
            FromXmlRuleSet ruleSet = new FromXmlRuleSet(ServiceFactory.class.getResource("venusClientRule.xml"), (org.apache.commons.digester.xmlrules.DigesterRuleParser)new DigesterRuleParser());
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.addRuleSet((RuleSet)ruleSet);
            try {
                InputStream is = ResourceUtils.getURL((String)configFile.trim()).openStream();
                VenusClient venus = (VenusClient)digester.parse(is);
                for (ServiceConfig config : venus.getServiceConfigs()) {
                    if (config.getType() != null) continue;
                    throw new ConfigurationException("Service type can not be null:" + configFile);
                }
                all.getRemoteMap().putAll(venus.getRemoteMap());
                all.getServiceConfigs().addAll(venus.getServiceConfigs());
            }
            catch (Exception e) {
                throw new ConfigurationException("can not parser xml:" + configFile, (Throwable)e);
            }
            ++n2;
        }
        for (Map.Entry entry : all.getRemoteMap().entrySet()) {
            this.pool = this.createObjectPool((Remote)entry.getValue(), realPools);
        }
    }

    private ObjectPool createObjectPool(Remote remote, List<ObjectPool> realPools) throws Exception {
        FactoryConfig factoryConfig = remote.getFactory();
        if (factoryConfig == null) {
            throw new ConfigurationException(String.valueOf(remote.getName()) + " factory cannot be null");
        }
        PoolConfig poolConfig = remote.getPool();
        String ipAddress = factoryConfig.getIpAddressList();
        if (!StringUtil.isEmpty((String)ipAddress)) {
            String[] ipList = StringUtil.split((String)ipAddress, (String)", ");
            PoolableObjectPool[] bioPools = new PoolableObjectPool[ipList.length];
            int i = 0;
            while (i < ipList.length) {
                String[] temp;
                VenusBIOConnectionFactory bioFactory = new VenusBIOConnectionFactory();
                if (remote.getAuthenticator() != null) {
                    bioFactory.setAuthenticator(remote.getAuthenticator());
                }
                bioPools[i] = new PoolableObjectPool();
                if (poolConfig != null) {
                    BeanUtils.copyProperties((Object)bioPools[i], (Object)poolConfig);
                }
                bioFactory.setNeedPing(this.needPing);
                if (factoryConfig != null) {
                    BeanUtils.copyProperties((Object)bioFactory, (Object)factoryConfig);
                }
                if ((temp = StringUtil.split((String)ipList[i], (String)":")).length > 1) {
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(Integer.valueOf(temp[1]).intValue());
                } else {
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(16800);
                }
                bioPools[i].setName("b-connPool-" + bioFactory.getHost());
                bioPools[i].setFactory((PoolableObjectFactory)bioFactory);
                bioPools[i].init();
                realPools.add((ObjectPool)bioPools[i]);
                ++i;
            }
            MultipleLoadBalanceObjectPool bioPool = new MultipleLoadBalanceObjectPool(remote.getLoadbalance(), (ObjectPool[])bioPools);
            bioPool.setName("b-multi-connPool\uff0d" + remote.getName());
            bioPool.init();
            realPools.add((ObjectPool)bioPool);
            return bioPool;
        }
        throw new IllegalArgumentException("remtoe=" + remote.getName() + ", ipaddress cannot be null");
    }

    public synchronized void destroy() {
        for (ObjectPool pool : this.realPools) {
            try {
                pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ClosePoolTask
    extends TimerTask {
        List<ObjectPool> pools;

        public ClosePoolTask(List<ObjectPool> pools) {
            this.pools = pools;
        }

        @Override
        public void run() {
            for (ObjectPool pool : this.pools) {
                try {
                    if (pool instanceof ObjectPool) {
                        pool.close();
                        continue;
                    }
                    if (!(pool instanceof BackendConnectionPool)) continue;
                    ((BackendConnectionPool)pool).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class VenusFileWatchdog
    extends FileWatchdog {
        protected VenusFileWatchdog(File ... file) {
            super(file);
        }

        protected void doOnChange() {
            try {
                VenusPoolFactory.this.reloadConfiguration();
            }
            catch (Exception e) {
                logger.error("reload configuration error", (Throwable)e);
            }
        }
    }
}

