/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.poolable.MultipleLoadBalanceObjectPool;
import com.meidusa.toolkit.common.poolable.PoolableObjectPool;
import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.net.ConnectionConnector;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.MultipleLoadBalanceBackendConnectionPool;
import com.meidusa.toolkit.net.PollingBackendConnectionPool;
import com.meidusa.toolkit.net.factory.BackendConnectionFactory;
import com.meidusa.toolkit.util.StringUtil;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.client.InvocationListenerContainer;
import com.meidusa.venus.client.RemoteContainer;
import com.meidusa.venus.client.RemotingInvocationHandler;
import com.meidusa.venus.client.ServiceFactory;
import com.meidusa.venus.client.VenusNIOMessageHandler;
import com.meidusa.venus.client.xml.bean.FactoryConfig;
import com.meidusa.venus.client.xml.bean.PoolConfig;
import com.meidusa.venus.client.xml.bean.Remote;
import com.meidusa.venus.client.xml.bean.ServiceConfig;
import com.meidusa.venus.client.xml.bean.VenusClient;
import com.meidusa.venus.digester.DigesterRuleParser;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.io.network.VenusBIOConnectionFactory;
import com.meidusa.venus.io.network.VenusBackendConnectionFactory;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.util.FileWatchdog;
import com.meidusa.venus.util.VenusBeanUtilsBean;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ResourceUtils;

public class VenusServiceFactory
implements ServiceFactory,
BeanFactoryAware,
InitializingBean,
BeanFactoryPostProcessor {
    private static Logger logger = LoggerFactory.getLogger(ServiceFactory.class);
    private Map<Class<?>, Tuple<Object, RemotingInvocationHandler>> servicesMap = new HashMap();
    private Map<String, Tuple<Object, RemotingInvocationHandler>> serviceBeanMap = new HashMap<String, Tuple<Object, RemotingInvocationHandler>>();
    private BeanFactory beanFactory;
    private ConnectionManager connManager;
    private ConnectionConnector connector;
    private String[] configFiles;
    private BeanContext beanContext;
    private boolean enableAsync = true;
    private boolean shutdown = false;
    private Map<String, Tuple<com.meidusa.toolkit.common.poolable.ObjectPool, BackendConnectionPool>> poolMap = new HashMap<String, Tuple<com.meidusa.toolkit.common.poolable.ObjectPool, BackendConnectionPool>>();
    private List<Object> realPools = new ArrayList<Object>();
    private InvocationListenerContainer container = new InvocationListenerContainer();
    private VenusNIOMessageHandler handler = new VenusNIOMessageHandler();
    private VenusExceptionFactory venusExceptionFactory;
    private Map<Class<?>, ServiceConfig> serviceConfig = new HashMap();
    private int asyncExecutorSize = 10;
    private boolean needPing = false;
    private Timer reloadTimer = new Timer();
    private boolean enableReload = false;

    public boolean isEnableReload() {
        return this.enableReload;
    }

    public void setEnableReload(boolean enableReload) {
        this.enableReload = enableReload;
    }

    public boolean isNeedPing() {
        return this.needPing;
    }

    public void setNeedPing(boolean needPing) {
        this.needPing = needPing;
    }

    public boolean isEnableAsync() {
        return this.enableAsync;
    }

    public void setEnableAsync(boolean enableAsync) {
        this.enableAsync = enableAsync;
    }

    public int getAsyncExecutorSize() {
        return this.asyncExecutorSize;
    }

    public ConnectionConnector getConnector() {
        return this.connector;
    }

    public void setConnector(ConnectionConnector connector) {
        this.connector = connector;
    }

    public void setAsyncExecutorSize(int asyncExecutorSize) {
        this.asyncExecutorSize = asyncExecutorSize;
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public String[] getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(String[] configFiles) {
        this.configFiles = configFiles;
    }

    @Override
    public <T> T getService(Class<T> t) {
        if (this.shutdown) {
            throw new IllegalStateException("service factory has been shutdown");
        }
        Tuple<Object, RemotingInvocationHandler> object = this.servicesMap.get(t);
        return (T)object.left;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        block10: {
            logger.trace("current Venus Client id=" + PacketConstant.VENUS_CLIENT_ID);
            if (this.venusExceptionFactory == null) {
                XmlVenusExceptionFactory xmlVenusExceptionFactory = new XmlVenusExceptionFactory();
                xmlVenusExceptionFactory.init();
                this.venusExceptionFactory = xmlVenusExceptionFactory;
            }
            this.handler.setVenusExceptionFactory(this.venusExceptionFactory);
            if (this.enableAsync) {
                if (this.connector == null) {
                    this.connector = new ConnectionConnector("connection Connector");
                    this.connector.setDaemon(true);
                }
                if (this.connManager == null) {
                    try {
                        this.connManager = new ConnectionManager("Connection Manager", this.getAsyncExecutorSize());
                    }
                    catch (IOException e) {
                        throw new InitialisationException((Throwable)e);
                    }
                    this.connManager.setDaemon(true);
                    this.connManager.start();
                    this.connector.setProcessors(new ConnectionManager[]{this.connManager});
                }
                this.connector.start();
            }
            this.beanContext = new BeanContext(){

                public Object getBean(String beanName) {
                    if (VenusServiceFactory.this.beanFactory != null) {
                        return VenusServiceFactory.this.beanFactory.getBean(beanName);
                    }
                    return null;
                }

                public Object createBean(Class clazz) throws Exception {
                    if (VenusServiceFactory.this.beanFactory instanceof AutowireCapableBeanFactory) {
                        AutowireCapableBeanFactory factory = (AutowireCapableBeanFactory)VenusServiceFactory.this.beanFactory;
                        return factory.autowire(clazz, 1, false);
                    }
                    return null;
                }
            };
            BeanContextBean.getInstance().setBeanContext(this.beanContext);
            VenusBeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean()){

                public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
                    block8: {
                        if (value instanceof String) {
                            PropertyDescriptor descriptor = null;
                            try {
                                descriptor = this.getPropertyUtils().getPropertyDescriptor(bean, name);
                                if (descriptor == null) {
                                    return;
                                }
                                if (descriptor.getPropertyType().isEnum()) {
                                    Class<?> clazz = descriptor.getPropertyType();
                                    value = Enum.valueOf(clazz, (String)value);
                                    break block8;
                                }
                                Object temp = null;
                                try {
                                    temp = ConfigUtil.filter((String)((String)value), (BeanContext)VenusServiceFactory.this.beanContext);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (temp == null) {
                                    temp = ConfigUtil.filter((String)((String)value));
                                }
                                value = temp;
                            }
                            catch (NoSuchMethodException e) {
                                return;
                            }
                        }
                    }
                    super.setProperty(bean, name, value);
                }
            });
            this.handler.setContainer(this.container);
            this.reloadConfiguration();
            if (this.enableReload) {
                File[] files = new File[this.configFiles.length];
                int i = 0;
                while (i < this.configFiles.length) {
                    try {
                        files[i] = ResourceUtils.getFile((String)this.configFiles[i].trim());
                    }
                    catch (FileNotFoundException e) {
                        logger.warn(e.getMessage());
                        this.enableReload = false;
                        logger.warn("venus serviceFactory configuration reload disabled!");
                        break block10;
                    }
                    ++i;
                }
                VenusFileWatchdog dog = new VenusFileWatchdog(files);
                dog.setDelay(10000L);
                dog.start();
            }
        }
    }

    private synchronized void reloadConfiguration() throws Exception {
        HashMap servicesMap = new HashMap();
        HashMap<String, Tuple<com.meidusa.toolkit.common.poolable.ObjectPool, BackendConnectionPool>> poolMap = new HashMap<String, Tuple<com.meidusa.toolkit.common.poolable.ObjectPool, BackendConnectionPool>>();
        HashMap serviceConfig = new HashMap();
        ArrayList<Object> realPools = new ArrayList<Object>();
        try {
            this.loadConfiguration(poolMap, servicesMap, serviceConfig, realPools);
        }
        catch (Exception e) {
            this.reloadTimer.schedule((TimerTask)new ClosePoolTask(realPools), 30000L);
            throw e;
        }
        this.poolMap = poolMap;
        for (Map.Entry entry : servicesMap.entrySet()) {
            Class key = (Class)entry.getKey();
            Tuple source = (Tuple)entry.getValue();
            Tuple<Object, RemotingInvocationHandler> target = this.servicesMap.get(key);
            if (target != null) {
                ((RemotingInvocationHandler)target.right).setBioConnPool(((RemotingInvocationHandler)source.getRight()).getBioConnPool());
                ((RemotingInvocationHandler)target.right).setNioConnPool(((RemotingInvocationHandler)source.getRight()).getNioConnPool());
                ((RemotingInvocationHandler)target.right).setSerializeType((byte)((RemotingInvocationHandler)target.right).getSerializeType());
                continue;
            }
            this.servicesMap.put(key, (Tuple<Object, RemotingInvocationHandler>)source);
        }
        this.serviceConfig = serviceConfig;
        List<Object> oldPools = this.realPools;
        this.realPools = realPools;
        this.reloadTimer.schedule((TimerTask)new ClosePoolTask(oldPools), 30000L);
    }

    private void loadConfiguration(Map<String, Tuple<com.meidusa.toolkit.common.poolable.ObjectPool, BackendConnectionPool>> poolMap, Map<Class<?>, Tuple<Object, RemotingInvocationHandler>> servicesMap, Map<Class<?>, ServiceConfig> serviceConfig, List<Object> realPools) throws Exception {
        Tuple tuple;
        VenusClient all = new VenusClient();
        String[] stringArray = this.configFiles;
        int n = this.configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String configFile = stringArray[n2];
            configFile = (String)ConfigUtil.filter((String)configFile);
            FromXmlRuleSet ruleSet = new FromXmlRuleSet(this.getClass().getResource("venusClientRule.xml"), (org.apache.commons.digester.xmlrules.DigesterRuleParser)new DigesterRuleParser());
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.addRuleSet((RuleSet)ruleSet);
            try {
                InputStream is = ResourceUtils.getURL((String)configFile.trim()).openStream();
                VenusClient venus = (VenusClient)digester.parse(is);
                for (ServiceConfig config : venus.getServiceConfigs()) {
                    if (config.getType() != null) continue;
                    throw new ConfigurationException("Service type can not be null:" + configFile);
                }
                all.getRemoteMap().putAll(venus.getRemoteMap());
                all.getServiceConfigs().addAll(venus.getServiceConfigs());
            }
            catch (Exception e) {
                throw new ConfigurationException("can not parser xml:" + configFile, (Throwable)e);
            }
            ++n2;
        }
        for (Map.Entry<String, Remote> entry : all.getRemoteMap().entrySet()) {
            RemoteContainer container = this.createRemoteContainer(entry.getValue(), realPools);
            tuple = new Tuple();
            tuple.left = container.getBioPool();
            tuple.right = container.getNioPool();
            poolMap.put(entry.getKey(), (Tuple<com.meidusa.toolkit.common.poolable.ObjectPool, BackendConnectionPool>)tuple);
        }
        for (ServiceConfig config : all.getServiceConfigs()) {
            Remote remote = all.getRemoteMap().get(config.getRemote());
            tuple = null;
            if (!StringUtil.isEmpty((String)config.getRemote())) {
                tuple = poolMap.get(config.getRemote());
                if (tuple == null) {
                    throw new ConfigurationException("remote=" + config.getRemote() + " not found!!");
                }
            } else {
                String ipAddress = config.getIpAddressList();
                tuple = poolMap.get(ipAddress);
                if (ipAddress != null && tuple == null) {
                    RemoteContainer container = this.createRemoteContainer(ipAddress, realPools);
                    tuple = new Tuple();
                    tuple.left = container.getBioPool();
                    tuple.right = container.getNioPool();
                    poolMap.put(ipAddress, (Tuple<com.meidusa.toolkit.common.poolable.ObjectPool, BackendConnectionPool>)tuple);
                }
            }
            if (tuple != null) {
                RemotingInvocationHandler invocationHandler = new RemotingInvocationHandler();
                invocationHandler.setBioConnPool((ObjectPool)tuple.left);
                invocationHandler.setNioConnPool((BackendConnectionPool)tuple.right);
                invocationHandler.setServiceFactory(this);
                invocationHandler.setVenusExceptionFactory(this.getVenusExceptionFactory());
                if (remote != null && remote.getAuthenticator() != null) {
                    invocationHandler.setSerializeType(remote.getAuthenticator().getSerializeType());
                }
                invocationHandler.setContainer(this.container);
                Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{config.getType()}, (InvocationHandler)invocationHandler);
                Method[] methodArray = config.getType().getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method method = methodArray[n4];
                    Endpoint endpoint = method.getAnnotation(Endpoint.class);
                    if (endpoint != null) {
                        Class<?>[] eclazz;
                        Class<?>[] classArray = eclazz = method.getExceptionTypes();
                        int n5 = eclazz.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Class<?> clazz = classArray[n6];
                            if (this.venusExceptionFactory != null && CodedException.class.isAssignableFrom(clazz)) {
                                this.venusExceptionFactory.addException(clazz);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                serviceConfig.put(config.getType(), config);
                Tuple serviceTuple = new Tuple(object, (Object)invocationHandler);
                servicesMap.put(config.getType(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                if (config.getBeanName() == null) continue;
                this.serviceBeanMap.put(config.getBeanName(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                continue;
            }
            if (config.getInstance() != null) {
                Tuple serviceTuple = new Tuple(config.getInstance(), null);
                servicesMap.put(config.getType(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                if (config.getBeanName() == null) continue;
                this.serviceBeanMap.put(config.getBeanName(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                continue;
            }
            throw new ConfigurationException("Service instance or ipAddressList or remote can not be null:" + config.getType());
        }
    }

    private RemoteContainer createRemoteContainer(String ipAddress, List<Object> realPools) throws Exception {
        RemoteContainer container = new RemoteContainer();
        if (!StringUtil.isEmpty((String)ipAddress)) {
            String[] ipList = StringUtil.split((String)ipAddress, (String)", ");
            PoolableObjectPool[] bioPools = new PoolableObjectPool[ipList.length];
            BackendConnectionPool[] nioPools = new BackendConnectionPool[ipList.length];
            int i = 0;
            while (i < ipList.length) {
                VenusBackendConnectionFactory nioFactory = new VenusBackendConnectionFactory();
                nioPools[i] = new PollingBackendConnectionPool("N-" + ipList[0], (BackendConnectionFactory)nioFactory, 8);
                bioPools[i] = new PoolableObjectPool();
                VenusBIOConnectionFactory bioFactory = new VenusBIOConnectionFactory();
                bioFactory.setNeedPing(this.needPing);
                String[] temp = StringUtil.split((String)ipList[i], (String)":");
                if (temp.length > 1) {
                    nioFactory.setHost(temp[0]);
                    nioFactory.setPort(Integer.valueOf(temp[1]).intValue());
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(Integer.valueOf(temp[1]).intValue());
                } else {
                    nioFactory.setHost(temp[0]);
                    nioFactory.setPort(16800);
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(16800);
                }
                if (this.isEnableAsync()) {
                    nioFactory.setConnector(this.connector);
                    nioFactory.setMessageHandler((MessageHandler)this.handler);
                    nioPools[i].init();
                    realPools.add(nioPools[i]);
                }
                bioPools[i].setName("B-" + nioFactory.getHost() + ":" + nioFactory.getPort());
                bioPools[i].setFactory((PoolableObjectFactory)bioFactory);
                bioPools[i].setTestOnBorrow(true);
                bioPools[i].setTestWhileIdle(true);
                bioPools[i].init();
                realPools.add(bioPools[i]);
                ++i;
            }
            if (ipList.length > 1) {
                MultipleLoadBalanceObjectPool bioPool = new MultipleLoadBalanceObjectPool(1, (com.meidusa.toolkit.common.poolable.ObjectPool[])bioPools);
                MultipleLoadBalanceBackendConnectionPool nioPool = new MultipleLoadBalanceBackendConnectionPool("N-V-" + ipAddress, 1, nioPools);
                bioPool.setName("B-V-" + ipAddress);
                nioPool.init();
                bioPool.init();
                realPools.add(bioPool);
                realPools.add(nioPools[0]);
                container.setBioPool((com.meidusa.toolkit.common.poolable.ObjectPool)bioPool);
                container.setNioPool(nioPools[0]);
            } else {
                container.setBioPool((com.meidusa.toolkit.common.poolable.ObjectPool)bioPools[0]);
                container.setNioPool(nioPools[0]);
            }
        } else {
            throw new IllegalArgumentException(" ipaddress cannot be null");
        }
        return container;
    }

    private RemoteContainer createRemoteContainer(Remote remote, List<Object> realPools) throws Exception {
        RemoteContainer container = new RemoteContainer();
        FactoryConfig factoryConfig = remote.getFactory();
        if (factoryConfig == null) {
            throw new ConfigurationException(String.valueOf(remote.getName()) + " factory cannot be null");
        }
        PoolConfig poolConfig = remote.getPool();
        String ipAddress = factoryConfig.getIpAddressList();
        if (!StringUtil.isEmpty((String)ipAddress)) {
            String[] ipList = StringUtil.split((String)ipAddress, (String)", ");
            PoolableObjectPool[] bioPools = new PoolableObjectPool[ipList.length];
            BackendConnectionPool[] nioPools = new BackendConnectionPool[ipList.length];
            int i = 0;
            while (i < ipList.length) {
                String[] temp;
                VenusBackendConnectionFactory nioFactory = new VenusBackendConnectionFactory();
                VenusBIOConnectionFactory bioFactory = new VenusBIOConnectionFactory();
                if (remote.getAuthenticator() != null) {
                    bioFactory.setAuthenticator(remote.getAuthenticator());
                }
                nioPools[i] = new PollingBackendConnectionPool("n-" + ipList[i], (BackendConnectionFactory)nioFactory, 8);
                bioPools[i] = new PoolableObjectPool();
                if (poolConfig != null) {
                    BeanUtils.copyProperties((Object)nioPools[i], (Object)poolConfig);
                    BeanUtils.copyProperties((Object)bioPools[i], (Object)poolConfig);
                }
                if (remote.getAuthenticator() != null) {
                    nioFactory.setAuthenticator(remote.getAuthenticator());
                }
                bioFactory.setNeedPing(this.needPing);
                if (factoryConfig != null) {
                    BeanUtils.copyProperties((Object)nioFactory, (Object)factoryConfig);
                    BeanUtils.copyProperties((Object)bioFactory, (Object)factoryConfig);
                }
                if ((temp = StringUtil.split((String)ipList[i], (String)":")).length > 1) {
                    nioFactory.setHost(temp[0]);
                    nioFactory.setPort(Integer.valueOf(temp[1]).intValue());
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(Integer.valueOf(temp[1]).intValue());
                } else {
                    nioFactory.setHost(temp[0]);
                    nioFactory.setPort(16800);
                    bioFactory.setHost(temp[0]);
                    bioFactory.setPort(16800);
                }
                if (this.isEnableAsync()) {
                    nioFactory.setConnector(this.connector);
                    nioFactory.setMessageHandler((MessageHandler)this.handler);
                    nioPools[i].init();
                    realPools.add(nioPools[i]);
                }
                bioPools[i].setName("B-" + bioFactory.getHost());
                bioPools[i].setFactory((PoolableObjectFactory)bioFactory);
                bioPools[i].init();
                realPools.add(bioPools[i]);
                ++i;
            }
            if (ipList.length > 1) {
                MultipleLoadBalanceObjectPool bioPool = new MultipleLoadBalanceObjectPool(remote.getLoadbalance(), (com.meidusa.toolkit.common.poolable.ObjectPool[])bioPools);
                MultipleLoadBalanceBackendConnectionPool nioPool = new MultipleLoadBalanceBackendConnectionPool(remote.getName(), remote.getLoadbalance(), nioPools);
                bioPool.setName("B-V-" + remote.getName());
                container.setBioPool((com.meidusa.toolkit.common.poolable.ObjectPool)bioPool);
                container.setNioPool((BackendConnectionPool)nioPool);
                bioPool.init();
                nioPool.init();
                realPools.add(bioPool);
                realPools.add(nioPool);
            } else {
                container.setBioPool((com.meidusa.toolkit.common.poolable.ObjectPool)bioPools[0]);
                container.setNioPool(nioPools[0]);
            }
        } else {
            throw new IllegalArgumentException("remtoe=" + remote.getName() + ", ipaddress cannot be null");
        }
        container.setRemote(remote);
        return container;
    }

    public ServiceConfig getServiceConfig(Class<?> type) {
        return this.serviceConfig.get(type);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory cbf = beanFactory;
            for (Map.Entry<Class<?>, Tuple<Object, RemotingInvocationHandler>> entry : this.servicesMap.entrySet()) {
                cbf.registerResolvableDependency(entry.getKey(), entry.getValue().left);
            }
            for (Map.Entry<Object, Tuple<Object, RemotingInvocationHandler>> entry : this.serviceBeanMap.entrySet()) {
                cbf.registerSingleton((String)entry.getKey(), entry.getValue().left);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.connector != null && this.connector.isAlive()) {
            this.connector.shutdown();
        }
        if (this.connManager != null && this.connManager.isAlive()) {
            this.connManager.shutdown();
        }
    }

    class ClosePoolTask
    extends TimerTask {
        List<Object> pools;

        public ClosePoolTask(List<Object> pools) {
            this.pools = pools;
        }

        @Override
        public void run() {
            for (Object pool : this.pools) {
                try {
                    if (pool instanceof com.meidusa.toolkit.common.poolable.ObjectPool) {
                        ((com.meidusa.toolkit.common.poolable.ObjectPool)pool).close();
                        continue;
                    }
                    if (!(pool instanceof BackendConnectionPool)) continue;
                    ((BackendConnectionPool)pool).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class VenusFileWatchdog
    extends FileWatchdog {
        protected VenusFileWatchdog(File ... file) {
            super(file);
        }

        protected void doOnChange() {
            try {
                VenusServiceFactory.this.reloadConfiguration();
            }
            catch (Exception e) {
                logger.error("reload configuration error", (Throwable)e);
            }
        }
    }
}

