/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastmark.feature.SerializerFeature;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.util.TimeUtil;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.ExceptionCode;
import com.meidusa.venus.annotations.PerformanceLevel;
import com.meidusa.venus.annotations.RemoteException;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.client.InvocationListenerContainer;
import com.meidusa.venus.client.VenusInvocationHandler;
import com.meidusa.venus.client.VenusServiceFactory;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.InvalidParameterException;
import com.meidusa.venus.exception.RemoteSocketIOException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.extension.athena.AthenaTransactionId;
import com.meidusa.venus.extension.athena.delegate.AthenaTransactionDelegate;
import com.meidusa.venus.io.network.AbstractBIOConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.metainfo.EndpointParameter;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.poolable.RequestLoadbalanceObjectPool;
import com.meidusa.venus.util.UUID;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusAnnotationUtils;
import com.meidusa.venus.util.VenusTracerUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.pool.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingInvocationHandler
extends VenusInvocationHandler {
    private static SerializerFeature[] JSON_FEATURE = new SerializerFeature[]{SerializerFeature.ShortString};
    private static Logger logger = LoggerFactory.getLogger(RemotingInvocationHandler.class);
    private static Logger performanceLogger = LoggerFactory.getLogger((String)"venus.client.performance");
    private InvocationListenerContainer container;
    private ObjectPool bioConnPool;
    private BackendConnectionPool nioConnPool;
    private static AtomicLong sequenceId = new AtomicLong(1L);
    private VenusServiceFactory serviceFactory;
    private VenusExceptionFactory venusExceptionFactory;
    private boolean enableAsync = true;
    private byte serializeType = 0;

    public boolean isEnableAsync() {
        return this.enableAsync;
    }

    public void setEnableAsync(boolean enableAsync) {
        this.enableAsync = enableAsync;
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public void setServiceFactory(VenusServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public short getSerializeType() {
        return this.serializeType;
    }

    public void setSerializeType(byte serializeType) {
        this.serializeType = serializeType;
    }

    public InvocationListenerContainer getContainer() {
        return this.container;
    }

    public void setContainer(InvocationListenerContainer container) {
        this.container = container;
    }

    public ObjectPool getBioConnPool() {
        return this.bioConnPool;
    }

    public void setBioConnPool(ObjectPool bioConnPool) {
        this.bioConnPool = bioConnPool;
    }

    public BackendConnectionPool getNioConnPool() {
        return this.nioConnPool;
    }

    public void setNioConnPool(BackendConnectionPool nioConnPool) {
        this.nioConnPool = nioConnPool;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object invokeRemoteService(Service service, Endpoint endpoint, Method method, EndpointParameter[] params, Object[] args) throws Exception {
        apiName = VenusAnnotationUtils.getApiname((Method)method, (Service)service, (Endpoint)endpoint);
        athenaTransactionId = null;
        if (service.athenaFlag()) {
            athenaTransactionId = AthenaTransactionDelegate.getDelegate().startClientTransaction(apiName);
        }
        async = false;
        if (endpoint.async()) {
            async = true;
        }
        if ((traceID = VenusTracerUtil.getTracerID()) == null) {
            traceID = VenusTracerUtil.randomTracerID();
        }
        serializer = SerializerFactory.getSerializer((short)this.serializeType);
        serviceRequestPacket = new SerializeServiceRequestPacket(serializer, null);
        serviceRequestPacket.clientId = PacketConstant.VENUS_CLIENT_ID;
        serviceRequestPacket.clientRequestId = RemotingInvocationHandler.sequenceId.getAndIncrement();
        serviceRequestPacket.traceId = traceID;
        serviceRequestPacket.apiName = apiName;
        serviceRequestPacket.serviceVersion = service.version();
        serviceRequestPacket.parameterMap = new HashMap<K, V>();
        if (params != null) {
            i = 0;
            while (i < params.length) {
                if (args[i] instanceof InvocationListener) {
                    async = true;
                    listener = new ReferenceInvocationListener();
                    buffer = new ServicePacketBuffer(16);
                    buffer.writeLengthCodedString(args[i].getClass().getName(), "utf-8");
                    buffer.writeInt(System.identityHashCode(args[i]));
                    listener.setIdentityData(buffer.toByteBuffer().array());
                    type = method.getGenericParameterTypes()[i];
                    if (type instanceof ParameterizedType == false) throw new InvalidParameterException("invocationListener is not generic");
                    genericType = (ParameterizedType)type;
                    this.container.putInvocationListener((InvocationListener)args[i], genericType.getActualTypeArguments()[0]);
                    serviceRequestPacket.parameterMap.put(params[i].getParamName(), listener);
                } else {
                    serviceRequestPacket.parameterMap.put(params[i].getParamName(), args[i]);
                }
                ++i;
            }
        }
        this.setTransactionId(serviceRequestPacket, athenaTransactionId);
        pLevel = (PerformanceLevel)AnnotationUtil.getAnnotation((Annotation[])method.getAnnotations(), PerformanceLevel.class);
        borrowed = start = TimeUtil.currentTimeMillis();
        if (async) {
            if (!this.isEnableAsync()) {
                throw new VenusConfigException("service async call disabled");
            }
            conn = null;
            try {
                conn = this.nioConnPool instanceof RequestLoadbalanceObjectPool != false ? (BackendConnection)((RequestLoadbalanceObjectPool)this.nioConnPool).borrowObject(serviceRequestPacket.parameterMap, endpoint) : this.nioConnPool.borrowObject();
                borrowed = TimeUtil.currentTimeMillis();
                buffer = serviceRequestPacket.toByteBuffer();
                if (service.athenaFlag()) {
                    AthenaTransactionDelegate.getDelegate().setClientOutputSize((long)buffer.limit());
                }
                conn.write(buffer);
                VenusTracerUtil.logRequest((byte[])traceID, (String)serviceRequestPacket.apiName, (String)JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                return null;
            }
            finally {
                if (service.athenaFlag()) {
                    AthenaTransactionDelegate.getDelegate().completeClientTransaction();
                }
                if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                    end = TimeUtil.currentTimeMillis();
                    time = end - borrowed;
                    buffer = new StringBuffer();
                    buffer.append("[").append(borrowed - start).append(",").append(time).append("]ms (client-async) traceID=").append(UUID.toString((byte[])traceID)).append(", api=").append(serviceRequestPacket.apiName);
                    RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                }
                if (conn != null) {
                    this.nioConnPool.returnObject(conn);
                }
            }
        }
        conn = null;
        soTimeout = 0;
        oldTimeout = 0;
        success = true;
        errorCode = 0;
        packet = null;
        remoteAddress = null;
        invalided = false;
        nullForSystemException = false;
        try {
            block146: {
                block144: {
                    block147: {
                        block145: {
                            block143: {
                                block141: {
                                    block142: {
                                        conn = this.bioConnPool instanceof RequestLoadbalanceObjectPool != false ? (AbstractBIOConnection)((RequestLoadbalanceObjectPool)this.bioConnPool).borrowObject(serviceRequestPacket.parameterMap, endpoint) : (AbstractBIOConnection)this.bioConnPool.borrowObject();
                                        remoteAddress = conn.getRemoteAddress();
                                        borrowed = TimeUtil.currentTimeMillis();
                                        config = this.serviceFactory.getServiceConfig(method.getDeclaringClass());
                                        oldTimeout = conn.getSoTimeout();
                                        if (config == null) break block141;
                                        endpointConfig = config.getEndpointConfig(endpoint.name());
                                        if (endpointConfig == null) break block142;
                                        eTimeOut = endpointConfig.getTimeWait();
                                        if (eTimeOut > 0) {
                                            soTimeout = eTimeOut;
                                        }
                                        break block143;
                                    }
                                    if (config.getTimeWait() > 0) {
                                        soTimeout = config.getTimeWait();
                                        break block143;
                                    } else if (endpoint.timeWait() > 0) {
                                        soTimeout = endpoint.timeWait();
                                    }
                                    break block143;
                                }
                                if (endpoint.timeWait() > 0) {
                                    soTimeout = endpoint.timeWait();
                                }
                            }
                            try {
                                if (soTimeout > 0) {
                                    conn.setSoTimeout(soTimeout);
                                }
                                buff = serviceRequestPacket.toByteArray();
                                if (service.athenaFlag() && buff != null) {
                                    AthenaTransactionDelegate.getDelegate().setClientOutputSize((long)buff.length);
                                }
                                conn.write(buff);
                                VenusTracerUtil.logRequest((byte[])traceID, (String)serviceRequestPacket.apiName, (String)JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                                bts = conn.read();
                                if (service.athenaFlag() && bts != null) {
                                    AthenaTransactionDelegate.getDelegate().setClientInputSize((long)bts.length);
                                }
                            }
                            catch (IOException e) {
                                try {
                                    conn.close();
                                }
                                catch (Exception var29_46) {
                                    // empty catch block
                                }
                                this.bioConnPool.invalidateObject((Object)conn);
                                invalided = true;
                                eClass = method.getExceptionTypes();
                                if (eClass == null) throw new RemoteSocketIOException("api=" + serviceRequestPacket.apiName + ", remoteIp=" + conn.getRemoteAddress() + ",(" + e.getMessage() + ")", (Throwable)e);
                                if (eClass.length <= 0) throw new RemoteSocketIOException("api=" + serviceRequestPacket.apiName + ", remoteIp=" + conn.getRemoteAddress() + ",(" + e.getMessage() + ")", (Throwable)e);
                                var33_49 = eClass;
                                var32_50 = eClass.length;
                                var31_53 = 0;
                                if (true) ** GOTO lbl373
                            }
                            type = AbstractServicePacket.getType((byte[])bts);
                            switch (type) {
                                case -1: {
                                    error = new ErrorPacket();
                                    error.init(bts);
                                    packet = error;
                                    e = this.venusExceptionFactory.getException(error.errorCode, error.message);
                                    if (e == null) {
                                        throw new DefaultVenusException(error.errorCode, error.message);
                                    }
                                    if (error.additionalData == null) throw e;
                                    tmap = Utils.getBeanFieldType(e.getClass(), Exception.class);
                                    if (tmap == null) throw e;
                                    if (tmap.size() <= 0) throw e;
                                    obj = serializer.decode(error.additionalData, tmap);
                                    BeanUtils.copyProperties((Object)e, (Object)obj);
                                    throw e;
                                }
                                case 1: {
                                    ok = new OKPacket();
                                    ok.init(bts);
                                    packet = ok;
                                    if (service.athenaFlag()) {
                                        AthenaTransactionDelegate.getDelegate().completeClientTransaction();
                                    }
                                    end = TimeUtil.currentTimeMillis();
                                    time = end - borrowed;
                                    buffer = new StringBuffer();
                                    buffer.append("[").append(borrowed - start).append(",").append(time).append("]ms (client-sync) traceID=").append(UUID.toString((byte[])traceID)).append(", api=").append(serviceRequestPacket.apiName);
                                    if (remoteAddress != null) {
                                        buffer.append(", remote=").append(remoteAddress);
                                    } else {
                                        buffer.append(", pool=").append(this.bioConnPool.toString());
                                    }
                                    buffer.append(", clientID=").append(PacketConstant.VENUS_CLIENT_ID).append(", requestID=").append(serviceRequestPacket.clientRequestId);
                                    if (packet != null) {
                                        if (packet instanceof ErrorPacket) {
                                            buffer.append(", errorCode=").append(packet.errorCode);
                                            buffer.append(", message=").append(packet.message);
                                        } else {
                                            buffer.append(", errorCode=0");
                                        }
                                    }
                                    if (pLevel == null) ** GOTO lbl193
                                    if (pLevel.printParams()) {
                                        buffer.append(", params=");
                                        buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                                    }
                                    if (time <= (long)pLevel.error() || pLevel.error() <= 0) ** GOTO lbl182
                                    if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                                    }
                                    ** GOTO lbl211
lbl182:
                                    // 1 sources

                                    if (time <= (long)pLevel.warn() || pLevel.warn() <= 0) ** GOTO lbl186
                                    if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                                    }
                                    ** GOTO lbl211
lbl186:
                                    // 1 sources

                                    if (time > (long)pLevel.info() && pLevel.info() > 0) {
                                        if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                                        }
                                    } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                                    }
                                    ** GOTO lbl211
lbl193:
                                    // 1 sources

                                    buffer.append(", params=");
                                    buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                                    if (time >= 30000L) {
                                        if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                                        }
                                    } else if (time >= 10000L) {
                                        if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                                        }
                                    } else if (time >= 5000L) {
                                        if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                                        }
                                    } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                                    }
lbl211:
                                    // 10 sources

                                    if (conn == null) return null;
                                    if (invalided != false) return null;
                                    if (!conn.isClosed() && soTimeout > 0) {
                                        conn.setSoTimeout(oldTimeout);
                                    }
                                    this.bioConnPool.returnObject((Object)conn);
                                    return null;
                                }
                                case 0x2000002: {
                                    response = new SerializeServiceResponsePacket(serializer, method.getGenericReturnType());
                                    response.init(bts);
                                    packet = response;
                                    var35_70 = response.result;
                                    if (service.athenaFlag()) {
                                        AthenaTransactionDelegate.getDelegate().completeClientTransaction();
                                    }
                                    end = TimeUtil.currentTimeMillis();
                                    time = end - borrowed;
                                    buffer = new StringBuffer();
                                    buffer.append("[").append(borrowed - start).append(",").append(time).append("]ms (client-sync) traceID=").append(UUID.toString((byte[])traceID)).append(", api=").append(serviceRequestPacket.apiName);
                                    if (remoteAddress != null) {
                                        buffer.append(", remote=").append(remoteAddress);
                                    } else {
                                        buffer.append(", pool=").append(this.bioConnPool.toString());
                                    }
                                    buffer.append(", clientID=").append(PacketConstant.VENUS_CLIENT_ID).append(", requestID=").append(serviceRequestPacket.clientRequestId);
                                    if (packet != null) {
                                        if (packet instanceof ErrorPacket) {
                                            buffer.append(", errorCode=").append(packet.errorCode);
                                            buffer.append(", message=").append(packet.message);
                                        } else {
                                            buffer.append(", errorCode=0");
                                        }
                                    }
                                    if (pLevel == null) ** GOTO lbl268
                                    if (pLevel.printParams()) {
                                        buffer.append(", params=");
                                        buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                                    }
                                    if (time <= (long)pLevel.error() || pLevel.error() <= 0) ** GOTO lbl257
                                    if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                                    }
                                    ** GOTO lbl286
lbl257:
                                    // 1 sources

                                    if (time <= (long)pLevel.warn() || pLevel.warn() <= 0) ** GOTO lbl261
                                    if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                                    }
                                    ** GOTO lbl286
lbl261:
                                    // 1 sources

                                    if (time > (long)pLevel.info() && pLevel.info() > 0) {
                                        if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                                        }
                                    } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                                    }
                                    ** GOTO lbl286
lbl268:
                                    // 1 sources

                                    buffer.append(", params=");
                                    buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                                    if (time >= 30000L) {
                                        if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                                        }
                                    } else if (time >= 10000L) {
                                        if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                                        }
                                    } else if (time >= 5000L) {
                                        if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                                            RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                                        }
                                    } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                                        RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                                    }
lbl286:
                                    // 10 sources

                                    if (conn == null) return var35_70;
                                    if (invalided != false) return var35_70;
                                    if (!conn.isClosed() && soTimeout > 0) {
                                        conn.setSoTimeout(oldTimeout);
                                    }
                                    this.bioConnPool.returnObject((Object)conn);
                                    return var35_70;
                                }
                            }
                            RemotingInvocationHandler.logger.warn("unknow response type=" + type);
                            success = false;
                            if (service.athenaFlag()) {
                                AthenaTransactionDelegate.getDelegate().completeClientTransaction();
                            }
                            end = TimeUtil.currentTimeMillis();
                            time = end - borrowed;
                            buffer = new StringBuffer();
                            buffer.append("[").append(borrowed - start).append(",").append(time).append("]ms (client-sync) traceID=").append(UUID.toString((byte[])traceID)).append(", api=").append(serviceRequestPacket.apiName);
                            if (remoteAddress != null) {
                                buffer.append(", remote=").append(remoteAddress);
                            } else {
                                buffer.append(", pool=").append(this.bioConnPool.toString());
                            }
                            buffer.append(", clientID=").append(PacketConstant.VENUS_CLIENT_ID).append(", requestID=").append(serviceRequestPacket.clientRequestId);
                            if (packet != null) {
                                if (packet instanceof ErrorPacket) {
                                    buffer.append(", errorCode=").append(packet.errorCode);
                                    buffer.append(", message=").append(packet.message);
                                } else {
                                    buffer.append(", errorCode=0");
                                }
                            }
                            if (pLevel == null) break block144;
                            if (pLevel.printParams()) {
                                buffer.append(", params=");
                                buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                            }
                            if (time <= (long)pLevel.error() || pLevel.error() <= 0) break block145;
                            if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                                RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                            }
                            break block146;
                        }
                        if (time <= (long)pLevel.warn() || pLevel.warn() <= 0) break block147;
                        if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                            RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                        }
                        break block146;
                    }
                    if (time > (long)pLevel.info() && pLevel.info() > 0) {
                        if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                            RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                        }
                        break block146;
                    } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                        RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                    }
                    break block146;
                }
                buffer.append(", params=");
                buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                if (time >= 30000L) {
                    if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                        RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                    }
                } else if (time >= 10000L) {
                    if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                        RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                    }
                } else if (time >= 5000L) {
                    if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                        RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                    }
                } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                    RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                }
            }
            if (conn == null) return null;
            if (invalided != false) return null;
            if (!conn.isClosed() && soTimeout > 0) {
                conn.setSoTimeout(oldTimeout);
            }
            this.bioConnPool.returnObject((Object)conn);
            return null;
            do {
                clazz = var33_49[var31_53];
                if (e.getClass().isAssignableFrom(clazz)) {
                    throw e;
                }
                ++var31_53;
lbl373:
                // 2 sources

            } while (var31_53 < var32_50);
            throw new RemoteSocketIOException("api=" + serviceRequestPacket.apiName + ", remoteIp=" + conn.getRemoteAddress() + ",(" + e.getMessage() + ")", (Throwable)e);
        }
        catch (Exception e) {
            try {
                success = false;
                if (e instanceof CodedException || (errorCode = this.venusExceptionFactory.getErrorCode(e.getClass())) != 0 || e instanceof RuntimeException) {
                    if (e instanceof CodedException == false) throw e;
                    errorCode = ((CodedException)e).getErrorCode();
                    throw e;
                }
                code = e.getClass().getAnnotation(RemoteException.class);
                if (code != null) {
                    errorCode = code.errorCode();
                    throw e;
                }
                eCode = e.getClass().getAnnotation(ExceptionCode.class);
                if (eCode != null) {
                    errorCode = eCode.errorCode();
                    throw e;
                }
                errorCode = -1;
                if (conn != null) throw new DefaultVenusException(String.valueOf(e.getMessage()) + ". remoteAddress=" + conn.getRemoteAddress(), (Throwable)e);
                throw new DefaultVenusException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable var34_71) {
                block150: {
                    block148: {
                        block151: {
                            block149: {
                                if (service.athenaFlag()) {
                                    AthenaTransactionDelegate.getDelegate().completeClientTransaction();
                                }
                                end = TimeUtil.currentTimeMillis();
                                time = end - borrowed;
                                buffer = new StringBuffer();
                                buffer.append("[").append(borrowed - start).append(",").append(time).append("]ms (client-sync) traceID=").append(UUID.toString((byte[])traceID)).append(", api=").append(serviceRequestPacket.apiName);
                                if (remoteAddress != null) {
                                    buffer.append(", remote=").append(remoteAddress);
                                } else {
                                    buffer.append(", pool=").append(this.bioConnPool.toString());
                                }
                                buffer.append(", clientID=").append(PacketConstant.VENUS_CLIENT_ID).append(", requestID=").append(serviceRequestPacket.clientRequestId);
                                if (packet != null) {
                                    if (packet instanceof ErrorPacket) {
                                        buffer.append(", errorCode=").append(((ErrorPacket)packet).errorCode);
                                        buffer.append(", message=").append(packet.message);
                                    } else {
                                        buffer.append(", errorCode=0");
                                    }
                                }
                                if (pLevel == null) break block148;
                                if (pLevel.printParams()) {
                                    buffer.append(", params=");
                                    buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                                }
                                if (time <= (long)pLevel.error() || pLevel.error() <= 0) break block149;
                                if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                                    RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                                }
                                break block150;
                            }
                            if (time <= (long)pLevel.warn() || pLevel.warn() <= 0) break block151;
                            if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                                RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                            }
                            break block150;
                        }
                        if (time > (long)pLevel.info() && pLevel.info() > 0) {
                            if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                                RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                            }
                            break block150;
                        } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                            RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                        }
                        break block150;
                    }
                    buffer.append(", params=");
                    buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap, (SerializerFeature[])RemotingInvocationHandler.JSON_FEATURE));
                    if (time >= 30000L) {
                        if (RemotingInvocationHandler.performanceLogger.isErrorEnabled()) {
                            RemotingInvocationHandler.performanceLogger.error(buffer.toString());
                        }
                    } else if (time >= 10000L) {
                        if (RemotingInvocationHandler.performanceLogger.isWarnEnabled()) {
                            RemotingInvocationHandler.performanceLogger.warn(buffer.toString());
                        }
                    } else if (time >= 5000L) {
                        if (RemotingInvocationHandler.performanceLogger.isInfoEnabled()) {
                            RemotingInvocationHandler.performanceLogger.info(buffer.toString());
                        }
                    } else if (RemotingInvocationHandler.performanceLogger.isDebugEnabled()) {
                        RemotingInvocationHandler.performanceLogger.debug(buffer.toString());
                    }
                }
                if (conn == null) throw var34_71;
                if (invalided != false) throw var34_71;
                if (!conn.isClosed() && soTimeout > 0) {
                    conn.setSoTimeout(oldTimeout);
                }
                this.bioConnPool.returnObject((Object)conn);
                throw var34_71;
            }
        }
    }

    private void setTransactionId(SerializeServiceRequestPacket serviceRequestPacket, AthenaTransactionId athenaTransactionId) {
        if (athenaTransactionId != null) {
            if (athenaTransactionId.getRootId() != null) {
                serviceRequestPacket.rootId = athenaTransactionId.getRootId().getBytes();
            }
            if (athenaTransactionId.getParentId() != null) {
                serviceRequestPacket.parentId = athenaTransactionId.getParentId().getBytes();
            }
            if (athenaTransactionId.getMessageId() != null) {
                serviceRequestPacket.messageId = athenaTransactionId.getMessageId().getBytes();
            }
        }
    }

    public void init() throws InitialisationException {
    }
}

