/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.venus.client.InvocationListenerContainer;
import com.meidusa.venus.client.net.VenusNIOConnection;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PongPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.util.Utils;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class VenusNIOMessageHandler
implements MessageHandler<VenusNIOConnection> {
    private static Logger logger = Logger.getLogger(VenusNIOMessageHandler.class);
    private InvocationListenerContainer container;
    private VenusExceptionFactory venusExceptionFactory;

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public InvocationListenerContainer getContainer() {
        return this.container;
    }

    public void setContainer(InvocationListenerContainer container) {
        this.container = container;
    }

    public void handleMessage(VenusNIOConnection conn, byte[] message) {
        int type = AbstractServicePacket.getType((byte[])message);
        switch (type) {
            case -1: {
                ErrorPacket error = new ErrorPacket();
                error.init(message);
                Exception e = this.venusExceptionFactory.getException(error.errorCode, error.message);
                if (e == null) {
                    logger.error((Object)("receive error packet,errorCode=" + error.errorCode + ",message=" + error.message), (Throwable)e);
                    break;
                }
                if (error.additionalData != null) {
                    Serializer serializer = SerializerFactory.getSerializer((short)conn.getSerializeType());
                    Map obj = serializer.decode(error.additionalData, Utils.getBeanFieldType(e.getClass(), Exception.class));
                    try {
                        BeanUtils.copyProperties((Object)e, (Object)obj);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"copy properties error", (Throwable)e1);
                    }
                }
                logger.error((Object)"receive error packet", (Throwable)e);
                break;
            }
            case 1: {
                OKPacket ok = new OKPacket();
                ok.init(message);
                break;
            }
            case 0x2000002: {
                break;
            }
            case 0x4000001: {
                SerializeServiceNofityPacket packet = null;
                ServicePacketBuffer buffer = new ServicePacketBuffer(message);
                buffer.setPosition(28);
                String listenerClass = buffer.readLengthCodedString("utf-8");
                int identityHashCode = buffer.readInt();
                Tuple<InvocationListener, Type> tuple = this.container.getInvocationListener(listenerClass, identityHashCode);
                Serializer serializer = SerializerFactory.getSerializer((short)conn.getSerializeType());
                packet = new SerializeServiceNofityPacket(serializer, (Type)tuple.right);
                packet.init(message);
                if (packet.errorCode != 0) {
                    Exception exception = this.venusExceptionFactory.getException(packet.errorCode, packet.errorMessage);
                    if (exception == null) {
                        exception = new DefaultVenusException(packet.errorCode, packet.errorMessage);
                    } else if (packet.additionalData != null) {
                        Map obj = serializer.decode(packet.additionalData, Utils.getBeanFieldType(exception.getClass(), Exception.class));
                        try {
                            BeanUtils.copyProperties((Object)exception, (Object)obj);
                        }
                        catch (Exception e1) {
                            logger.error((Object)"copy properties error", (Throwable)e1);
                        }
                    }
                    ((InvocationListener)tuple.left).onException(exception);
                    break;
                }
                ((InvocationListener)tuple.left).callback(packet.callbackObject);
                break;
            }
            case 0x1000002: {
                break;
            }
            case 0x1000001: {
                PongPacket pong = new PongPacket();
                conn.postMessage(pong.toByteBuffer());
            }
        }
    }
}

