/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client;

import com.meidusa.fastjson.JSON;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.BIOConnection;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.PerformanceLevel;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.client.InvocationListenerContainer;
import com.meidusa.venus.client.VenusConstant;
import com.meidusa.venus.client.VenusInvocationHandler;
import com.meidusa.venus.client.VenusServiceFactory;
import com.meidusa.venus.client.xml.bean.EndpointConfig;
import com.meidusa.venus.client.xml.bean.ServiceConfig;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.InvalidParameterException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.metainfo.EndpointParameter;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.poolable.RequestLoadbalanceObjectPool;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusAnnotationUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RemotingInvocationHandler
extends VenusInvocationHandler {
    private static Logger logger = Logger.getLogger(RemotingInvocationHandler.class);
    private static Logger performanceLogger = Logger.getLogger((String)"venus.service.performance");
    private InvocationListenerContainer container;
    private ObjectPool bioConnPool;
    private ObjectPool nioConnPool;
    private static AtomicLong sequenceId = new AtomicLong(1L);
    private VenusServiceFactory serviceFactory;
    private VenusExceptionFactory venusExceptionFactory;
    private boolean enableAsync = true;
    private byte serializeType = 0;

    public boolean isEnableAsync() {
        return this.enableAsync;
    }

    public void setEnableAsync(boolean enableAsync) {
        this.enableAsync = enableAsync;
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public void setServiceFactory(VenusServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public short getSerializeType() {
        return this.serializeType;
    }

    public void setSerializeType(byte serializeType) {
        this.serializeType = serializeType;
    }

    public InvocationListenerContainer getContainer() {
        return this.container;
    }

    public void setContainer(InvocationListenerContainer container) {
        this.container = container;
    }

    public ObjectPool getBioConnPool() {
        return this.bioConnPool;
    }

    public void setBioConnPool(ObjectPool bioConnPool) {
        this.bioConnPool = bioConnPool;
    }

    public ObjectPool getNioConnPool() {
        return this.nioConnPool;
    }

    public void setNioConnPool(ObjectPool nioConnPool) {
        this.nioConnPool = nioConnPool;
    }

    @Override
    protected Object invokeRemoteService(Service service, Endpoint endpoint, Method method, EndpointParameter[] params, Object[] args) throws Exception {
        long start;
        boolean async = false;
        if (endpoint.async()) {
            async = true;
        }
        SerializeServiceRequestPacket serviceRequestPacket = null;
        Serializer serializer = SerializerFactory.getSerializer((short)this.serializeType);
        serviceRequestPacket = new SerializeServiceRequestPacket(serializer, null);
        serviceRequestPacket.clientId = VenusConstant.VENUS_CLIENT_ID;
        serviceRequestPacket.clientRequestId = sequenceId.getAndIncrement();
        serviceRequestPacket.apiName = VenusAnnotationUtils.getApiname((Method)method, (Service)service, (Endpoint)endpoint);
        serviceRequestPacket.serviceVersion = service.version();
        serviceRequestPacket.parameterMap = new HashMap();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (args[i] instanceof InvocationListener) {
                    async = true;
                    ReferenceInvocationListener listener = new ReferenceInvocationListener();
                    ServicePacketBuffer buffer = new ServicePacketBuffer(16);
                    buffer.writeLengthCodedString(args[i].getClass().getName(), "utf-8");
                    buffer.writeInt(System.identityHashCode(args[i]));
                    listener.setIdentityData(buffer.toByteBuffer().array());
                    Type type = method.getGenericParameterTypes()[i];
                    if (!(type instanceof ParameterizedType)) {
                        throw new InvalidParameterException("invocationListener is not generic");
                    }
                    ParameterizedType genericType = (ParameterizedType)type;
                    this.container.putInvocationListener((InvocationListener)args[i], genericType.getActualTypeArguments()[0]);
                    serviceRequestPacket.parameterMap.put(params[i].getParamName(), listener);
                } else {
                    serviceRequestPacket.parameterMap.put(params[i].getParamName(), args[i]);
                }
                ++i;
            }
        }
        PerformanceLevel pLevel = (PerformanceLevel)AnnotationUtil.getAnnotation((Annotation[])method.getAnnotations(), PerformanceLevel.class);
        long borrowed = start = System.currentTimeMillis();
        if (async) {
            if (!this.isEnableAsync()) {
                throw new VenusConfigException("service async call disabled");
            }
            Connection conn = null;
            try {
                conn = this.nioConnPool instanceof RequestLoadbalanceObjectPool ? (Connection)((RequestLoadbalanceObjectPool)this.nioConnPool).borrowObject(serviceRequestPacket.parameterMap, endpoint) : (Connection)this.nioConnPool.borrowObject();
                borrowed = System.currentTimeMillis();
                conn.postMessage(serviceRequestPacket.toByteBuffer());
                return null;
            }
            finally {
                if (performanceLogger.isEnabledFor((Priority)Level.DEBUG)) {
                    long end = System.currentTimeMillis();
                    long time = end - borrowed;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("[").append(borrowed - start).append(",").append(time).append("]ms api=").append(serviceRequestPacket.apiName);
                    performanceLogger.log((Priority)Level.DEBUG, (Object)buffer.toString());
                }
                if (conn != null) {
                    this.nioConnPool.returnObject((Object)conn);
                }
            }
        }
        BIOConnection conn = null;
        int soTimeout = 0;
        int oldTimeout = 0;
        boolean success = true;
        try {
            conn = this.bioConnPool instanceof RequestLoadbalanceObjectPool ? (BIOConnection)((RequestLoadbalanceObjectPool)this.bioConnPool).borrowObject(serviceRequestPacket.parameterMap, endpoint) : (BIOConnection)this.bioConnPool.borrowObject();
            borrowed = System.currentTimeMillis();
            ServiceConfig config = this.serviceFactory.getServiceConfig(method.getDeclaringClass());
            oldTimeout = conn.getSoTimeout();
            if (config != null) {
                EndpointConfig endpointConfig = config.getEndpointConfig(endpoint.name());
                if (endpointConfig != null) {
                    int eTimeOut = endpointConfig.getSoTimeout();
                    if (eTimeOut > 0) {
                        soTimeout = eTimeOut;
                    }
                } else {
                    soTimeout = config.getSoTimeout();
                }
                if (soTimeout > 0) {
                    conn.setSoTimeout(soTimeout);
                }
            }
            byte[] bts = null;
            try {
                conn.write(serviceRequestPacket.toByteBuffer().array());
                bts = conn.read();
            }
            catch (IOException e) {
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                success = false;
                if (e instanceof CodedException) {
                    throw e;
                }
                throw new DefaultVenusException(String.valueOf(e.getMessage()) + ". remoteAddress=" + conn.getRemoteAddress(), (Throwable)e);
            }
            int type = AbstractServicePacket.getType((byte[])bts);
            switch (type) {
                case -1: {
                    Map tmap;
                    ErrorPacket error = new ErrorPacket();
                    error.init(bts);
                    Exception e = this.venusExceptionFactory.getException(error.errorCode, error.message);
                    if (e == null) {
                        throw new DefaultVenusException(error.errorCode, error.message);
                    }
                    if (error.additionalData != null && (tmap = Utils.getBeanFieldType(e.getClass(), Exception.class)) != null && tmap.size() > 0) {
                        Map obj = serializer.decode(error.additionalData, tmap);
                        BeanUtils.copyProperties((Object)e, (Object)obj);
                    }
                    throw e;
                }
                case 1: {
                    OKPacket ok = new OKPacket();
                    ok.init(bts);
                    return null;
                }
                case 0x2000002: {
                    SerializeServiceResponsePacket response = null;
                    response = new SerializeServiceResponsePacket(serializer, method.getGenericReturnType());
                    response.init(bts);
                    Object object = response.result;
                    return object;
                }
            }
            logger.warn((Object)("unknow response type=" + type));
            success = false;
            return null;
        }
        catch (Exception e) {
            success = false;
            if (e instanceof CodedException || e instanceof RuntimeException || this.venusExceptionFactory.getErrorCode(e.getClass()) != 0) {
                throw e;
            }
            if (conn == null) {
                throw new DefaultVenusException(e.getMessage(), (Throwable)e);
            }
            throw new DefaultVenusException(String.valueOf(e.getMessage()) + ". remoteAddress=" + conn.getRemoteAddress(), (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            long time = end - borrowed;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(borrowed - start).append(",").append(time).append("]ms api=").append(serviceRequestPacket.apiName).append(", success=").append(success);
            if (conn != null) {
                buffer.append(", remote=").append(conn.getRemoteAddress());
            }
            buffer.append(", clientID=").append(VenusConstant.VENUS_CLIENT_ID).append(", requestID=").append(serviceRequestPacket.clientRequestId);
            if (pLevel != null) {
                if (pLevel.printParams()) {
                    buffer.append(", params=\n");
                    buffer.append(JSON.toJSONString((Object)serviceRequestPacket.parameterMap));
                }
                if (time > (long)pLevel.error() && pLevel.error() > 0) {
                    if (performanceLogger.isEnabledFor((Priority)Level.ERROR)) {
                        performanceLogger.log((Priority)Level.ERROR, (Object)buffer.toString());
                    }
                } else if (time > (long)pLevel.warn() && pLevel.warn() > 0) {
                    if (performanceLogger.isEnabledFor((Priority)Level.WARN)) {
                        performanceLogger.log((Priority)Level.WARN, (Object)buffer.toString());
                    }
                } else if (time > (long)pLevel.info() && pLevel.info() > 0) {
                    if (performanceLogger.isEnabledFor((Priority)Level.INFO)) {
                        performanceLogger.log((Priority)Level.INFO, (Object)buffer.toString());
                    }
                } else if (performanceLogger.isEnabledFor((Priority)Level.DEBUG)) {
                    performanceLogger.log((Priority)Level.DEBUG, (Object)buffer.toString());
                }
            } else if (time >= 30000L) {
                if (performanceLogger.isEnabledFor((Priority)Level.ERROR)) {
                    performanceLogger.error((Object)buffer.toString());
                }
            } else if (time >= 10000L) {
                if (performanceLogger.isEnabledFor((Priority)Level.WARN)) {
                    performanceLogger.warn((Object)buffer.toString());
                }
            } else if (time >= 5000L) {
                if (performanceLogger.isInfoEnabled()) {
                    performanceLogger.info((Object)buffer.toString());
                }
            } else if (performanceLogger.isDebugEnabled()) {
                performanceLogger.debug((Object)buffer.toString());
            }
            if (conn != null) {
                if (!conn.isClosed() && soTimeout > 0) {
                    conn.setSoTimeout(oldTimeout);
                }
                this.bioConnPool.returnObject((Object)conn);
            }
        }
    }

    public void init() throws InitialisationException {
    }
}

