/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.services;

import com.meidusa.toolkit.util.StringUtil;
import com.meidusa.venus.annotations.Param;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Parameter;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.exception.ConvertException;
import com.meidusa.venus.exception.EndPointNotFoundException;
import com.meidusa.venus.exception.ServiceDefinitionException;
import com.meidusa.venus.exception.ServiceNotFoundException;
import com.meidusa.venus.exception.SystemParameterRequiredException;
import com.meidusa.venus.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.TypeHandler;
import org.apache.commons.lang.ArrayUtils;

public abstract class AbstractServiceManager
implements ServiceManager {
    private boolean supportOverload = false;
    protected final Map<String, Service> services = new HashMap<String, Service>();

    @Override
    public Collection<Service> getServices() {
        return this.services.values();
    }

    @Override
    public Service getService(String serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new ServiceNotFoundException("Cannot find service with null");
        }
        if (!this.services.containsKey(serviceName)) {
            throw new ServiceNotFoundException("No service named " + serviceName);
        }
        return this.services.get(serviceName);
    }

    @Override
    public Endpoint getEndpoint(String apiName) throws ServiceNotFoundException, EndPointNotFoundException, SystemParameterRequiredException {
        if (StringUtil.isEmpty((String)apiName)) {
            throw new EndPointNotFoundException("No method named " + apiName);
        }
        int index = apiName.lastIndexOf(".");
        if (index > 0) {
            String serviceName = apiName.substring(0, index);
            String endpointName = apiName.substring(index + 1);
            Service service = this.services.get(serviceName);
            if (service == null) {
                throw new ServiceNotFoundException("No service named " + serviceName);
            }
            Collection eps = service.getEndpoints().get((Object)endpointName);
            if (eps == null || eps.isEmpty()) {
                throw new EndPointNotFoundException("No method named " + endpointName);
            }
            return (Endpoint)eps.iterator().next();
        }
        throw new EndPointNotFoundException("No method named " + apiName);
    }

    @Override
    public Endpoint getEndpoint(String serviceName, String endpointName, String[] paramNames) throws ServiceNotFoundException, EndPointNotFoundException, SystemParameterRequiredException {
        Service service = this.services.get(serviceName);
        if (service == null) {
            throw new ServiceNotFoundException("No service named " + serviceName);
        }
        Collection eps = service.getEndpoints().get((Object)endpointName);
        if (eps == null || eps.isEmpty()) {
            throw new EndPointNotFoundException("No method named " + endpointName);
        }
        if (this.supportOverload) {
            Endpoint ep = this.findExactEndpoint(eps, paramNames);
            if (ep == null) {
                throw new EndPointNotFoundException("method not found, service=" + serviceName + "." + endpointName + " annotated with params: " + ArrayUtils.toString((Object)paramNames));
            }
            return ep;
        }
        return (Endpoint)eps.iterator().next();
    }

    private Endpoint findExactEndpoint(Collection<Endpoint> endpoints, String[] paramNames) {
        if (endpoints.size() == 1) {
            Endpoint ep = endpoints.iterator().next();
            String[] requiredParameterNames = ep.getRequiredParameterNames();
            if (Utils.arrayContains((String[])requiredParameterNames, (String[])paramNames)) {
                return ep;
            }
            return null;
        }
        for (Endpoint ep : endpoints) {
            String[] epParameterNames;
            if (!ArrayUtils.isSameLength((Object[])ep.getParameters(), (Object[])paramNames) || !Utils.arrayEquals((String[])paramNames, (String[])(epParameterNames = ep.getParameterNames()))) continue;
            return ep;
        }
        return null;
    }

    public boolean isSupportOverload() {
        return this.supportOverload;
    }

    public void setSupportOverload(boolean supportOverload) {
        this.supportOverload = supportOverload;
    }

    protected Endpoint loadEndpoint(Method method) throws ServiceDefinitionException, ConvertException {
        Endpoint ep = new Endpoint();
        ep.setMethod(method);
        com.meidusa.venus.annotations.Endpoint endpointAnnotation = method.getAnnotation(com.meidusa.venus.annotations.Endpoint.class);
        if (!endpointAnnotation.name().isEmpty()) {
            ep.setName(endpointAnnotation.name());
        } else {
            ep.setName(method.getName());
        }
        ep.setTimeWait(endpointAnnotation.timeWait());
        ep.setVoid(method.getReturnType().equals(Void.TYPE));
        Type[] paramTypes = method.getGenericParameterTypes();
        if (paramTypes.length > 0 && paramTypes[paramTypes.length - 1] == RequestContext.class) {
            ep.setHasCtxParam(true);
        }
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        ArrayList<Parameter> params = new ArrayList<Parameter>(paramTypes.length);
        int i = 0;
        while (i < paramTypes.length) {
            Parameter param = this.loadParameter(method, paramTypes[i], paramAnnotations[i]);
            if (param != null) {
                params.add(param);
            }
            ++i;
        }
        ep.setParameters(params.toArray(new Parameter[0]));
        return ep;
    }

    protected Parameter loadParameter(Method method, Type paramType, Annotation[] annotations) throws ServiceDefinitionException, ConvertException {
        Parameter p = new Parameter();
        p.setType(paramType);
        Param paramAnnotation = (Param)AnnotationUtil.getAnnotation((Annotation[])annotations, Param.class);
        if (paramAnnotation == null) {
            throw new ServiceDefinitionException("service=" + method.getDeclaringClass().getName() + ",method=" + method.getName() + " ,one more param annotaions is absent");
        }
        p.setParamName(paramAnnotation.name());
        p.setOptional(paramAnnotation.optional());
        if (!paramAnnotation.defaultValue().isEmpty()) {
            try {
                p.setDefaultValue(TypeHandler.createValue((String)paramAnnotation.defaultValue(), (Object)paramType));
            }
            catch (ParseException e) {
                throw new ConvertException("parseError", (Throwable)e);
            }
        }
        return p;
    }
}

