/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.util.InetAddressUtil;
import com.meidusa.toolkit.util.TimeUtil;
import com.meidusa.venus.backend.DefaultEndpointInvocation;
import com.meidusa.venus.backend.EndpointInvocation;
import com.meidusa.venus.backend.Response;
import com.meidusa.venus.backend.VenusStatus;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.network.handler.CodeMapScanner;
import com.meidusa.venus.backend.network.handler.LogHandler;
import com.meidusa.venus.backend.network.handler.PerformanceHandler;
import com.meidusa.venus.backend.network.handler.RemotingInvocationListener;
import com.meidusa.venus.backend.network.handler.ResponseHandler;
import com.meidusa.venus.backend.profiling.UtilTimerStack;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.ServiceInvokeException;
import com.meidusa.venus.exception.ServiceNotCallbackException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.VenusExceptionLevel;
import com.meidusa.venus.extension.athena.AthenaTransactionId;
import com.meidusa.venus.extension.athena.delegate.AthenaReporterDelegate;
import com.meidusa.venus.extension.athena.delegate.AthenaTransactionDelegate;
import com.meidusa.venus.io.ServiceFilter;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.service.monitor.MonitorRuntime;
import com.meidusa.venus.util.ThreadLocalMap;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.concurrent.MultiQueueRunnable;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRunnable
extends MultiQueueRunnable {
    private static Logger logger = LoggerFactory.getLogger(ServiceRunnable.class);
    private static Logger INVOKER_LOGGER = LoggerFactory.getLogger((String)"venus.service.invoker");
    private static String ENDPOINT_INVOKED_TIME = "invoked Total Time: ";
    private Endpoint endpoint;
    private VenusFrontendConnection conn;
    private RequestContext context;
    private EndpointInvocation.ResultType resultType;
    private ServiceFilter filter;
    private byte[] traceID;
    private SerializeServiceRequestPacket request;
    private short serializeType;
    private VenusRouterPacket routerPacket;
    private RemotingInvocationListener<Serializable> invocationListener;
    private VenusExceptionFactory venusExceptionFactory;
    private Tuple<Long, byte[]> data;
    private String apiName;
    private String sourceIp;

    public ServiceRunnable(VenusFrontendConnection conn, Endpoint endpoint, RequestContext context, EndpointInvocation.ResultType resultType, ServiceFilter filter, VenusRouterPacket routerPacket, SerializeServiceRequestPacket request, short serializeType, RemotingInvocationListener<Serializable> invocationListener, VenusExceptionFactory venusExceptionFactory, Tuple<Long, byte[]> data) {
        this.conn = conn;
        this.endpoint = endpoint;
        this.context = context;
        this.resultType = resultType;
        this.filter = filter;
        this.request = request;
        this.traceID = request.traceId;
        this.serializeType = serializeType;
        this.routerPacket = routerPacket;
        this.invocationListener = invocationListener;
        this.venusExceptionFactory = venusExceptionFactory;
        this.data = data;
        this.apiName = request.apiName;
        this.sourceIp = routerPacket != null ? InetAddressUtil.intToAddress((int)routerPacket.srcIP) : conn.getHost();
    }

    public void doRun() {
        boolean athenaFlag = this.endpoint.getService().getAthenaFlag();
        if (athenaFlag) {
            AthenaReporterDelegate.getDelegate().metric(String.valueOf(this.apiName) + ".invoke");
            AthenaTransactionId transactionId = new AthenaTransactionId();
            transactionId.setRootId(this.context.getRootId());
            transactionId.setParentId(this.context.getParentId());
            transactionId.setMessageId(this.context.getMessageId());
            AthenaTransactionDelegate.getDelegate().startServerTransaction(transactionId, this.apiName);
            AthenaTransactionDelegate.getDelegate().setServerInputSize((long)((byte[])this.data.right).length);
        }
        ErrorPacket resultPacket = null;
        ResponseHandler responseHandler = new ResponseHandler();
        long startRunTime = TimeUtil.currentTimeMillis();
        Response result = null;
        try {
            if (this.conn.isClosed() && this.resultType == EndpointInvocation.ResultType.RESPONSE) {
                return;
            }
            try {
                ThreadLocalMap.put((Object)"REQUEST_TRACE_ID", (Object)this.traceID);
                ThreadLocalMap.put((Object)"_REQUEST_CONTEXT_", (Object)this.context);
                if (this.filter != null) {
                    this.filter.before((AbstractServicePacket)this.request);
                }
                if ((result = this.handleRequest(this.context, this.endpoint)).getErrorCode() == 0) {
                    if (this.resultType == EndpointInvocation.ResultType.RESPONSE) {
                        Serializer serializer = SerializerFactory.getSerializer((short)this.serializeType);
                        SerializeServiceResponsePacket response = new SerializeServiceResponsePacket(serializer, this.endpoint.getMethod().getGenericReturnType());
                        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)response);
                        response.result = result.getResult();
                        resultPacket = response;
                        responseHandler.postMessageBack((Connection)this.conn, this.routerPacket, (AbstractServicePacket)this.request, (AbstractServicePacket)response, athenaFlag);
                    } else if (this.resultType == EndpointInvocation.ResultType.OK) {
                        OKPacket ok = new OKPacket();
                        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)ok);
                        resultPacket = ok;
                        responseHandler.postMessageBack((Connection)this.conn, this.routerPacket, (AbstractServicePacket)this.request, (AbstractServicePacket)ok, athenaFlag);
                    } else if (this.resultType == EndpointInvocation.ResultType.NOTIFY && this.invocationListener != null && !this.invocationListener.isResponsed()) {
                        this.invocationListener.onException((Exception)new ServiceNotCallbackException("Server side not call back error"));
                    }
                } else if (this.resultType == EndpointInvocation.ResultType.RESPONSE || this.resultType == EndpointInvocation.ResultType.OK) {
                    ErrorPacket error = new ErrorPacket();
                    AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)error);
                    error.errorCode = result.getErrorCode();
                    error.message = result.getErrorMessage();
                    Exception throwable = result.getException();
                    if (throwable != null) {
                        Serializer serializer = SerializerFactory.getSerializer((short)this.serializeType);
                        Map mpd = Utils.getBeanPropertyDescriptor(throwable.getClass());
                        HashMap<String, Object> additionalData = new HashMap<String, Object>();
                        for (Map.Entry entry : mpd.entrySet()) {
                            additionalData.put((String)entry.getKey(), ((PropertyDescriptor)entry.getValue()).getReadMethod().invoke((Object)throwable, new Object[0]));
                        }
                        error.additionalData = serializer.encode(additionalData);
                    }
                    resultPacket = error;
                    responseHandler.postMessageBack((Connection)this.conn, this.routerPacket, (AbstractServicePacket)this.request, (AbstractServicePacket)error, athenaFlag);
                } else if (this.resultType == EndpointInvocation.ResultType.NOTIFY && this.invocationListener != null && !this.invocationListener.isResponsed()) {
                    if (result.getException() == null) {
                        this.invocationListener.onException((Exception)new DefaultVenusException(result.getErrorCode(), result.getErrorMessage()));
                    } else {
                        this.invocationListener.onException(result.getException());
                    }
                }
                if (athenaFlag) {
                    AthenaReporterDelegate.getDelegate().metric(String.valueOf(this.apiName) + ".complete");
                }
            }
            catch (Exception e) {
                ErrorPacket error;
                block40: {
                    if (athenaFlag) {
                        AthenaReporterDelegate.getDelegate().metric(String.valueOf(this.apiName) + ".error");
                    }
                    error = new ErrorPacket();
                    AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)error);
                    Integer code = CodeMapScanner.getCodeMap().get(e.getClass());
                    if (code != null) {
                        error.errorCode = code;
                    } else if (e instanceof CodedException) {
                        CodedException codeEx = (CodedException)e;
                        error.errorCode = codeEx.getErrorCode();
                        if (logger.isDebugEnabled()) {
                            logger.debug("error when invoke", (Throwable)e);
                        }
                    } else {
                        try {
                            int i;
                            Method method = e.getClass().getMethod("getErrorCode", new Class[0]);
                            error.errorCode = i = ((Integer)method.invoke((Object)e, new Object[0])).intValue();
                            if (logger.isDebugEnabled()) {
                                logger.debug("error when invoke", (Throwable)e);
                            }
                        }
                        catch (Exception e1) {
                            error.errorCode = 18005000;
                            if (!logger.isWarnEnabled()) break block40;
                            logger.warn("error when invoke", (Throwable)e);
                        }
                    }
                }
                resultPacket = error;
                error.message = e.getMessage();
                responseHandler.postMessageBack((Connection)this.conn, this.routerPacket, (AbstractServicePacket)this.request, (AbstractServicePacket)error, athenaFlag);
                return;
            }
            catch (OutOfMemoryError e) {
                ErrorPacket error = new ErrorPacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)error);
                error.errorCode = 18005002;
                error.message = e.getMessage();
                resultPacket = error;
                responseHandler.postMessageBack((Connection)this.conn, this.routerPacket, (AbstractServicePacket)this.request, (AbstractServicePacket)error, athenaFlag);
                VenusStatus.getInstance().setStatus((byte)4);
                logger.error("error when invoke", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                ErrorPacket error = new ErrorPacket();
                AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)error);
                error.errorCode = 18005002;
                error.message = e.getMessage();
                resultPacket = error;
                responseHandler.postMessageBack((Connection)this.conn, this.routerPacket, (AbstractServicePacket)this.request, (AbstractServicePacket)error, athenaFlag);
                logger.error("error when invoke", (Throwable)e);
                return;
            }
        }
        finally {
            if (athenaFlag) {
                AthenaTransactionDelegate.getDelegate().completeServerTransaction();
            }
            long endRunTime = TimeUtil.currentTimeMillis();
            long queuedTime = startRunTime - (Long)this.data.left;
            long executeTime = endRunTime - startRunTime;
            if ((long)this.endpoint.getTimeWait() < queuedTime + executeTime && athenaFlag) {
                AthenaReporterDelegate.getDelegate().metric(String.valueOf(this.apiName) + ".timeout");
            }
            MonitorRuntime.getInstance().calculateAverage(this.endpoint.getService().getName(), this.endpoint.getName(), executeTime, false);
            PerformanceHandler.logPerformance(this.endpoint, this.request, queuedTime, executeTime, this.conn.getHost(), this.sourceIp, result);
            if (this.filter != null) {
                this.filter.after((AbstractServicePacket)resultPacket);
            }
            ThreadLocalMap.remove((Object)"_REQUEST_CONTEXT_");
            ThreadLocalMap.remove((Object)"REQUEST_TRACE_ID");
        }
    }

    public String getName() {
        return this.apiName;
    }

    private Response handleRequest(RequestContext context, Endpoint endpoint) {
        Response response = new Response();
        DefaultEndpointInvocation invocation = new DefaultEndpointInvocation(context, endpoint);
        try {
            try {
                UtilTimerStack.push(ENDPOINT_INVOKED_TIME);
                response.setResult(invocation.invoke());
            }
            catch (Throwable e) {
                AthenaReporterDelegate.getDelegate().problem(e.getMessage(), e);
                if (e instanceof ServiceInvokeException) {
                    e = ((ServiceInvokeException)e).getTargetException();
                }
                if (e instanceof Exception) {
                    response.setException((Exception)e);
                } else {
                    response.setException((Exception)new DefaultVenusException(e.getMessage(), e));
                }
                Integer code = CodeMapScanner.getCodeMap().get(e.getClass());
                if (code != null) {
                    response.setErrorCode(code);
                    response.setErrorMessage(e.getMessage());
                } else {
                    response.setError(e, this.venusExceptionFactory);
                }
                Service service = endpoint.getService();
                if (e instanceof VenusExceptionLevel) {
                    if (((VenusExceptionLevel)e).getLevel() != null) {
                        LogHandler.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), INVOKER_LOGGER, String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                    }
                } else if (e instanceof RuntimeException && !(e instanceof CodedException)) {
                    INVOKER_LOGGER.error(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                } else if (endpoint.isAsync()) {
                    if (INVOKER_LOGGER.isErrorEnabled()) {
                        INVOKER_LOGGER.error(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                    }
                } else if (INVOKER_LOGGER.isDebugEnabled()) {
                    INVOKER_LOGGER.debug(String.valueOf(e.getMessage()) + " " + context.getRequestInfo().getRemoteIp() + " " + service.getName() + ":" + endpoint.getMethod().getName() + " " + Utils.toString(context.getParameters()), e);
                }
                UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
            }
        }
        finally {
            UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
        }
        return response;
    }
}

