/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.toolkit.net.util.InetAddressUtil;
import com.meidusa.venus.backend.RequestInfo;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;

public class RequestHandler {
    public RequestInfo getRequestInfo(byte packetSerializeType, VenusFrontendConnection conn, VenusRouterPacket routerPacket) {
        RequestInfo info = new RequestInfo();
        if (routerPacket != null) {
            info.setRemoteIp(InetAddressUtil.intToAddress((int)routerPacket.srcIP));
        } else {
            info.setRemoteIp(conn.getHost());
        }
        info.setProtocol(RequestInfo.Protocol.SOCKET);
        info.setClientId(conn.getClientId());
        if (packetSerializeType == 0) {
            info.setAccept("application/json");
        } else if (packetSerializeType != 1 && packetSerializeType == 2) {
            info.setAccept("application/xml");
        }
        return info;
    }

    public RequestContext createContext(RequestInfo info, Endpoint endpoint, SerializeServiceRequestPacket request) {
        RequestContext context = new RequestContext();
        context.setParameters(request.parameterMap);
        context.setEndPointer(endpoint);
        context.setRequestInfo(info);
        if (request.rootId != null && request.rootId.length > 0) {
            context.setRootId(new String(request.rootId));
        }
        if (request.parentId != null && request.parentId.length > 0) {
            context.setParentId(new String(request.parentId));
        }
        if (request.messageId != null && request.messageId.length > 0) {
            context.setMessageId(new String(request.messageId));
        }
        return context;
    }
}

