/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastmark.feature.SerializerFeature;
import com.meidusa.venus.backend.Response;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.xml.bean.PerformanceLogger;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.util.UUID;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceHandler {
    private static Logger performanceLogger = LoggerFactory.getLogger((String)"venus.backend.performance");
    private static SerializerFeature[] JSON_FEATURE = new SerializerFeature[]{SerializerFeature.ShortString, SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.SkipTransientField};

    public static void logPerformance(Endpoint endpoint, SerializeServiceRequestPacket request, long queuedTime, long executeTime, String remoteIp, String sourceIP, Object result) {
        String traceId = request == null ? UUID.toString((byte[])PacketConstant.EMPTY_TRACE_ID) : UUID.toString((byte[])request.traceId);
        String apiName = "";
        if (request != null) {
            apiName = request.apiName;
        }
        long clientId = -1L;
        if (request != null) {
            clientId = request.clientId;
        }
        long requestId = -1L;
        if (request != null) {
            requestId = request.clientRequestId;
        }
        HashMap parameterMap = null;
        parameterMap = request != null ? request.parameterMap : new HashMap();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(queuedTime).append(",").append(executeTime).append("]ms, (*server*) traceID=").append(traceId).append(", api=").append(apiName).append(", ip=").append(remoteIp).append(", sourceIP=").append(sourceIP).append(", clientID=").append(clientId).append(", requestID=").append(requestId);
        PerformanceLogger pLevel = null;
        if (endpoint != null) {
            pLevel = endpoint.getPerformanceLogger();
        }
        if (pLevel != null) {
            if (pLevel.isPrintParams()) {
                buffer.append(", params=");
                buffer.append(JSON.toJSONString(parameterMap, (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])JSON_FEATURE));
            }
            if (pLevel.isPrintResult()) {
                buffer.append(", result=");
                if (result instanceof ErrorPacket) {
                    buffer.append("{ errorCode=").append(((ErrorPacket)result).errorCode);
                    buffer.append(", message=").append(((ErrorPacket)result).message);
                    buffer.append("}");
                } else if (result instanceof Response) {
                    if (((Response)result).getErrorCode() > 0) {
                        buffer.append("{ errorCode=").append(((Response)result).getErrorCode());
                        buffer.append(", message=\"").append(((Response)result).getErrorMessage()).append("\"");
                        buffer.append(", className=\"").append(((Response)result).getException().getClass().getSimpleName()).append("\"");
                        buffer.append("}");
                    } else {
                        buffer.append(JSON.toJSONString((Object)result, (SerializerFeature[])JSON_FEATURE));
                    }
                }
            }
            if (queuedTime >= (long)pLevel.getError() || executeTime >= (long)pLevel.getError() || queuedTime + executeTime >= (long)pLevel.getError()) {
                if (performanceLogger.isErrorEnabled()) {
                    performanceLogger.error(buffer.toString());
                }
            } else if (queuedTime >= (long)pLevel.getWarn() || executeTime >= (long)pLevel.getWarn() || queuedTime + executeTime >= (long)pLevel.getWarn()) {
                if (performanceLogger.isWarnEnabled()) {
                    performanceLogger.warn(buffer.toString());
                }
            } else if (queuedTime >= (long)pLevel.getInfo() || executeTime >= (long)pLevel.getInfo() || queuedTime + executeTime >= (long)pLevel.getInfo()) {
                if (performanceLogger.isInfoEnabled()) {
                    performanceLogger.info(buffer.toString());
                }
            } else if (performanceLogger.isDebugEnabled()) {
                performanceLogger.debug(buffer.toString());
            }
        } else {
            if (performanceLogger.isDebugEnabled()) {
                buffer.append(", params=");
                buffer.append(JSON.toJSONString(parameterMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.ShortString}));
                if (result == null) {
                    buffer.append(", result=<null>");
                } else {
                    buffer.append(", result=");
                    if (result instanceof ErrorPacket) {
                        buffer.append("{ errorCode=").append(((ErrorPacket)result).errorCode);
                        buffer.append(", message=").append(((ErrorPacket)result).message);
                        buffer.append("}");
                    } else if (result instanceof Response) {
                        if (((Response)result).getErrorCode() > 0) {
                            buffer.append("{errorCode=").append(((Response)result).getErrorCode());
                            buffer.append(", message=\"").append(((Response)result).getErrorMessage()).append("\"");
                            buffer.append(", className=\"").append(((Response)result).getException().getClass().getSimpleName()).append("\"");
                            buffer.append("}");
                        } else {
                            buffer.append(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.ShortString}));
                        }
                    }
                }
            }
            if (queuedTime >= 30000L || executeTime >= 30000L || queuedTime + executeTime >= 30000L) {
                if (performanceLogger.isErrorEnabled()) {
                    performanceLogger.error(buffer.toString());
                }
            } else if (queuedTime >= 10000L || executeTime >= 10000L || queuedTime + executeTime >= 10000L) {
                if (performanceLogger.isWarnEnabled()) {
                    performanceLogger.warn(buffer.toString());
                }
            } else if (queuedTime >= 5000L || executeTime >= 5000L || queuedTime + executeTime >= 5000L) {
                if (performanceLogger.isInfoEnabled()) {
                    performanceLogger.info(buffer.toString());
                }
            } else if (performanceLogger.isDebugEnabled()) {
                performanceLogger.debug(buffer.toString());
            }
        }
    }
}

