/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.authenticate;

import com.meidusa.toolkit.net.authenticate.server.AuthenticateProvider;
import com.meidusa.venus.VenusMetaInfo;
import com.meidusa.venus.backend.authenticate.SimpleAuthenticateProvider;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.AuthenPacketFactory;
import com.meidusa.venus.io.packet.DummyAuthenPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PasswordAuthenPacket;
import com.meidusa.venus.io.utils.StringUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticateProvider<T extends VenusFrontendConnection, V>
extends AuthenticateProvider<T, V> {
    private static Logger logger = LoggerFactory.getLogger(SimpleAuthenticateProvider.class);
    private String username;
    private String password;
    private boolean useDummy = true;

    public boolean isUseDummy() {
        return this.useDummy;
    }

    public void setUseDummy(boolean useDummy) {
        this.useDummy = useDummy;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void beforeAuthing(T conn) {
        HandshakePacket handshake = new HandshakePacket();
        handshake.challenge = StringUtil.getRandomString((int)12);
        handshake.version = VenusMetaInfo.VENUS_VERSION;
        conn.setSeed(handshake.challenge);
        conn.write(handshake.toByteBuffer());
    }

    public void handle(T conn, V data) {
        this.handleData(conn, this.transferData(data));
    }

    protected abstract byte[] transferData(V var1);

    protected void handleData(T conn, byte[] message) {
        int type = AbstractServicePacket.getType((byte[])message);
        if (type != 0x3100000) {
            ErrorPacket error = new ErrorPacket();
            error.message = "connection must be authenticated before it send other type packet!";
            error.errorCode = 18004011;
            conn.write(error.toByteBuffer());
            return;
        }
        try {
            AuthenPacket authenPacket = AuthenPacketFactory.getInstance().createAuthenPacket(message);
            conn.setClientId(authenPacket.clientId);
            conn.setSerializeType(authenPacket.shakeSerializeType);
            if (this.isUseDummy()) {
                conn.setAuthenticated(true);
                conn.write(new OKPacket().toByteBuffer());
            } else {
                if (authenPacket instanceof PasswordAuthenPacket) {
                    PasswordAuthenPacket passPacket = (PasswordAuthenPacket)authenPacket;
                    boolean isSuccess = false;
                    if (StringUtils.equals((String)this.username, (String)passPacket.username)) {
                        isSuccess = true;
                    }
                    if (isSuccess) {
                        byte[] pBytes = PasswordAuthenPacket.encryptPasswd((String)this.password, (String)conn.getSeed());
                        isSuccess = ArrayUtils.isEquals((Object)pBytes, (Object)passPacket.encryptedPasswd);
                    }
                    if (isSuccess) {
                        this.onAuthingSuccess(conn);
                    } else {
                        this.onAuthingError(conn, "username or password error", 18004011);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("Accepting authenticate request: conn=" + conn.getId() + ", using PasswordAuthenPacket,username=" + passPacket.username + ", result=" + isSuccess);
                    }
                    return;
                }
                if (authenPacket instanceof DummyAuthenPacket) {
                    this.onAuthingError(conn, " Dummy authentication not support!!", 18004011);
                    if (logger.isInfoEnabled()) {
                        logger.info("Accepting authenticate request: conn=" + conn.getId() + ", using DummyAuthenPacket, result=false");
                    }
                    return;
                }
                this.onAuthingError(conn, " Unknown the authentication type ", 18004011);
                if (logger.isInfoEnabled()) {
                    logger.info("Accepting authenticate request: conn=" + conn.getId() + ", result=false");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof CodedException) {
                this.onAuthingError(conn, e.getMessage(), ((CodedException)e).getErrorCode());
            } else {
                this.onAuthingError(conn, e.getMessage(), 18005002);
            }
            return;
        }
    }

    protected void onAuthingError(T conn, String message, int errorCode) {
        ErrorPacket error = new ErrorPacket();
        error.message = message;
        error.errorCode = errorCode;
        conn.write(error.toByteBuffer());
    }

    protected void onAuthingSuccess(T conn) {
        conn.setAuthenticated(true);
        conn.write(new OKPacket().toByteBuffer());
    }
}

