/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend;

import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.VenusExceptionFactory;

public class Response {
    private Object result;
    private int errorCode;
    private String errorMessage;
    private Exception exception;

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int status) {
        this.errorCode = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setError(Throwable cause, VenusExceptionFactory venusExceptionFactory) {
        if (cause instanceof CodedException) {
            this.setErrorCode(((CodedException)cause).getErrorCode());
            this.setErrorMessage(cause.getMessage());
        } else {
            int errorCode = 0;
            if (venusExceptionFactory != null) {
                errorCode = venusExceptionFactory.getErrorCode(cause.getClass());
                if (errorCode != 0) {
                    this.setErrorCode(errorCode);
                } else {
                    this.setErrorCode(18005000);
                }
            } else {
                this.setErrorCode(18005000);
            }
            if (cause instanceof NullPointerException && cause.getMessage() == null) {
                this.setErrorMessage("Server Side error caused by NullPointerException");
            } else {
                this.setErrorMessage(cause.getMessage());
            }
        }
    }
}

