/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network.handler;

import com.meidusa.venus.backend.network.VenusClientConnection;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.Utils;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemotingInvocationListener<T>
implements InvocationListener<T> {
    private static Logger logger = Logger.getLogger(RemotingInvocationListener.class);
    private VenusClientConnection conn;
    private ReferenceInvocationListener<T> source;
    private boolean isResponsed = false;
    private AbstractServicePacket request;

    public boolean isResponsed() {
        return this.isResponsed;
    }

    public RemotingInvocationListener(VenusClientConnection conn, ReferenceInvocationListener<T> source, AbstractServicePacket request) {
        this.conn = conn;
        this.source = source;
        this.request = request;
    }

    public void callback(T object) {
        Serializer serializer = SerializerFactory.getSerializer((short)this.conn.getSerializeType());
        SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)response);
        response.callbackObject = object;
        response.identityData = this.source.getIdentityData();
        this.conn.postMessage(response.toByteBuffer());
        this.isResponsed = true;
    }

    public void onException(Exception e) {
        Serializer serializer = SerializerFactory.getSerializer((short)this.conn.getSerializeType());
        SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
        AbstractServicePacket.copyHead((AbstractServicePacket)this.request, (AbstractServicePacket)response);
        if (e instanceof CodedException) {
            CodedException codedException = (CodedException)e;
            response.errorCode = codedException.getErrorCode();
        }
        if (e != null) {
            Map mpd = Utils.getBeanPropertyDescriptor(e.getClass());
            HashMap additionalData = new HashMap();
            for (Map.Entry entry : mpd.entrySet()) {
                try {
                    additionalData.put(entry.getKey(), ((PropertyDescriptor)entry.getValue()).getReadMethod().invoke((Object)e, new Object[0]));
                }
                catch (Exception e1) {
                    logger.error((Object)"read bean properpty error", (Throwable)e1);
                }
            }
            response.additionalData = serializer.encode(additionalData);
        }
        response.errorMessage = e.getMessage();
        response.identityData = this.source.getIdentityData();
        this.conn.postMessage(response.toByteBuffer());
        this.isResponsed = true;
    }
}

