/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.network;

import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.authenticate.server.AuthResponseData;
import com.meidusa.toolkit.net.io.AbstractPacketMetaData;
import com.meidusa.toolkit.net.io.FramedInputStream;
import com.meidusa.toolkit.net.io.FramingOutputStream;
import com.meidusa.toolkit.net.io.PacketInputStream;
import com.meidusa.toolkit.net.io.PacketOutputStream;
import com.meidusa.toolkit.net.packet.AbstractPacket;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.io.VenusPacketMetaData;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.AuthenPacketFactory;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PingPacket;
import com.meidusa.venus.io.utils.StringUtil;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Date;
import org.apache.log4j.Logger;

public class VenusClientConnection
extends AuthingableConnection {
    private static Logger logger = Logger.getLogger(VenusClientConnection.class);
    public static OKPacket OK = new OKPacket();
    private long lastPingTime = System.currentTimeMillis();
    private long lastPongTime = System.currentTimeMillis();
    private long pingInterval = 10000L;
    private short serializeType = 1;
    private int clientId;
    private boolean proxy;
    private static VenusPacketMetaData PACKET_META_DATA = new VenusPacketMetaData();

    public VenusClientConnection(SocketChannel channel, long createStamp) {
        super(channel, createStamp);
    }

    public short getProtocol() {
        return this.getSerializeType();
    }

    public int getClientId() {
        return this.clientId;
    }

    public short getSerializeType() {
        return this.serializeType;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void postMessage(byte[] msg) {
        ByteBuffer buff = ByteBuffer.wrap(msg);
        this.postMessage(buff);
    }

    protected PacketInputStream createPacketInputStream() {
        return new FramedInputStream((AbstractPacketMetaData)PACKET_META_DATA, true);
    }

    protected PacketOutputStream createPacketOutputStream() {
        return new FramingOutputStream((AbstractPacketMetaData)PACKET_META_DATA, true);
    }

    public boolean needPing(long now) {
        return false;
    }

    protected void messageProcess(byte[] msg) {
        if (msg == null || msg.length < 24) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("conn ID=" + this.getId() + " , received packet size error, size=" + (msg == null ? 0 : msg.length)));
            }
            this.postClose(new IllegalArgumentException("packet size error size=" + (msg == null ? 0 : msg.length)));
            return;
        }
        int type = AbstractServicePacket.getType((byte[])msg);
        if (type == 0x1000002) {
            this.lastPongTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("receive pong packet from " + this.getId()));
            }
        }
        super.messageProcess(msg);
    }

    public void ping(long now) {
        this.postMessage(new PingPacket().toByteBuffer());
        this.lastPingTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("send ping packet to " + this.getId()));
        }
    }

    public boolean checkIdle(long now) {
        if (this.isAuthenticated()) {
            return false;
        }
        boolean idle = super.checkIdle(now);
        if (!idle && this.lastPingTime - this.lastPongTime > 2L * this.pingInterval) {
            logger.warn((Object)("receive pong packet timeout, id=" + this.getId() + ",lastPingTime=" + new Date(this.lastPingTime) + ",lastPongTime =" + new Date(this.lastPongTime)));
            return true;
        }
        long idleMillis = now - this._lastEvent;
        return idleMillis >= (long)this.getAuthingTimeout();
    }

    protected void beforeAuthing() {
        HandshakePacket handshakePacket = new HandshakePacket();
        handshakePacket.challenge = StringUtil.getRandomString((int)12);
        handshakePacket.version = "2.2.2-RELEASE";
        this.putStep(1, (AbstractPacket)handshakePacket);
        this.postMessage(handshakePacket.toByteBuffer());
    }

    protected void connectionAuthenticateSuccess(AuthResponseData data) {
        super.connectionAuthenticateSuccess(data);
        this.postMessage(OK.toByteBuffer());
    }

    protected void connectionAuthenticateFaild(AuthResponseData data) {
        super.connectionAuthenticateFaild(data);
        ErrorPacket error = new ErrorPacket();
        error.errorCode = data.code;
        error.message = data.message;
        this.postMessage(error.toByteBuffer());
    }

    public void handleMessage(Connection conn, byte[] message) {
        AuthenPacket autheticationPacket;
        int type = AbstractServicePacket.getType((byte[])message);
        if (type != 0x3100000) {
            ErrorPacket error = new ErrorPacket();
            error.message = "connection must be authenticated before it send other type packet!";
            error.errorCode = 18004000;
            this.postMessage(error.toByteBuffer());
        }
        try {
            autheticationPacket = AuthenPacketFactory.getInstance().createAuthenPacket(message);
            this.clientId = autheticationPacket.clientId;
            this.serializeType = autheticationPacket.shakeSerializeType;
        }
        catch (Exception e) {
            ErrorPacket error = new ErrorPacket();
            error.errorCode = e instanceof CodedException ? ((CodedException)e).getErrorCode() : 18005002;
            error.message = e.getMessage();
            this.postMessage(error.toByteBuffer());
            return;
        }
        this.getAuthenticateProvider().authenticateConnection((AuthingableConnection)this, (AbstractPacket)autheticationPacket);
    }
}

