/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.interceptor;

import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.venus.backend.EndpointInvocation;
import com.meidusa.venus.backend.interceptor.AbstractInterceptor;
import com.meidusa.venus.backend.interceptor.Configurable;
import com.meidusa.venus.backend.interceptor.config.CacheableInterceptorConfig;
import com.meidusa.venus.backend.interceptor.config.InterceptorConfig;
import com.meidusa.venus.cache.CacheClient;
import com.meidusa.venus.util.OgnlUtil;
import com.meidusa.venus.util.PropertyStringGenerator;
import java.util.HashMap;
import java.util.Map;
import ognl.OgnlException;
import org.apache.log4j.Logger;

public class CacheableInterceptor
extends AbstractInterceptor
implements Configurable {
    private static Logger logger = Logger.getLogger(CacheableInterceptor.class);
    private static CacheKeyGenerator keyGenerator = new CacheKeyGenerator("%{", "}");
    Map<Class<?>, Map<String, CacheableInterceptorConfig>> configMap;
    private CacheClient cacheClient;

    public CacheClient getCacheClient() {
        return this.cacheClient;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    @Override
    public Object intercept(EndpointInvocation invocation) {
        String ep;
        Class<?> serviceType = invocation.getEndpoint().getService().getType();
        CacheableInterceptorConfig config = this.getEndpointConfig(serviceType, ep = invocation.getEndpoint().getName());
        if (config == null) {
            return invocation.invoke();
        }
        String key = this.generateKey(config.getKey(), invocation.getContext().getParameters());
        switch (config.getOperation()) {
            case GET: {
                Object result = null;
                try {
                    result = this.cacheClient.get(key);
                }
                catch (Exception e) {
                    logger.error((Object)"Cache Operation Error:", (Throwable)e);
                }
                if (result != null) {
                    return result;
                }
                result = invocation.invoke();
                try {
                    this.cacheClient.set(key, result, config.getExpired());
                }
                catch (Exception e) {
                    logger.error((Object)"Cache Operation Error:", (Throwable)e);
                }
                return result;
            }
            case DELETE: {
                try {
                    this.cacheClient.delete(key);
                }
                catch (Exception e) {
                    logger.error((Object)"Cache Operation Error:", (Throwable)e);
                }
                return invocation.invoke();
            }
        }
        return invocation.invoke();
    }

    private String generateKey(String key, Map<String, Object> parameterMap) {
        return keyGenerator.getKey(key, parameterMap);
    }

    private CacheableInterceptorConfig getEndpointConfig(Class<?> clazz, String ep) {
        Map<String, CacheableInterceptorConfig> serviceConfigMap = this.configMap.get(clazz);
        if (serviceConfigMap == null) {
            return null;
        }
        return serviceConfigMap.get(ep);
    }

    @Override
    public void processConfig(Class<?> clazz, String ep, InterceptorConfig config) {
        Map<String, CacheableInterceptorConfig> serviceConfigMap = this.configMap.get(clazz);
        if (serviceConfigMap == null) {
            serviceConfigMap = new HashMap<String, CacheableInterceptorConfig>();
            this.configMap.put(clazz, serviceConfigMap);
        }
        if (config instanceof CacheableInterceptorConfig) {
            serviceConfigMap.put(ep, (CacheableInterceptorConfig)config);
        }
    }

    @Override
    public void init() throws InitialisationException {
        this.configMap = new HashMap();
        super.init();
    }

    public static class CacheKeyGenerator
    extends PropertyStringGenerator {
        public CacheKeyGenerator(String prefix, String suffix) {
            super(prefix, suffix);
        }

        protected String getString(String key, Object object) {
            String str = null;
            try {
                str = OgnlUtil.findString((Object)object, (String)key);
                return str;
            }
            catch (OgnlException e) {
                logger.error((Object)("can't get cache key for parameter map with expression: " + key + ", map: " + object + "."));
                return "";
            }
        }
    }
}

