package com.meidusa.venus.service.monitor;

public class PerformanceBean {

    private String name;
    /**
     * average request completed time 该值作为一个统计周期的平均值，跟参与前一个统计周期数据的无关
     */
    private double average;

    /**
     * 平均时间的 "经验值"，每次统计平均值以后，这个值将作为下一次统计的初始值（基数），不参与 reset
     */
    private double averageWithQueued;
    /**
     * request times
     */
    private long times;

    /**
     * start time or rest time
     */
    private long startTime = System.currentTimeMillis();

    public synchronized void calculateAverage(long current) {
        double j = (double) times / (double) (times + 1);
        double x = (double) average * j + (double) current / (double) (times + 1);
        double y = (double) averageWithQueued * j + (double) current / (double) (times + 1);
        averageWithQueued = y;
        average = x;
        times++;
    }

    public synchronized void rest() {
        average = 0;
        times = 0;
        startTime = System.currentTimeMillis();
    }

    public double getAverage() {
        return average;
    }

    public double getAverageWithQueued() {
        return averageWithQueued;
    }

    public long getTimes() {
        return times;
    }

    public long getStartTime() {
        return startTime;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
