/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.common.monitor;

import com.meidusa.venus.common.monitor.service.PerformanceBean;
import com.meidusa.venus.common.monitor.service.ServiceBean;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MonitorRuntime {
    static MonitorRuntime runtime = new MonitorRuntime();
    private Date uptime = new Date();
    private Map<String, ServiceBean> serviceMap = new HashMap<String, ServiceBean>();

    public static MonitorRuntime getInstance() {
        return runtime;
    }

    public Date getUptime() {
        return this.uptime;
    }

    public Map<String, ServiceBean> getServiceMap() {
        return this.serviceMap;
    }

    private MonitorRuntime() {
    }

    public void calculateAverage(String serviceName, String endpoint, long current) {
        this.getPerformanceBean(serviceName, endpoint).calculateAverage(current);
    }

    public void initEndPoint(String serviceName, String endpoint) {
        this.getPerformanceBean(serviceName, endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceBean getPerformanceBean(String serviceName, String endpoint) {
        ServiceBean bean = this.serviceMap.get(serviceName);
        if (bean == null) {
            Map<String, ServiceBean> map = this.serviceMap;
            synchronized (map) {
                bean = this.serviceMap.get(serviceName);
                if (bean == null) {
                    bean = new ServiceBean();
                    bean.setName(serviceName);
                    this.serviceMap.put(serviceName, bean);
                }
            }
        }
        PerformanceBean performance = bean.getEndpointPerformance(endpoint);
        return performance;
    }
}

