/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.utils;

import com.meidusa.venus.io.utils.Bits;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Input {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    final InputStream _in;

    public Input(InputStream in) {
        this._in = in;
    }

    public boolean hasRemaining() {
        try {
            return this._in.available() > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public int readInt() throws IOException {
        return Bits.readInt(this._in);
    }

    public long readLong() throws IOException {
        return Bits.readLong(this._in);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public byte[] readBinary() throws IOException {
        int size = Bits.readInt(this._in);
        this._in.read();
        byte[] bts = new byte[size];
        this._in.read(bts);
        return bts;
    }

    public byte[] readBytes() throws IOException {
        int size = Bits.readInt(this._in);
        byte[] bts = new byte[size];
        this._in.read(bts);
        return bts;
    }

    public long skip(int length) throws IOException {
        return this._in.skip(length);
    }

    public byte read() throws IOException {
        return (byte)(this._in.read() & 0xFF);
    }

    public void fill(byte[] b) throws IOException {
        this.fill(b, b.length);
    }

    public void fill(byte[] b, int len) throws IOException {
        int off = 0;
        while (len > 0) {
            int x = this._in.read(b, off, len);
            off += x;
            len -= x;
        }
    }

    public String readCStr() throws IOException {
        byte b;
        this.baos.reset();
        while ((b = this.read()) != 0) {
            this.baos.write(b);
        }
        try {
            return new String(this.baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException("impossible", e);
        }
    }

    public String readString() throws IOException {
        int lenght = this.readInt();
        byte[] content = new byte[lenght - 1];
        this.fill(content);
        String out = null;
        try {
            out = new String(content, "UTF-8");
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException("impossible", e);
        }
        this.read();
        return out;
    }
}

