package com.meidusa.venus.io.packet;

import java.io.UnsupportedEncodingException;

public class VenusRouterPacket  extends AbstractVenusPacket{

	private static final long serialVersionUID = 1L;
	public int srcIP;
	public short srcPort;
	public long requestTime;
	public int srcClientID;
	public long sequence;
	public byte[] data;
	
	@Override
	protected void readBody(ServicePacketBuffer buffer) {
		srcIP = buffer.readInt();
		srcPort = buffer.readShort();
		requestTime = buffer.readLong();
		srcClientID = buffer.readInt();
		sequence = buffer.readLong();
		data = buffer.readLengthCodedBytes();
	}

	@Override
	protected void writeBody(ServicePacketBuffer buffer)
			throws UnsupportedEncodingException {
		buffer.writeInt(srcIP);
		buffer.writeShort(srcPort);
		buffer.writeLong(requestTime);
		buffer.writeInt(srcClientID);
		buffer.writeLong(sequence);
		buffer.writeLengthCodedBytes(data);
		
	}

	@Override
	protected int calculatePacketSize() {
		return 42;
	}

	@Override
	 protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }
}
