package com.meidusa.venus.io.utils;

import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import com.meidusa.toolkit.net.util.Tuple;


public class Serialver {
	private static Method computeDefaultSUID;
	private static Method getDeclaredSUID;
	private static Map<Class<?>,Tuple<Long,Long>> computeSUIDMap =  new HashMap<Class<?>,Tuple<Long,Long>>();  
    public static long computeDefaultSUID(Class<?> cl){
    	try {
	    	if(computeDefaultSUID == null){
				computeDefaultSUID = ObjectStreamClass.class.getDeclaredMethod("computeDefaultSUID", new Class[]{Class.class});
				computeDefaultSUID.setAccessible(true);
	    	}
	    	
	    	Tuple<Long,Long> tuple = computeSUIDMap.get(cl);
	    	if(tuple == null){
	    		synchronized (computeSUIDMap) {
	    			tuple = computeSUIDMap.get(cl);
	    			if(tuple == null){
	    				tuple = new Tuple<Long,Long>();
	    				tuple.left = (Long)computeDefaultSUID.invoke(ObjectStreamClass.class, cl);
	    				computeSUIDMap.put(cl, tuple);
	    			}else{
	    				if(tuple.left == null){
	    					tuple.left = (Long)computeDefaultSUID.invoke(ObjectStreamClass.class, cl);
	    				}
	    			}
				}
	    	}else{
	    		if(tuple.left == null){
	    			synchronized (tuple) {
	    				if(tuple.left == null){
	    					tuple.left = (Long)computeDefaultSUID.invoke(ObjectStreamClass.class, cl);
	    				}
					}
	    		}
	    	}
	    	return tuple.left;
    	}catch(Exception e){
    	}
    	
    	return 0;
    }
    
    public static long getDeclaredSUID(Class<?> cl){
    	
    	try {
    		if(getDeclaredSUID == null){
    			getDeclaredSUID = ObjectStreamClass.class.getDeclaredMethod("getDeclaredSUID", new Class[]{Class.class});
    			getDeclaredSUID.setAccessible(true);
    		}
    		
    		Tuple<Long,Long> tuple = computeSUIDMap.get(cl);
	    	if(tuple == null){
	    		synchronized (computeSUIDMap) {
	    			tuple = computeSUIDMap.get(cl);
	    			if(tuple == null){
	    				tuple = new Tuple<Long,Long>();
	    				tuple.right = (Long)getDeclaredSUID.invoke(ObjectStreamClass.class, cl);
	    				computeSUIDMap.put(cl, tuple);
	    			}else{
	    				if(tuple.right == null){
	    					tuple.right = (Long)getDeclaredSUID.invoke(ObjectStreamClass.class, cl);
	    				}
	    			}
				}
	    	}else{
	    		if(tuple.right == null){
	    			synchronized (tuple) {
	    				if(tuple.right == null){
	    					tuple.right = (Long)getDeclaredSUID.invoke(ObjectStreamClass.class, cl);
	    				}
					}
	    		}
	    	}
	    	
	    	return tuple.right;
    	}catch(Exception e){
    	}
    	return 0;
    }
    
    public static void main(String[] args){
    	
    }
}
