/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.io.packet;

import com.meidusa.venus.io.packet.AbstractVenusPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public abstract class AbstractServicePacket
extends AbstractVenusPacket
implements PacketConstant {
    private static final long serialVersionUID = 1L;
    public byte serializeType = (byte)-1;
    public byte flags;
    public int clientId;
    public long clientRequestId;

    @Override
    protected void afterPacketWritten(ServicePacketBuffer buffer) {
        super.afterPacketWritten(buffer);
        int position = buffer.getPosition();
        buffer.setPosition(11);
        buffer.writeByte(this.flags);
        buffer.setPosition(position);
    }

    protected int calculatePacketSize() {
        return 24;
    }

    protected Class<ServicePacketBuffer> getPacketBufferClass() {
        return ServicePacketBuffer.class;
    }

    @Override
    protected void writeHead(ServicePacketBuffer buffer) {
        super.writeHead(buffer);
        buffer.writeByte(this.serializeType);
        buffer.writeByte(this.flags);
        buffer.writeInt(this.clientId);
        buffer.writeLong(this.clientRequestId);
        buffer.setPosition(24);
    }

    @Override
    protected void initHead(ServicePacketBuffer buffer) {
        super.initHead(buffer);
        this.serializeType = buffer.readByte();
        this.flags = buffer.readByte();
        this.clientId = buffer.readInt();
        this.clientRequestId = buffer.readLong();
        buffer.setPosition(24);
    }

    protected void readBody(ServicePacketBuffer buffer) {
    }

    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
    }

    public static long getPacketSequence(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? AbstractServicePacket.getLongB(buf, 16) : AbstractServicePacket.getLongL(buf, 16);
    }

    public static int getClientID(byte[] buf) {
        return ServicePacketBuffer.BUFFER.getByteOrder() == ByteOrder.BIG_ENDIAN ? AbstractServicePacket.getIntB(buf, 12) : AbstractServicePacket.getIntL(buf, 12);
    }

    public static void copyHead(AbstractServicePacket source, AbstractServicePacket target) {
        target.protocolVersion = source.protocolVersion;
        target.serializeType = source.serializeType;
        target.clientId = source.clientId;
        target.clientRequestId = source.clientRequestId;
    }
}

