/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    @Override
    public final void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        List list = (List)object;
        int size = list.size();
        int end = size - 1;
        if (end == -1) {
            out.append("[]");
            return;
        }
        out.append('[');
        for (int i = 0; i < end; ++i) {
            Object item = list.get(i);
            if (item == null) {
                out.append("null,");
                continue;
            }
            Class<?> clazz = item.getClass();
            if (clazz == Integer.class) {
                out.writeIntAndChar((Integer)item, ',');
                continue;
            }
            if (clazz == Long.class) {
                long val = (Long)item;
                out.writeLongAndChar(val, ',');
                continue;
            }
            serializer.write(item);
            out.append(',');
        }
        Object item = list.get(end);
        if (item == null) {
            out.append("null]");
        } else {
            Class<?> clazz = item.getClass();
            if (clazz == Integer.class) {
                out.writeIntAndChar((Integer)item, ']');
            } else if (clazz == Long.class) {
                out.writeLongAndChar((Long)item, ']');
            } else {
                serializer.write(item);
                out.append(']');
            }
        }
    }
}

