/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressDeserializer
implements ObjectDeserializer {
    public static final InetAddressDeserializer instance = new InetAddressDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        String host = (String)parser.parse();
        if (host == null) {
            return null;
        }
        if (host.length() == 0) {
            return null;
        }
        try {
            return (T)InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new JSONException("deserialize error", e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

