/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONArray;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.Feature;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.deserializer.CollectionDeserializer;
import com.meidusa.fastjson.parser.deserializer.FieldDeserializer;
import com.meidusa.fastjson.parser.deserializer.IntegerDeserializer;
import com.meidusa.fastjson.parser.deserializer.LongDeserializer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.parser.deserializer.StringDeserializer;
import com.meidusa.fastjson.util.ASMClassLoader;
import com.meidusa.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultObjectDeserializer
implements ObjectDeserializer {
    public void parseMap(DefaultExtJSONParser parser, Map<String, Object> map, Type valueType) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        if (lexer.token() != 12) {
            throw new JSONException("syntax error, expect {, actual " + lexer.token());
        }
        do {
            Object value;
            String key;
            lexer.skipWhitespace();
            char ch = lexer.getCurrent();
            if (parser.isEnabled(Feature.AllowArbitraryCommas)) {
                while (ch == ',') {
                    lexer.incrementBufferPosition();
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                }
            }
            if (ch == '\"') {
                key = lexer.scanSymbol(parser.getSymbolTable(), '\"');
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (ch != ':') {
                    throw new JSONException("expect ':' at " + lexer.pos());
                }
            } else {
                if (ch == '}') {
                    lexer.incrementBufferPosition();
                    lexer.resetStringPosition();
                    return;
                }
                if (ch == '\'') {
                    if (!parser.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbol(parser.getSymbolTable(), '\'');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                    }
                } else {
                    if (!parser.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                        throw new JSONException("syntax error");
                    }
                    key = lexer.scanSymbolUnQuoted(parser.getSymbolTable());
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                    }
                }
            }
            lexer.incrementBufferPosition();
            lexer.skipWhitespace();
            ch = lexer.getCurrent();
            lexer.resetStringPosition();
            lexer.nextToken();
            if (lexer.token() == 8) {
                value = null;
                lexer.nextToken();
            } else {
                value = parser.parseObject(valueType);
            }
            map.put(key, value);
        } while (lexer.token() != 13);
        lexer.nextToken();
    }

    public void parseObject(DefaultExtJSONParser parser, Object object) {
        JSONScanner lexer;
        block16: {
            Class<?> clazz = object.getClass();
            Map<String, FieldDeserializer> setters = parser.getConfig().getFieldDeserializers(clazz);
            lexer = (JSONScanner)parser.getLexer();
            if (lexer.token() != 12) {
                throw new JSONException("syntax error, expect {, actual " + lexer.token());
            }
            Object[] args = new Object[1];
            while (true) {
                FieldDeserializer fieldDeser;
                String key;
                if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                    if (lexer.token() != 13) {
                        if (lexer.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    break block16;
                }
                if ((fieldDeser = setters.get(key)) == null) {
                    if (!parser.isEnabled(Feature.IgnoreNotMatch)) {
                        throw new JSONException("setter not found, class " + clazz.getName() + ", property " + key);
                    }
                    lexer.nextTokenWithColon();
                    parser.parse();
                    if (lexer.token() != 13) continue;
                    lexer.nextToken();
                    return;
                }
                Method method = fieldDeser.getMethod();
                Class<?> fieldClass = method.getParameterTypes()[0];
                Type fieldType = method.getGenericParameterTypes()[0];
                if (fieldClass == Integer.TYPE) {
                    lexer.nextTokenWithColon(2);
                    args[0] = IntegerDeserializer.deserialze(parser);
                } else if (fieldClass == String.class) {
                    lexer.nextTokenWithColon(4);
                    args[0] = StringDeserializer.deserialze(parser);
                } else if (fieldClass == Long.TYPE) {
                    lexer.nextTokenWithColon(2);
                    args[0] = LongDeserializer.deserialze(parser);
                } else if (fieldClass == List.class) {
                    lexer.nextTokenWithColon(12);
                    args[0] = CollectionDeserializer.instance.deserialze(parser, fieldType);
                } else {
                    ObjectDeserializer fieldValueDeserializer = parser.getConfig().getDeserializer(fieldClass, fieldType);
                    lexer.nextTokenWithColon(fieldValueDeserializer.getFastMatchToken());
                    args[0] = fieldValueDeserializer.deserialze(parser, fieldType);
                }
                try {
                    method.invoke(object, args);
                }
                catch (Exception e) {
                    throw new JSONException("set proprety error, " + method.getName(), e);
                }
                if (lexer.token() != 16 && lexer.token() == 13) break;
            }
            lexer.nextToken(16);
            return;
        }
        lexer.nextToken(16);
    }

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        if (type instanceof Class) {
            return this.deserialze(parser, (Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.deserialze(parser, (ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return (T)parser.parse();
        }
        if (type instanceof WildcardType) {
            return (T)parser.parse();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gType = (GenericArrayType)type;
            Type cType = gType.getGenericComponentType();
            JSONArray array = new JSONArray();
            parser.parseArray(array, type);
            return DefaultObjectDeserializer.toObjectArray(parser, (Class)cType, array);
        }
        throw new JSONException("not support type : " + type);
    }

    private static <T> T toObjectArray(DefaultExtJSONParser parser, Class<T> componentType, JSONArray array) {
        int size = array.size();
        Object objArray = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            T element;
            Object value = array.get(i);
            if (componentType.isArray()) {
                element = DefaultObjectDeserializer.toObjectArray(parser, componentType, (JSONArray)value);
                Array.set(objArray, i, element);
                continue;
            }
            element = TypeUtils.cast(value, componentType, parser.getConfig());
            Array.set(objArray, i, element);
        }
        return (T)objArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T deserialze(DefaultExtJSONParser parser, ParameterizedType type) {
        try {
            void var5_12;
            Class rawClass;
            Type rawType = type.getRawType();
            if (!(rawType instanceof Class) || !Map.class.isAssignableFrom(rawClass = (Class)rawType)) throw new JSONException("not support type : " + type);
            if (Modifier.isAbstract(rawClass.getModifiers())) {
                if (rawClass == Map.class) {
                    HashMap hashMap = new HashMap();
                } else if (rawClass == SortedMap.class) {
                    TreeMap treeMap = new TreeMap();
                } else {
                    if (rawClass != ConcurrentMap.class) throw new JSONException("can not create instance : " + rawClass);
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                }
            } else if (rawClass == HashMap.class) {
                HashMap hashMap = new HashMap();
            } else {
                Map map = (Map)rawClass.newInstance();
            }
            Type valueType = type.getActualTypeArguments()[1];
            this.parseMap(parser, (Map<String, Object>)var5_12, valueType);
            return var5_12;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> T deserialze(DefaultExtJSONParser parser, Class<T> clazz) {
        AbstractMap value = null;
        if (clazz.isAssignableFrom(HashMap.class)) {
            value = new HashMap();
        } else if (clazz.isAssignableFrom(TreeMap.class)) {
            value = new TreeMap();
        } else if (clazz.isAssignableFrom(ConcurrentHashMap.class)) {
            value = new ConcurrentHashMap();
        }
        if (clazz == Class.class) {
            Object classValue = parser.parse();
            if (classValue == null) {
                return null;
            }
            if (classValue instanceof String) {
                return (T)ASMClassLoader.forName((String)classValue);
            }
        }
        try {
            this.parseObject(parser, value);
            return (T)value;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

