/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.annotation.JSONField;
import com.meidusa.fastjson.serializer.FieldSerializer;
import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.util.FieldInfo;

public class ObjectFieldSerializer
extends FieldSerializer {
    private ObjectSerializer fieldSerializer;
    private Class<?> runtimeFieldClass;
    private String format;

    public ObjectFieldSerializer(FieldInfo fieldInfo) {
        super(fieldInfo);
        JSONField annotation = fieldInfo.getAnnotation(JSONField.class);
        if (annotation != null) {
            this.format = annotation.format();
            if (this.format.trim().length() == 0) {
                this.format = null;
            }
        }
    }

    @Override
    public void writeProperty(JSONSerializer serializer, Object propertyValue) throws Exception {
        this.writePrefix(serializer);
        if (this.format != null) {
            serializer.writeWithFormat(propertyValue, this.format);
            return;
        }
        if (this.fieldSerializer == null) {
            this.runtimeFieldClass = propertyValue == null ? this.getMethod().getReturnType() : propertyValue.getClass();
            this.fieldSerializer = serializer.getObjectWriter(this.runtimeFieldClass);
        }
        if (propertyValue == null) {
            this.fieldSerializer.write(serializer, null);
            return;
        }
        if (propertyValue.getClass() == this.runtimeFieldClass) {
            this.fieldSerializer.write(serializer, propertyValue);
            return;
        }
        serializer.write(propertyValue);
    }
}

