/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.annotation.JSONField;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.serializer.FieldSerializer;
import com.meidusa.fastjson.serializer.FilterUtils;
import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.NumberFieldSerializer;
import com.meidusa.fastjson.serializer.ObjectFieldSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.serializer.SerializerFeature;
import com.meidusa.fastjson.util.FieldInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        String[] stringArray = aliasList;
        int n = aliasList.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            aliasMap.put(alias, alias);
            ++n2;
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = JavaBeanSerializer.computeGetters(clazz, aliasMap);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
    }

    protected boolean isWriteClassName(JSONSerializer serializer) {
        return serializer.isEnabled(SerializerFeature.WriteClassName);
    }

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        Object[] getters = this.getters;
        if (out.isEnabled(SerializerFeature.SortField)) {
            Arrays.sort(getters);
        }
        try {
            out.append('{');
            boolean commaFlag = false;
            if (this.isWriteClassName(serializer)) {
                out.writeFieldName("class");
                serializer.write(object.getClass());
                commaFlag = true;
            }
            int i = 0;
            while (i < getters.length) {
                Field field;
                Object fieldSerializer = getters[i];
                if (!serializer.isEnabled(SerializerFeature.SkipTransientField) || (field = ((FieldSerializer)fieldSerializer).getField()) == null || !Modifier.isTransient(field.getModifiers())) {
                    Object propertyValue = ((FieldSerializer)fieldSerializer).getPropertyValue(object);
                    if (FilterUtils.apply(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue)) {
                        String key = FilterUtils.processKey(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                        Object originalValue = propertyValue;
                        propertyValue = FilterUtils.processValue(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                        if (propertyValue != null || ((FieldSerializer)fieldSerializer).isWriteNull() || serializer.isEnabled(SerializerFeature.WriteMapNullValue)) {
                            if (commaFlag) {
                                out.append(',');
                            }
                            if (key != ((FieldSerializer)fieldSerializer).getName()) {
                                out.writeFieldName(key);
                                serializer.write(propertyValue);
                            } else if (originalValue != propertyValue) {
                                ((FieldSerializer)fieldSerializer).writePrefix(serializer);
                                serializer.write(propertyValue);
                            } else {
                                ((FieldSerializer)fieldSerializer).writeProperty(serializer, propertyValue);
                            }
                            commaFlag = true;
                        }
                    }
                }
                ++i;
            }
            out.append('}');
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
    }

    public FieldSerializer createFieldSerializer(FieldInfo fieldInfo) {
        Class<?> clazz = fieldInfo.getMethod().getReturnType();
        if (clazz == Number.class) {
            return new NumberFieldSerializer(fieldInfo);
        }
        return new ObjectFieldSerializer(fieldInfo);
    }

    /*
     * Unable to fully structure code
     */
    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap) {
        getters = new ArrayList<FieldInfo>();
        var6_3 = clazz.getMethods();
        var5_4 = var6_3.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block10: {
                block14: {
                    block12: {
                        block13: {
                            block11: {
                                method = var6_3[var4_5];
                                methodName = method.getName();
                                if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) break block10;
                                annotation = method.getAnnotation(JSONField.class);
                                if (annotation == null) break block11;
                                if (!annotation.serialize()) break block10;
                                if (annotation.name().length() != 0) {
                                    propertyName = annotation.name();
                                    if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                                        getters.add(new FieldInfo(propertyName, method, null));
                                        ** GOTO lbl43
                                    } else {
                                        ** GOTO lbl19
                                    }
                                }
                                break block11;
lbl19:
                                // 2 sources

                                break block10;
                            }
                            if (!methodName.startsWith("get")) break block12;
                            if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) break block10;
                            propertyName = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
                            field = ParserConfig.getField(clazz, propertyName);
                            if (field == null || (fieldAnnotation = field.getAnnotation(JSONField.class)) == null || fieldAnnotation.name().length() == 0) break block13;
                            propertyName = fieldAnnotation.name();
                            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block10;
                        }
                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block10;
                        getters.add(new FieldInfo(propertyName, method, field));
                    }
                    if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) break block10;
                    propertyName = String.valueOf(Character.toLowerCase(methodName.charAt(2))) + methodName.substring(3);
                    field = ParserConfig.getField(clazz, propertyName);
                    if (field == null || (fieldAnnotation = field.getAnnotation(JSONField.class)) == null || fieldAnnotation.name().length() == 0) break block14;
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block10;
                }
                if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                    getters.add(new FieldInfo(propertyName, method, field));
                }
            }
            ++var4_5;
        }
        return getters;
    }
}

