/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InetSocketAddressDeserializer
implements ObjectDeserializer {
    public static final InetSocketAddressDeserializer instance = new InetSocketAddressDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        parser.accept(12);
        InetAddress address = null;
        int port = 0;
        while (true) {
            String key = lexer.symbol(parser.getSymbolTable());
            lexer.nextToken();
            if (key.equals("address")) {
                parser.accept(17);
                address = parser.parseObject(InetAddress.class);
            } else if (key.equals("port")) {
                parser.accept(17);
                if (lexer.token() != 2) {
                    throw new JSONException("port is not int");
                }
                port = lexer.intValue();
                lexer.nextToken();
            } else {
                parser.accept(17);
                parser.parse();
            }
            if (lexer.token() != 16) break;
            lexer.nextToken();
        }
        parser.accept(13);
        return (T)new InetSocketAddress(address, port);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

