/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser;

public class SymbolTable {
    public static final int DEFAULT_TABLE_SIZE = 128;
    private final Entry[] buckets;
    private final String[] symbols;
    private final char[][] symbols_char;
    private final int indexMask;

    public SymbolTable() {
        this(128);
    }

    public SymbolTable(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
        this.symbols = new String[tableSize];
        this.symbols_char = new char[tableSize][];
    }

    public String addSymbol(String symbol) {
        return this.addSymbol(symbol.toCharArray(), 0, symbol.length(), symbol.hashCode());
    }

    public String addSymbol(char[] buffer, int offset, int len) {
        int hash = SymbolTable.hash(buffer, offset, len);
        return this.addSymbol(buffer, offset, len, hash);
    }

    public String addSymbol(char[] buffer, int offset, int len, int hash) {
        int bucket = hash & this.indexMask;
        String sym = this.symbols[bucket];
        boolean match = true;
        if (sym != null) {
            if (sym.length() == len) {
                char[] characters = this.symbols_char[bucket];
                int i = 0;
                while (i < len) {
                    if (buffer[offset + i] != characters[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (match) {
                    return sym;
                }
            } else {
                match = false;
            }
        }
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            block11: {
                char[] characters = entry.characters;
                if (len == characters.length && hash == entry.hashCode) {
                    int i = 0;
                    while (i < len) {
                        if (buffer[offset + i] == characters[i]) {
                            ++i;
                            continue;
                        }
                        break block11;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.buckets[bucket] = entry = new Entry(buffer, offset, len, hash, this.buckets[bucket]);
        if (match) {
            this.symbols[bucket] = entry.symbol;
            this.symbols_char[bucket] = entry.characters;
        }
        return entry.symbol;
    }

    public static final int hash(char[] buffer, int offset, int len) {
        int h = 0;
        int off = offset;
        int i = 0;
        while (i < len) {
            h = 31 * h + buffer[off++];
            ++i;
        }
        return h;
    }

    protected static final class Entry {
        public final String symbol;
        public final int hashCode;
        public final char[] characters;
        public final byte[] bytes;
        public Entry next;

        public Entry(char[] ch, int offset, int length, int hash, Entry next) {
            this.characters = new char[length];
            System.arraycopy(ch, offset, this.characters, 0, length);
            this.symbol = new String(this.characters).intern();
            this.next = next;
            this.hashCode = hash;
            this.bytes = null;
        }
    }
}

