/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util.concurrent;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.util.concurrent.MultiQueueManager;
import com.meidusa.venus.util.concurrent.MultiQueueRunnable;
import com.meidusa.venus.util.concurrent.MultipleQueue;
import com.meidusa.venus.util.concurrent.Named;
import com.meidusa.venus.util.concurrent.QueueConfig;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MultiBlockingQueue<E extends MultiQueueRunnable>
extends AbstractQueue<E>
implements BlockingQueue<E>,
MultipleQueue {
    final Queue<Tuple<QueueConfig, BlockingQueue<E>>> waitingList = new LinkedList<Tuple<QueueConfig, BlockingQueue<E>>>();
    private MultiQueueManager<E> manager;
    final ReentrantLock lock = new ReentrantLock(false);
    final Condition notEmpty = this.lock.newCondition();
    private int size = 0;
    private int capacity;

    public MultiBlockingQueue(MultiQueueManager<E> manager) {
        this(manager, Integer.MAX_VALUE);
    }

    public MultiBlockingQueue(MultiQueueManager<E> manager, int capacity) {
        this.capacity = capacity;
        this.manager = manager;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getWaitingQueueSize() {
        return this.waitingList.size();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        int i = 0;
        for (Tuple<QueueConfig, Queue<E>> tuple : this.manager.getAll()) {
            int count = ((Queue)tuple.right).size();
            if (!((Queue)tuple.right).removeAll(c)) continue;
            i += count;
        }
        return i;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int i = 0;
        int j = maxElements;
        for (Tuple<QueueConfig, Queue<E>> tuple : this.manager.getAll()) {
            int count = ((Queue)tuple.right).size();
            if (!((Queue)tuple.right).removeAll(c)) continue;
            i += count;
            if ((j -= count) <= 0) break;
        }
        return i;
    }

    protected Tuple<QueueConfig, BlockingQueue<E>> takeQueue() throws InterruptedException {
        while (true) {
            try {
                Tuple<QueueConfig, BlockingQueue<E>> entry;
                while (true) {
                    if ((entry = this.waitingList.remove()) == null) {
                        this.notEmpty.await();
                        continue;
                    }
                    ((QueueConfig)entry.getLeft()).setInWaiting(false);
                    if (((BlockingQueue)entry.right).size() > 0 && ((QueueConfig)entry.left).getRunningSize() < ((QueueConfig)entry.left).getMaxActive()) break;
                }
                return entry;
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            catch (NoSuchElementException e) {
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException ie) {
                    this.notEmpty.signal();
                    throw ie;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Tuple<QueueConfig, BlockingQueue<E>> pollQueue() {
        try {
            Tuple<QueueConfig, BlockingQueue<E>> entry;
            do {
                if ((entry = this.waitingList.remove()) == null) {
                    return null;
                }
                ((QueueConfig)entry.getLeft()).setInWaiting(false);
            } while (((BlockingQueue)entry.right).size() <= 0 || ((QueueConfig)entry.left).getRunningSize() >= ((QueueConfig)entry.left).getMaxActive());
            return entry;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Tuple<QueueConfig, BlockingQueue<E>> peakQueue() {
        try {
            Tuple<QueueConfig, BlockingQueue<E>> entry;
            do {
                if ((entry = this.waitingList.peek()) != null) continue;
                return null;
            } while (((BlockingQueue)entry.right).size() <= 0 || ((QueueConfig)entry.left).getRunningSize() >= ((QueueConfig)entry.left).getMaxActive());
            return entry;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Tuple<QueueConfig, BlockingQueue<E>> pollQueue(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        while (true) {
            try {
                Tuple<QueueConfig, BlockingQueue<E>> entry;
                while (true) {
                    if (this.size <= 0) {
                        nanos = this.notEmpty.awaitNanos(nanos);
                    }
                    if ((entry = this.waitingList.remove()) == null) {
                        if (nanos <= 0L) {
                            return null;
                        }
                        nanos = this.notEmpty.awaitNanos(nanos);
                        continue;
                    }
                    ((QueueConfig)entry.getLeft()).setInWaiting(false);
                    if (((BlockingQueue)entry.right).size() > 0 && ((QueueConfig)entry.left).getRunningSize() < ((QueueConfig)entry.left).getMaxActive()) break;
                }
                return entry;
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            catch (NoSuchElementException e) {
                try {
                    if (nanos <= 0L) {
                        return null;
                    }
                    nanos = this.notEmpty.awaitNanos(nanos);
                }
                catch (InterruptedException ie) {
                    this.notEmpty.signal();
                    return null;
                }
            }
        }
    }

    @Override
    public boolean offer(E e) {
        Tuple<QueueConfig, Queue<E>> tuple = this.manager.getQueueTuple((Named)e);
        ((MultiQueueRunnable)e).setQueue(this, tuple);
        boolean success = ((BlockingQueue)tuple.right).offer(e);
        if (success) {
            this.lock.lock();
            try {
                ++this.size;
                this.putToWaitingList(tuple, true);
            }
            finally {
                this.lock.unlock();
            }
        }
        return success;
    }

    private void putToWaitingList(Tuple<QueueConfig, BlockingQueue<E>> tuple, boolean needSignal) {
        if (((QueueConfig)tuple.left).getRunningSize() < ((QueueConfig)tuple.left).getMaxActive() && ((BlockingQueue)tuple.right).size() > 0 && !((QueueConfig)tuple.left).isInWaiting() && this.waitingList.add(tuple)) {
            ((QueueConfig)tuple.left).setInWaiting(true);
            this.notEmpty.signal();
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Tuple<QueueConfig, Queue<E>> tuple = this.manager.getQueueTuple((Named)e);
        ((MultiQueueRunnable)e).setQueue(this, tuple);
        boolean success = ((BlockingQueue)tuple.right).offer(e, timeout, unit);
        if (success) {
            this.lock.lock();
            try {
                ++this.size;
                this.putToWaitingList(tuple, true);
            }
            finally {
                this.lock.unlock();
            }
        }
        return success;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            Tuple<QueueConfig, BlockingQueue<E>> tuple = null;
            tuple = this.pollQueue(timeout, unit);
            if (tuple == null) {
                return null;
            }
            MultiQueueRunnable e = (MultiQueueRunnable)((BlockingQueue)tuple.right).poll(timeout, unit);
            if (e != null) {
                --this.size;
                ((QueueConfig)tuple.left).incrementAndGet();
            }
            this.putToWaitingList(tuple, false);
            MultiQueueRunnable multiQueueRunnable = e;
            return (E)multiQueueRunnable;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        Tuple<QueueConfig, Queue<E>> tuple = this.manager.getQueueTuple((Named)e);
        ((MultiQueueRunnable)e).setQueue(this, tuple);
        ((BlockingQueue)tuple.right).put(e);
        this.lock.lock();
        try {
            ++this.size;
            this.putToWaitingList(tuple, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        Tuple<QueueConfig, BlockingQueue<E>> tuple = null;
        try {
            tuple = this.takeQueue();
            MultiQueueRunnable e = (MultiQueueRunnable)((BlockingQueue)tuple.right).take();
            if (e != null) {
                --this.size;
                ((QueueConfig)tuple.left).incrementAndGet();
            }
            this.putToWaitingList(tuple, false);
            MultiQueueRunnable multiQueueRunnable = e;
            return (E)multiQueueRunnable;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        this.lock.lock();
        Tuple<QueueConfig, BlockingQueue<E>> tuple = null;
        try {
            tuple = this.pollQueue();
            if (tuple == null) {
                return null;
            }
            MultiQueueRunnable e = (MultiQueueRunnable)((BlockingQueue)tuple.right).poll();
            if (e != null) {
                --this.size;
                ((QueueConfig)tuple.left).incrementAndGet();
            }
            this.putToWaitingList(tuple, false);
            MultiQueueRunnable multiQueueRunnable = e;
            return (E)multiQueueRunnable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void finished(Tuple tuple, long start, long finished) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            ((QueueConfig)tuple.left).decrementAndGet();
            ((QueueConfig)tuple.left).addExecutTime(finished - start, finished);
            this.putToWaitingList(tuple, true);
        }
        finally {
            lock.unlock();
        }
    }
}

