/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util.concurrent;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.util.concurrent.MultiQueueManager;
import com.meidusa.venus.util.concurrent.Named;
import com.meidusa.venus.util.concurrent.QueueConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class DefaultMultiQueueManager<E>
implements MultiQueueManager<E> {
    private Map<String, Tuple<QueueConfig, Queue<E>>> namedQueueMap = new HashMap<String, Tuple<QueueConfig, Queue<E>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple<QueueConfig, Queue<E>> getQueueTuple(Named named) {
        Tuple<QueueConfig, Queue<E>> tuple = this.namedQueueMap.get(named.getName());
        if (tuple == null) {
            Map<String, Tuple<QueueConfig, Queue<E>>> map = this.namedQueueMap;
            synchronized (map) {
                tuple = this.namedQueueMap.get(named.getName());
                if (tuple == null) {
                    tuple = this.newTuple(named);
                    this.namedQueueMap.put(named.getName(), tuple);
                }
            }
        }
        return tuple;
    }

    public Tuple<QueueConfig, Queue<E>> newTuple(Named named) {
        QueueConfig config = this.getConfig(named);
        Tuple tuple = new Tuple((Object)config, this.createQueue(config));
        return tuple;
    }

    public Queue<E> createQueue(QueueConfig config) {
        return new LinkedList();
    }

    public QueueConfig getConfig(Named named) {
        QueueConfig config = new QueueConfig();
        config.setMaxActive(50);
        config.setMaxQueue(100000);
        config.setName(named.getName());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tuple<QueueConfig, Queue<E>>> getAll() {
        ArrayList<Tuple<QueueConfig, Queue<Tuple<QueueConfig, Queue<E>>>>> list = new ArrayList<Tuple<QueueConfig, Queue<Tuple<QueueConfig, Queue<E>>>>>();
        Map<String, Tuple<QueueConfig, Queue<E>>> map = this.namedQueueMap;
        synchronized (map) {
            for (Map.Entry<String, Tuple<QueueConfig, Queue<E>>> it : this.namedQueueMap.entrySet()) {
                list.add(it.getValue());
            }
            return list;
        }
    }
}

