/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.metainfo;

import com.meidusa.venus.annotations.Param;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.metainfo.EndpointParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class EndpointParameterUtil {
    private static Map<Method, EndpointParameter[]> parameterMap = new HashMap<Method, EndpointParameter[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EndpointParameter[] getPrameters(Method method) {
        EndpointParameter[] params = parameterMap.get(method);
        if (params == null) {
            Map<Method, EndpointParameter[]> map = parameterMap;
            synchronized (map) {
                params = parameterMap.get(method);
                if (params == null) {
                    Type[] itypes = method.getGenericParameterTypes();
                    Annotation[][] annotations = method.getParameterAnnotations();
                    params = new EndpointParameter[itypes.length];
                    int i = 0;
                    while (i < itypes.length) {
                        Param param = (Param)AnnotationUtil.getAnnotation(annotations[i], Param.class);
                        params[i] = new EndpointParameter();
                        params[i].setParamName(param.name());
                        params[i].setType(itypes[i]);
                        params[i].setOptional(param.optional());
                        params[i].setDefaultValue(param.defaultValue());
                        ++i;
                    }
                    parameterMap.put(method, params);
                }
            }
        }
        return params;
    }
}

