/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util;

import com.meidusa.venus.util.Utils;
import java.security.SecureRandom;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusLoggerUtil {
    private static SecureRandom numberGenerator = new SecureRandom();
    public static final String REQUEST_TRACE_ID = "REQUEST_TRACE_ID";
    private static final String REQUEST_TRACE_MSG_WITH_PARAMS = "request id={},service={},params={}";
    private static final String REQUEST_TRACE_MSG_WITHOUT_PARAMS = "request id={},service={}";
    private static final String RECEIVE_TRACE_MSG_WITH_PARAMS = "receive id={},service={},params={}";
    private static final String RECEIVE_TRACE_MSG_WITHOUT_PARAMS = "receive id={},service={}";
    private static final String CALLBACK_TRACE_MSG_WITH_PARAMS = "callback id={},service={},params={}";
    private static final String CALLBACK_TRACE_MSG_WITHOUT_PARAMS = "callback id={},service={}";
    private static Logger REUEST_LOGGER = LoggerFactory.getLogger((String)"venus.tracer");

    public static byte[] randomUUID() {
        SecureRandom ng = numberGenerator;
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return randomBytes;
    }

    public static void logRequest(byte[] traceId, String apiName, Map params) {
        if (REUEST_LOGGER.isDebugEnabled()) {
            REUEST_LOGGER.debug(REQUEST_TRACE_MSG_WITH_PARAMS, new Object[]{new UUID(traceId).toString(), apiName, params});
        } else if (REUEST_LOGGER.isInfoEnabled()) {
            REUEST_LOGGER.info(REQUEST_TRACE_MSG_WITHOUT_PARAMS, (Object)new UUID(traceId).toString(), (Object)apiName);
        }
    }

    public static void logRequest(byte[] traceId, String apiName) {
        if (REUEST_LOGGER.isDebugEnabled() || REUEST_LOGGER.isInfoEnabled()) {
            REUEST_LOGGER.info(REQUEST_TRACE_MSG_WITHOUT_PARAMS, (Object)new UUID(traceId).toString(), (Object)apiName);
        }
    }

    public static void logReceive(byte[] traceId, String apiName, Map params) {
        if (REUEST_LOGGER.isDebugEnabled()) {
            REUEST_LOGGER.debug(RECEIVE_TRACE_MSG_WITH_PARAMS, new Object[]{new UUID(traceId).toString(), apiName, Utils.toString(params)});
        } else if (REUEST_LOGGER.isInfoEnabled()) {
            REUEST_LOGGER.info(RECEIVE_TRACE_MSG_WITHOUT_PARAMS, (Object)new UUID(traceId).toString(), (Object)apiName);
        }
    }

    public static void logReceive(byte[] traceId, String apiName) {
        if (REUEST_LOGGER.isDebugEnabled() || REUEST_LOGGER.isInfoEnabled()) {
            REUEST_LOGGER.info(RECEIVE_TRACE_MSG_WITHOUT_PARAMS, (Object)new UUID(traceId).toString(), (Object)apiName);
        }
    }

    public static void logCallback(byte[] traceId, String apiName, Map params) {
        if (REUEST_LOGGER.isDebugEnabled()) {
            REUEST_LOGGER.debug(CALLBACK_TRACE_MSG_WITH_PARAMS, new Object[]{new UUID(traceId).toString(), apiName, Utils.toString(params)});
        } else if (REUEST_LOGGER.isInfoEnabled()) {
            REUEST_LOGGER.info(CALLBACK_TRACE_MSG_WITHOUT_PARAMS, (Object)new UUID(traceId).toString(), (Object)apiName);
        }
    }

    public static void logCallback(byte[] traceId, String apiName) {
        if (REUEST_LOGGER.isDebugEnabled() || REUEST_LOGGER.isInfoEnabled()) {
            REUEST_LOGGER.info(CALLBACK_TRACE_MSG_WITHOUT_PARAMS, (Object)new UUID(traceId).toString(), (Object)apiName);
        }
    }

    public static class UUID {
        private final long mostSigBits;
        private final long leastSigBits;

        private UUID(byte[] data) {
            int i;
            long msb = 0L;
            long lsb = 0L;
            assert (data.length == 16);
            for (i = 0; i < 8; ++i) {
                msb = msb << 8 | (long)(data[i] & 0xFF);
            }
            for (i = 8; i < 16; ++i) {
                lsb = lsb << 8 | (long)(data[i] & 0xFF);
            }
            this.mostSigBits = msb;
            this.leastSigBits = lsb;
        }

        public String toString() {
            return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
        }

        private static String digits(long val, int digits) {
            long hi = 1L << digits * 4;
            return Long.toHexString(hi | val & hi - 1L).substring(1);
        }
    }
}

