/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Utils {
    private static Map<Class, Map<String, Type>> typeMap = new HashMap<Class, Map<String, Type>>();
    private static Map<Class, Map<String, PropertyDescriptor>> pdMap = new HashMap<Class, Map<String, PropertyDescriptor>>();

    public static boolean arrayEquals(String[] s1, String[] s2) {
        Object[] s1Copy = Arrays.copyOf(s1, s1.length);
        Object[] s2Copy = Arrays.copyOf(s2, s2.length);
        Arrays.sort(s1Copy);
        Arrays.sort(s2Copy);
        return Arrays.equals(s1Copy, s2Copy);
    }

    private static boolean arrayContains1(String[] parent, String[] child) {
        if (child.length == 0) {
            return true;
        }
        Object[] parentCopy = Arrays.copyOf(parent, parent.length);
        Object[] childCopy = Arrays.copyOf(child, child.length);
        Arrays.sort(parentCopy);
        Arrays.sort(childCopy);
        int i = 0;
        int j = 0;
        while (i < parentCopy.length && j < childCopy.length) {
            if (((String)childCopy[j]).equals(parentCopy[i])) {
                ++i;
                ++j;
                continue;
            }
            ++j;
        }
        return i == parentCopy.length;
    }

    public static <T> T[] subArray(T[] original, Predication<T> predication) {
        ArrayList<T> container = new ArrayList<T>(original.length);
        for (T item : original) {
            if (!predication.predict(item)) continue;
            container.add(item);
        }
        return container.toArray(Arrays.copyOf(original, 0));
    }

    public static String toString(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return "{ }";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ?> entry = it.next();
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static boolean arrayContains(String[] parent, String[] child) {
        if (parent == null || parent.length == 0) {
            return true;
        }
        Arrays.sort(child);
        for (String i : parent) {
            if (Arrays.binarySearch(child, i) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PropertyDescriptor> getBeanPropertyDescriptor(Class<?> clazz) {
        Map<String, PropertyDescriptor> pdm = pdMap.get(clazz);
        if (pdm == null) {
            Map<Class, Map<String, PropertyDescriptor>> map = pdMap;
            synchronized (map) {
                pdm = pdMap.get(clazz);
                if (pdm == null) {
                    pdm = new HashMap<String, PropertyDescriptor>();
                    pdMap.put(clazz, pdm);
                    try {
                        PropertyDescriptor[] pds;
                        BeanInfo info = Introspector.getBeanInfo(clazz, Throwable.class);
                        for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
                            pdm.put(pd.getName(), pd);
                        }
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
            }
        }
        return pdm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Type> getBeanFieldType(Class<?> clazz, Class stopClazz) {
        Map<String, Type> tmap = typeMap.get(clazz);
        if (tmap == null) {
            Map<Class, Map<String, Type>> map = typeMap;
            synchronized (map) {
                tmap = typeMap.get(clazz);
                if (tmap == null) {
                    tmap = new HashMap<String, Type>();
                    typeMap.put(clazz, tmap);
                    Map<String, PropertyDescriptor> pdm = Utils.getBeanPropertyDescriptor(clazz);
                    for (Class<?> superClazz = clazz; superClazz != stopClazz && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
                        Field[] fields;
                        for (Field field : fields = superClazz.getDeclaredFields()) {
                            PropertyDescriptor pd = pdm.get(field.getName());
                            if (pd == null) continue;
                            tmap.put(field.getName(), field.getGenericType());
                        }
                    }
                }
            }
        }
        return tmap;
    }

    public static void main(String[] args) {
        int i;
        String[] s1 = new String[]{"name", "hello", "abcd", "qwer", "qwerqweraa", "maf3", "123"};
        String[] s2 = new String[]{"hdkje", "abcd", "qwer", "ouidb", "qwerqweraa", "heoidyhh", "maf3", "837dbb", "123", "name", "hello"};
        boolean result = false;
        result = Utils.arrayContains1(s1, s2);
        long start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            result = Utils.arrayContains1(s1, s2);
        }
        System.out.println("result=" + result + "," + (System.currentTimeMillis() - start));
        result = Utils.arrayContains(s1, s2);
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            result = Utils.arrayContains(s1, s2);
        }
        System.out.println("result=" + result + "," + (System.currentTimeMillis() - start));
    }

    public static interface Predication<T> {
        public boolean predict(T var1);
    }
}

