/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.poolable;

import bsh.Interpreter;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.heartbeat.HeartbeatManager;
import com.meidusa.venus.heartbeat.Status;
import com.meidusa.venus.poolable.HashFunction;
import com.meidusa.venus.poolable.ObjectPool;
import com.meidusa.venus.poolable.PoolableObject;
import com.meidusa.venus.poolable.RequestLoadbalanceObjectPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;

public class MultipleLoadBalanceObjectPool
implements ObjectPool,
RequestLoadbalanceObjectPool {
    private static Logger logger = Logger.getLogger(MultipleLoadBalanceObjectPool.class);
    static int HashMod = Integer.valueOf(System.getProperty("venus.HashFunction.mod", "1024"));
    static HashFunction function = new DefaultFunction();
    private static ThreadLocal<Interpreter> interreterThreadLocal;
    public static final int LOADBALANCING_ROUNDROBIN = 1;
    public static final int LOADBALANCING_WEIGHTBASED = 2;
    public static final int LOADBALANCING_HA = 3;
    public static final int LOADBALANCING_HASH = 4;
    private boolean enable;
    private String name;
    private int loadbalance;
    private AtomicLong currentCount = new AtomicLong(0L);
    private ObjectPool[] objectPools;
    private ObjectPool[] runtimeObjectPools;
    private int index = 0;
    private ActiveNumComparator comparator = new ActiveNumComparator();
    private boolean valid;
    private SortedMap<Integer, ObjectPool> circle = new TreeMap<Integer, ObjectPool>();
    MultipleHeartbeatDelayed delayed = new MultipleHeartbeatDelayed(3L, TimeUnit.SECONDS, this);

    public MultipleLoadBalanceObjectPool() {
    }

    public MultipleLoadBalanceObjectPool(int loadbalance, ObjectPool ... objectPools) {
        this.loadbalance = loadbalance;
        this.setObjectPools(objectPools);
    }

    public void setLoadbalance(int loadbalance) {
        this.loadbalance = loadbalance;
    }

    public void setObjectPools(ObjectPool[] objectPools) {
        this.objectPools = objectPools;
        this.runtimeObjectPools = (ObjectPool[])objectPools.clone();
        if (this.runtimeObjectPools.length > 0) {
            for (int i = 0; i < this.runtimeObjectPools.length; ++i) {
                this.circle.put(HashMod / this.runtimeObjectPools.length * i, this.runtimeObjectPools[i]);
            }
        }
    }

    public void addObject() throws Exception {
        throw new UnsupportedOperationException();
    }

    public ObjectPool getConsistenthashPool(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = function.hash(key != null ? key.toString() : "");
        if (!this.circle.containsKey(hash)) {
            SortedMap<Integer, ObjectPool> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey() : tailMap.firstKey();
        }
        return (ObjectPool)this.circle.get(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object borrowObject(Map<String, Object> parameters, Endpoint endpoint) throws Exception {
        if (!StringUtils.isEmpty((String)endpoint.loadbalancingKey())) {
            Interpreter interpreter = interreterThreadLocal.get();
            try {
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    interpreter.set(entry.getKey(), entry.getValue());
                }
                Object key = interpreter.eval(endpoint.loadbalancingKey());
                ObjectPool pool = null;
                while (true) {
                    if ((pool = this.getConsistenthashPool(key)) == null) {
                        throw new Exception("poolName=" + this.name + ", no valid pools");
                    }
                    if (pool.isValid()) break;
                    this.validate();
                }
                Object object = pool.borrowObject();
                return object;
            }
            finally {
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    interpreter.unset(entry.getKey());
                }
            }
        }
        return this.borrowObject();
    }

    public Object borrowObject() throws Exception {
        ObjectPool pool = null;
        while (true) {
            ObjectPool[] poolsTemp;
            if ((poolsTemp = this.runtimeObjectPools).length == 0) {
                throw new Exception("poolName=" + this.name + ", no valid pools");
            }
            if (this.loadbalance == 1) {
                long current = this.currentCount.getAndIncrement();
                pool = poolsTemp[(int)(current % (long)poolsTemp.length)];
            } else if (this.loadbalance == 2) {
                if (poolsTemp.length > 1) {
                    ObjectPool[] objectPoolsCloned = (ObjectPool[])poolsTemp.clone();
                    Arrays.sort(objectPoolsCloned, this.comparator);
                    pool = objectPoolsCloned[0];
                } else if (poolsTemp.length == 1) {
                    pool = poolsTemp[0];
                }
            } else if (this.loadbalance == 3) {
                pool = this.index < poolsTemp.length ? poolsTemp[this.index] : poolsTemp[0];
            } else {
                throw new Exception("poolName=" + this.name + " loadbalance parameter error,parameter loadbalance in [1,2,3]");
            }
            if (pool.isValid()) break;
            this.validate();
        }
        return pool.borrowObject();
    }

    public void clear() throws Exception, UnsupportedOperationException {
    }

    public int getNumActive() throws UnsupportedOperationException {
        int active = 0;
        for (ObjectPool pool : this.objectPools) {
            active += pool.getNumActive();
        }
        return active;
    }

    public int getNumIdle() throws UnsupportedOperationException {
        int idle = 0;
        for (ObjectPool pool : this.objectPools) {
            idle += pool.getNumIdle();
        }
        return idle;
    }

    public void invalidateObject(Object obj) throws Exception {
        PoolableObject poolableObject = (PoolableObject)obj;
        ObjectPool pool = poolableObject.getObjectPool();
        pool.invalidateObject(obj);
    }

    public void returnObject(Object obj) throws Exception {
        PoolableObject poolableObject = (PoolableObject)obj;
        ObjectPool pool = poolableObject.getObjectPool();
        pool.returnObject(obj);
    }

    public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("setFactory is not supported in class=" + this.getClass().getName());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public void setEnable(boolean isEnabled) {
        this.enable = isEnabled;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        HeartbeatManager.addHeartbeat(this.delayed);
        for (ObjectPool pool : this.objectPools) {
            Object conn = null;
            try {
                conn = pool.borrowObject();
            }
            catch (Exception e) {
            }
            finally {
                if (conn != null) {
                    try {
                        pool.returnObject(conn);
                    }
                    catch (Exception e) {}
                }
            }
        }
        this.validate();
    }

    public void close() throws Exception {
        HeartbeatManager.removeHeartbeat(this.delayed);
    }

    @Override
    public synchronized boolean validate() {
        ArrayList<ObjectPool> poolList = new ArrayList<ObjectPool>();
        TreeMap<Integer, ObjectPool> hashPool = new TreeMap<Integer, ObjectPool>();
        for (int i = 0; i < this.objectPools.length; ++i) {
            if (!this.objectPools[i].isValid()) continue;
            poolList.add(this.objectPools[i]);
            hashPool.put(HashMod / this.objectPools.length * i, this.objectPools[i]);
        }
        this.runtimeObjectPools = poolList.toArray(new ObjectPool[poolList.size()]);
        ObjectPool[] poolsTemp = this.runtimeObjectPools;
        this.circle = hashPool;
        return poolsTemp.length != 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    static {
        String functionName = System.getProperty("venus.HashFunction.class", DefaultFunction.class.getName());
        try {
            Class<?> clazz = Class.forName(functionName);
            function = (HashFunction)clazz.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("hashFunction=" + functionName + " not found,using default:" + DefaultFunction.class.getName()), (Throwable)e);
        }
        interreterThreadLocal = new ThreadLocal<Interpreter>(){

            @Override
            protected Interpreter initialValue() {
                return new Interpreter();
            }
        };
    }

    public static class MultipleHeartbeatDelayed
    extends ObjectPool.ObjectPoolHeartbeatDelayed {
        public MultipleHeartbeatDelayed(long nsTime, TimeUnit timeUnit, MultipleLoadBalanceObjectPool pool) {
            super(nsTime, timeUnit, pool);
        }

        @Override
        public boolean isCycle() {
            return true;
        }

        @Override
        public Status doCheck() {
            return super.doCheck();
        }
    }

    protected static class ActiveNumComparator
    implements Comparator<ObjectPool> {
        protected ActiveNumComparator() {
        }

        @Override
        public int compare(ObjectPool o1, ObjectPool o2) {
            return o1.getNumActive() - o2.getNumActive();
        }
    }

    public static class DefaultFunction
    implements HashFunction {
        @Override
        public int hash(Object key) {
            if (key == null) {
                return 0;
            }
            return Math.abs(key.hashCode()) % HashMod;
        }
    }
}

