/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.util;

import java.io.File;
import org.apache.log4j.Logger;

public abstract class FileWatchdog
extends Thread {
    private static Logger logger = Logger.getLogger(FileWatchdog.class);
    public static final long DEFAULT_DELAY = 60000L;
    protected long delay = 60000L;
    File[] files;
    long lastModif = 0L;
    boolean warnedAlready = false;
    boolean interrupted = false;

    protected FileWatchdog(File ... files) {
        long last = 0L;
        if (files == null || files.length == 0) {
            throw new NullPointerException("create fileWatchDog error,File is null");
        }
        for (File file : files) {
            last = file.lastModified() > last ? file.lastModified() : last;
        }
        this.files = files;
        this.setDaemon(true);
        this.checkAndConfigure();
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean needFire = false;
        for (File file : this.files) {
            boolean fileExists;
            try {
                fileExists = file.exists();
            }
            catch (SecurityException e) {
                logger.warn((Object)("Was not allowed to read check file existance, file:[" + file.getAbsolutePath() + "]."));
                this.interrupted = true;
                return;
            }
            if (fileExists) {
                long l = file.lastModified();
                if (l <= this.lastModif) continue;
                this.lastModif = l;
                needFire = true;
                continue;
            }
            if (this.warnedAlready) continue;
            logger.debug((Object)("[" + file.getAbsolutePath() + "] does not exist."));
            this.warnedAlready = true;
        }
        if (needFire) {
            this.doOnChange();
            this.warnedAlready = false;
        }
    }

    @Override
    public void run() {
        while (!this.interrupted) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }
}

