/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.poolable;

import com.meidusa.venus.heartbeat.HeartbeatDelayed;
import com.meidusa.venus.heartbeat.Status;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public interface ObjectPool
extends org.apache.commons.pool.ObjectPool {
    public static final Logger logger = Logger.getLogger(ObjectPool.class);

    public boolean isEnable();

    public void setEnable(boolean var1);

    public boolean isValid();

    public void setValid(boolean var1);

    public boolean validate();

    public String getName();

    public void setName(String var1);

    public static class ObjectPoolHeartbeatDelayed
    extends HeartbeatDelayed {
        private ObjectPool pool;

        @Override
        public boolean isCycle() {
            return false;
        }

        public ObjectPool getPool() {
            return this.pool;
        }

        public ObjectPoolHeartbeatDelayed(long nsTime, TimeUnit timeUnit, ObjectPool pool) {
            super(nsTime, timeUnit);
            this.pool = pool;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectPoolHeartbeatDelayed) {
                ObjectPoolHeartbeatDelayed other = (ObjectPoolHeartbeatDelayed)obj;
                return other.pool == this.pool && this.getClass() == obj.getClass();
            }
            return false;
        }

        public int hashCode() {
            return this.pool == null ? this.getClass().hashCode() : this.getClass().hashCode() + this.pool.hashCode();
        }

        @Override
        public Status doCheck() {
            if (this.pool.validate()) {
                this.pool.setValid(true);
                return Status.VALID;
            }
            this.pool.setValid(false);
            return Status.INVALID;
        }

        @Override
        public String getName() {
            return this.pool.getName();
        }
    }

    public static class ActiveNumComparator
    implements Comparator<ObjectPool> {
        @Override
        public int compare(ObjectPool o1, ObjectPool o2) {
            return o1.getNumActive() - o2.getNumActive();
        }
    }
}

