/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.factory;

import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.ConnectionConnector;
import com.meidusa.toolkit.net.buffer.BufferQueue;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public abstract class BackendConnectionFactory {
    protected int receiveBufferSize = 16;
    protected int sendBufferSize = 8;
    protected int maxPacketSize = 0x1000000;
    protected int writeQueueCapcity = 8;
    protected long idleTimeout = 28800000L;
    private ConnectionConnector connector;
    protected String host;
    protected int port;

    public ConnectionConnector getConnector() {
        return this.connector;
    }

    public void setConnector(ConnectionConnector connector) {
        this.connector = connector;
    }

    public BackendConnection make() throws IOException {
        SocketChannel channel = this.openSocketChannel();
        BackendConnection c = this.create(channel);
        this.postConnect(c, this.getConnector());
        return c;
    }

    protected abstract BackendConnection create(SocketChannel var1);

    protected SocketChannel openSocketChannel() throws IOException {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            socket.setReceiveBufferSize(this.receiveBufferSize * 1024);
            socket.setSendBufferSize(this.sendBufferSize * 1024);
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
        }
        catch (IOException e) {
            BackendConnectionFactory.closeChannel(channel);
            throw e;
        }
        catch (RuntimeException e) {
            BackendConnectionFactory.closeChannel(channel);
            throw e;
        }
        return channel;
    }

    protected void postConnect(BackendConnection c, ConnectionConnector connector) {
        c.setMaxPacketSize(this.maxPacketSize);
        c.setWriteQueue(new BufferQueue(this.writeQueueCapcity));
        c.setIdleTimeout(this.idleTimeout);
        c.setHost(this.host);
        c.setPort(this.port);
        c.setConnector(connector);
        connector.postConnect(c);
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int socketRecvBuffer) {
        this.receiveBufferSize = socketRecvBuffer;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int socketSendBuffer) {
        this.sendBufferSize = socketSendBuffer;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getWriteQueueCapcity() {
        return this.writeQueueCapcity;
    }

    public void setWriteQueueCapcity(int writeQueueCapcity) {
        this.writeQueueCapcity = writeQueueCapcity;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private static void closeChannel(SocketChannel channel) {
        if (channel == null) {
            return;
        }
        Socket socket = channel.socket();
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

