/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class BufferQueue {
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ByteBuffer[] items;
    private final ReentrantLock lock;
    private final Condition notFull;
    private ByteBuffer attachment;

    public BufferQueue(int capacity) {
        this.items = new ByteBuffer[capacity];
        this.lock = new ReentrantLock();
        this.notFull = this.lock.newCondition();
    }

    public ByteBuffer attachment() {
        return this.attachment;
    }

    public void attach(ByteBuffer buffer) {
        this.attachment = buffer;
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public void put(ByteBuffer buffer) throws InterruptedException {
        ByteBuffer[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.count == items.length) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            this.insert(buffer);
        }
        finally {
            lock.unlock();
        }
    }

    public ByteBuffer poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == 0) {
                return null;
            }
            ByteBuffer byteBuffer = this.extract();
            return byteBuffer;
        }
        finally {
            lock.unlock();
        }
    }

    private void insert(ByteBuffer buffer) {
        this.items[this.putIndex] = buffer;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
    }

    private ByteBuffer extract() {
        ByteBuffer[] items = this.items;
        ByteBuffer buffer = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return buffer;
    }

    private int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }
}

