/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.common.heartbeat.Status;
import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.BackendConnectionPool;
import com.meidusa.toolkit.net.GenericHeartbeatDelayed;
import com.meidusa.toolkit.net.factory.BackendConnectionFactory;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingBackendConnectionPool<F extends BackendConnectionFactory, V extends BackendConnection>
implements BackendConnectionPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingBackendConnectionPool.class);
    private volatile long currentCounter = 0L;
    private final F factory;
    private final int size;
    private final BackendConnection[] items;
    private String name;
    private boolean valid = true;
    private boolean closed = false;
    private final Map<Integer, Object> lockMap = new HashMap<Integer, Object>();
    private GenericHeartbeatDelayed delay;

    public PollingBackendConnectionPool(String name, F factory, int size) {
        this.size = size;
        this.items = new BackendConnection[size];
        this.factory = factory;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackendConnection borrowObject() throws Exception {
        BackendConnection conn = null;
        int j = 0;
        while (j < this.size) {
            int i;
            if ((conn = this.items[i = (int)(this.currentCounter++ % (long)this.size)]) == null) {
                Object lockObject;
                Object object = lockObject = this.lockMap.get(i);
                synchronized (object) {
                    conn = this.items[i];
                    if (conn == null) {
                        conn = this.items[i] = ((BackendConnectionFactory)this.factory).make();
                        conn.setPool(this);
                    }
                }
            }
            if (!conn.isClosed()) {
                conn.setActive(true);
                return conn;
            }
            this.items[i] = null;
            ++j;
        }
        this.setValid(false);
        throw new InvalidObjectException("invalid pool=" + this.name);
    }

    @Override
    public void returnObject(BackendConnection c) {
        c.setActive(false);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.delay != null) {
            HeartbeatManager.removeHeartbeat((HeartbeatDelayed)this.delay);
        }
        BackendConnection[] backendConnectionArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            BackendConnection conn = backendConnectionArray[n2];
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
            ++n2;
        }
    }

    @Override
    public int getActive() {
        return this.items.length;
    }

    @Override
    public void deActive(BackendConnection c) {
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean b) {
        this.valid = b;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void init() {
        this.delay = new GenericHeartbeatDelayed(1L, TimeUnit.SECONDS, this){
            Status last;
            {
                this.last = Status.VALID;
            }

            @Override
            public Status doCheck() {
                Status status = this.check0();
                try {
                    if (this.last == Status.INVALID && status == Status.VALID) {
                        int i = 0;
                        while (i < PollingBackendConnectionPool.this.size) {
                            status = this.check0();
                            if (status == Status.INVALID) {
                                Status status2 = status;
                                return status2;
                            }
                            ++i;
                        }
                        Status status3 = status;
                        return status3;
                    }
                    Status status4 = status;
                    return status4;
                }
                finally {
                    this.last = status;
                }
            }

            private Status check0() {
                BackendConnection conn = null;
                try {
                    conn = this.pool.borrowObject();
                    if (conn != null) {
                        if (conn.isClosed()) {
                            this.pool.setValid(false);
                            Status status = Status.INVALID;
                            return status;
                        }
                        this.pool.setValid(true);
                        Status status = Status.VALID;
                        return status;
                    }
                    Status status = Status.INVALID;
                    return status;
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    this.pool.setValid(false);
                    Status status = Status.INVALID;
                    return status;
                }
                finally {
                    if (conn != null) {
                        this.pool.returnObject(conn);
                    }
                }
            }
        };
        int i = 0;
        while (i < this.items.length) {
            this.lockMap.put(i, new Object());
            ++i;
        }
        i = 0;
        while (i < this.items.length) {
            try {
                this.items[i] = ((BackendConnectionFactory)this.factory).make();
            }
            catch (IOException e) {
                LOGGER.error("init pool error ,name=" + this.name, (Throwable)e);
                this.setValid(false);
                break;
            }
            ++i;
        }
        HeartbeatManager.addHeartbeat((HeartbeatDelayed)this.delay);
    }
}

