/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.AbstractConnection;
import com.meidusa.toolkit.util.TimeUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FrontendConnection
extends AbstractConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrontendConnection.class);
    protected String host;
    protected int port;
    protected int localPort;
    protected long idleTimeout;
    protected boolean isAccepted;

    public FrontendConnection(SocketChannel channel) {
        super(channel);
        Socket socket = channel.socket();
        this.host = socket.getInetAddress().getHostAddress();
        this.port = socket.getPort();
        this.localPort = socket.getLocalPort();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isIdleTimeout() {
        return TimeUtil.currentTimeMillis() > Math.max(this.lastWriteTime, this.lastReadTime) + this.idleTimeout;
    }

    public void setAccepted(boolean isAccepted) {
        this.isAccepted = isAccepted;
    }

    @Override
    protected void idleCheck() {
        if (this.isIdleTimeout()) {
            LOGGER.warn(String.valueOf(this.toString()) + " idle timeout");
            this.close();
        }
    }

    @Override
    public void handle(final byte[] data) {
        if (this.processor.getExecutor() != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        FrontendConnection.this.handler.handle(FrontendConnection.this, data);
                    }
                    catch (Throwable t) {
                        FrontendConnection.this.handleError(16003009, t);
                    }
                }
            };
            this.processor.getExecutor().execute(runnable);
        } else {
            try {
                this.handler.handle(this, data);
            }
            catch (Throwable t) {
                this.handleError(16003009, t);
            }
        }
    }

    @Override
    protected boolean isConnectionReset(Throwable t) {
        if (t instanceof IOException) {
            String msg = t.getMessage();
            return msg != null && msg.contains("Connection reset by peer");
        }
        return false;
    }

    public String toString() {
        return "[thread=" + Thread.currentThread().getName() + ",class=" + this.getClass().getSimpleName() + ",host=" + this.host + ",port=" + this.port + ']';
    }
}

