/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.BackendConnection;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.util.LoopingThread;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConnector
extends LoopingThread {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConnectionConnector.class);
    private static final ConnectIdGenerator ID_GENERATOR = new ConnectIdGenerator();
    private final String name;
    private final Selector selector;
    private final BlockingQueue<BackendConnection> connectQueue;
    protected ConnectionManager[] processors;
    private int nextProcessor;
    private long connectCount;
    private int executorSize = Runtime.getRuntime().availableProcessors();

    public ConnectionConnector(String name) throws IOException {
        super.setName(name);
        this.name = name;
        this.selector = Selector.open();
        this.connectQueue = new LinkedBlockingQueue<BackendConnection>();
    }

    public long getConnectCount() {
        return this.connectCount;
    }

    public void setProcessors(ConnectionManager[] processors) {
        this.processors = processors;
    }

    public int getExecutorSize() {
        return this.executorSize;
    }

    public void setExecutorSize(int executorSize) {
        this.executorSize = executorSize;
    }

    public void postConnect(BackendConnection c) {
        this.connectQueue.offer(c);
        this.selector.wakeup();
    }

    public void initProcessors() throws IOException {
        if (this.processors == null) {
            this.processors = new ConnectionManager[Runtime.getRuntime().availableProcessors()];
            int i = 0;
            while (i < this.processors.length) {
                try {
                    this.processors[i] = new ConnectionManager(String.valueOf(this.getName()) + "-Manager-" + i, this.getExecutorSize());
                    this.processors[i].start();
                }
                catch (IOException e) {
                    LOGGER.error("create connection Manager error", (Throwable)e);
                    this.shutdown();
                }
                ++i;
            }
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        try {
            this.initProcessors();
        }
        catch (IOException e) {
            LOGGER.error("create connection Manager error", (Throwable)e);
            this.shutdown();
        }
    }

    @Override
    public void iterate() throws IOException {
        ++this.connectCount;
        this.selector.select(1000L);
        this.connect(this.selector);
        Set<SelectionKey> keys = this.selector.selectedKeys();
        try {
            for (SelectionKey key : keys) {
                Object att = key.attachment();
                if (att != null && key.isValid() && key.isConnectable()) {
                    this.finishConnect(key, att);
                    continue;
                }
                key.cancel();
            }
        }
        finally {
            keys.clear();
        }
    }

    @Override
    protected void handleIterateFailure(Throwable e) {
        if (e instanceof ClosedSelectorException) {
            super.handleIterateFailure(e);
        } else if (e instanceof InterruptedException) {
            super.handleIterateFailure(e);
        } else {
            LOGGER.error(this.name, e);
        }
    }

    private void connect(Selector selector) {
        BackendConnection c = null;
        while ((c = (BackendConnection)this.connectQueue.poll()) != null) {
            try {
                c.connect(selector);
            }
            catch (Throwable e) {
                c.handleError(16003002, e);
            }
        }
    }

    private void finishConnect(SelectionKey key, Object att) {
        BackendConnection c = (BackendConnection)att;
        try {
            if (c.finishConnect()) {
                this.clearSelectionKey(key);
                c.setId(ConnectionConnector.ID_GENERATOR.getId());
                ConnectionManager processor = null;
                processor = c.getProcessor() != null ? c.getProcessor() : this.nextProcessor();
                c.setProcessor(processor);
                processor.postRegister(c);
            }
        }
        catch (Throwable e) {
            this.clearSelectionKey(key);
            c.handleError(16003003, e);
        }
    }

    private void clearSelectionKey(SelectionKey key) {
        if (key.isValid()) {
            key.attach(null);
            key.cancel();
        }
    }

    public int getFrontends() {
        int i = 0;
        ConnectionManager[] connectionManagerArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionManager manager = connectionManagerArray[n2];
            i += manager.getFrontends();
            ++n2;
        }
        return i;
    }

    public int getBackends() {
        int i = 0;
        ConnectionManager[] connectionManagerArray = this.processors;
        int n = this.processors.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionManager manager = connectionManagerArray[n2];
            i += manager.getBackends();
            ++n2;
        }
        return i;
    }

    private ConnectionManager nextProcessor() {
        if (++this.nextProcessor == this.processors.length) {
            this.nextProcessor = 0;
        }
        return this.processors[this.nextProcessor];
    }

    private static class ConnectIdGenerator {
        private static final long MAX_VALUE = Long.MAX_VALUE;
        private long connectId = 0L;
        private final Object lock = new Object();

        private ConnectIdGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getId() {
            Object object = this.lock;
            synchronized (object) {
                if (this.connectId >= Long.MAX_VALUE) {
                    this.connectId = 0L;
                }
                return ++this.connectId;
            }
        }
    }
}

